/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.gamerules;

import com.therandomlabs.randomconfigs.RandomConfigs;
import com.therandomlabs.randomconfigs.gamerules.DefaultGameRule;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonElement;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonObject;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1934;
import net.minecraft.class_1937;

public final class DefaultGameRules {
    public static final String MODE_OR_WORLD_TYPE_SPECIFIC = "MODE_OR_WORLD_TYPE_SPECIFIC";
    public static final String DIFFICULTY = "DIFFICULTY";
    public static final String WORLD_BORDER_SIZE = "WORLD_BORDER_SIZE";
    public static final Path JSON = RandomConfigs.getJson("defaultgamerules");
    public static final List<String> DEFAULT = RandomConfigs.readLines(DefaultGameRules.class.getResourceAsStream("/data/randomconfigs/defaultgamerules.json"));

    public static void create() throws IOException {
        Files.write(JSON, DEFAULT, new OpenOption[0]);
    }

    public static boolean exists() {
        return Files.exists(JSON, new LinkOption[0]);
    }

    public static void ensureExists() throws IOException {
        if (!DefaultGameRules.exists()) {
            DefaultGameRules.create();
        }
    }

    public static List<DefaultGameRule> get(int gamemode, String worldType) throws IOException {
        if (!DefaultGameRules.exists()) {
            DefaultGameRules.create();
            return Collections.emptyList();
        }
        JsonObject json = RandomConfigs.readJson(JSON);
        RandomConfigs.writeJson(JSON, json);
        ArrayList<DefaultGameRule> gameRules = new ArrayList<DefaultGameRule>();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            String key = entry.getKey();
            JsonElement value = entry.getValue();
            if (key.equals(WORLD_BORDER_SIZE)) {
                gameRules.add(new DefaultGameRule(WORLD_BORDER_SIZE, value.toString(), false));
                continue;
            }
            if (!(value instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)value;
            if (key.equals(MODE_OR_WORLD_TYPE_SPECIFIC)) {
                DefaultGameRules.getSpecific(gameRules, object, gamemode, worldType);
                continue;
            }
            DefaultGameRule gameRule = DefaultGameRules.get(key, object);
            if (gameRule == null) continue;
            gameRules.add(gameRule);
        }
        return gameRules;
    }

    public static List<DefaultGameRule> get(class_1937 world) {
        try {
            return DefaultGameRules.get(world.method_8401().method_210().method_8379(), world.method_8527().method_8635());
        }
        catch (Exception ex) {
            RandomConfigs.crashReport("Failed to read default gamerules", ex);
            return null;
        }
    }

    private static void getSpecific(List<DefaultGameRule> gameRules, JsonObject json, int gamemode, String worldType) {
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            JsonElement value;
            String key = entry.getKey();
            if (!DefaultGameRules.matches(key, gamemode, worldType) || !((value = entry.getValue()) instanceof JsonObject)) continue;
            DefaultGameRules.get(gameRules, (JsonObject)value);
        }
    }

    private static boolean matches(String key, int gamemode, String worldType) {
        class_1934 gameType = class_1934.method_8384((int)gamemode);
        String[] split = key.split(":");
        if (!split[0].isEmpty()) {
            String[] gamemodes = split[0].split(",");
            boolean gamemodeFound = false;
            for (String mode : gamemodes) {
                if (class_1934.method_8378((String)mode, null) != gameType) continue;
                gamemodeFound = true;
                break;
            }
            if (!gamemodeFound) {
                return false;
            }
        }
        if (split.length > 1) {
            for (String type : split[1].split(",")) {
                if (!type.equals(worldType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void get(List<DefaultGameRule> gameRules, JsonObject json) {
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            DefaultGameRule gameRule;
            String key = entry.getKey();
            JsonElement value = entry.getValue();
            if (key.equals(WORLD_BORDER_SIZE)) {
                gameRules.add(new DefaultGameRule(WORLD_BORDER_SIZE, value.toString(), false));
                continue;
            }
            if (!(value instanceof JsonObject) || (gameRule = DefaultGameRules.get(key, (JsonObject)value)) == null) continue;
            gameRules.add(gameRule);
        }
    }

    private static DefaultGameRule get(String key, JsonObject object) {
        JsonElement value = object.get("value");
        if (!(value instanceof JsonPrimitive)) {
            return null;
        }
        JsonElement forced = object.get("forced");
        if (!(forced instanceof JsonPrimitive)) {
            return null;
        }
        return new DefaultGameRule(key, ((JsonPrimitive)value).asString(), (Boolean)((JsonPrimitive)forced).getValue());
    }
}

