/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.gamerules;

import com.therandomlabs.randomconfigs.RandomConfigs;
import com.therandomlabs.randomconfigs.api.event.world.CreateSpawnPositionCallback;
import com.therandomlabs.randomconfigs.api.event.world.WorldInitializeCallback;
import com.therandomlabs.randomconfigs.gamerules.DefaultGameRule;
import com.therandomlabs.randomconfigs.gamerules.DefaultGameRules;
import com.therandomlabs.randomconfigs.gamerules.RCGameRules;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_31;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class DefaultGameRulesHandler
implements WorldInitializeCallback,
CreateSpawnPositionCallback {
    private static final Field LEVEL_PROPERTIES = RandomConfigs.findField(class_1937.class, "properties", "field_9232");
    private static final Field GAME_RULES = RandomConfigs.removeFinalModifier(RandomConfigs.findField(class_31.class, "gameRules", "field_154"));
    private static List<DefaultGameRule> defaultGameRules;

    @Override
    public void onInitialize(class_3218 world) {
        defaultGameRules = DefaultGameRules.get((class_1937)world);
        try {
            MinecraftServer server = world.method_8503();
            class_31 properties = (class_31)LEVEL_PROPERTIES.get(world);
            class_1928 gamerules = (class_1928)GAME_RULES.get(properties);
            HashSet<String> forced = new HashSet<String>();
            for (DefaultGameRule rule : defaultGameRules) {
                if (!rule.forced || rule.key.equals("DIFFICULTY") || rule.key.equals("WORLD_BORDER_SIZE")) continue;
                forced.add(rule.key);
                gamerules.method_8359(rule.key, rule.value, server);
            }
            GAME_RULES.set(properties, (Object)new RCGameRules(server, gamerules, forced));
        }
        catch (Exception ex) {
            RandomConfigs.crashReport("Failed to set GameRules instance", ex);
        }
    }

    @Override
    public void onCreateSpawnPosition(class_3218 world) {
        if (world.field_9247.method_12460() != class_2874.field_13072) {
            return;
        }
        class_31 properties = null;
        try {
            properties = (class_31)LEVEL_PROPERTIES.get(world);
        }
        catch (Exception ex) {
            RandomConfigs.crashReport("Failed to retrieve level properties", ex);
        }
        if (defaultGameRules == null) {
            defaultGameRules = DefaultGameRules.get((class_1937)world);
        }
        for (DefaultGameRule rule : defaultGameRules) {
            if (rule.key.equals("DIFFICULTY")) {
                try {
                    properties.method_208(class_1267.valueOf((String)rule.value.toUpperCase(Locale.ENGLISH)));
                    properties.method_186(rule.forced);
                }
                catch (IllegalArgumentException ex) {
                    RandomConfigs.LOGGER.error("Invalid difficulty: " + rule.value);
                }
                continue;
            }
            if (rule.key.equals("WORLD_BORDER_SIZE")) {
                try {
                    world.method_8621().method_11969((double)Integer.parseInt(rule.value));
                }
                catch (NumberFormatException ex) {
                    RandomConfigs.LOGGER.error("Invalid world border size: " + rule.value);
                }
                continue;
            }
            properties.method_146().method_8359(rule.key, rule.value, world.method_8503());
        }
        defaultGameRules = null;
    }
}

