/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl;

import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.Jankson;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonElement;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonNull;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonPrimitive;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.AnnotatedElement;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.ArrayParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.CommentParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.NumberParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.ObjectParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.ParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.StringParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.SyntaxError;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.TokenParserContext;
import java.util.Locale;

public class ElementParserContext
implements ParserContext<AnnotatedElement> {
    String comment = null;
    AnnotatedElement result = null;
    boolean childActive = false;

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        if (Character.isWhitespace(codePoint)) {
            return true;
        }
        switch (codePoint) {
            case 35: 
            case 47: {
                loader.push(new CommentParserContext(codePoint), it -> {
                    this.comment = it;
                });
                return true;
            }
            case 34: 
            case 39: {
                loader.push(new StringParserContext(codePoint), this::setResult);
                this.childActive = true;
                return true;
            }
            case 123: {
                loader.push(new ObjectParserContext(), this::setResult);
                this.childActive = true;
                return false;
            }
            case 91: {
                loader.push(new ArrayParserContext(), this::setResult);
                this.childActive = true;
                return true;
            }
            case 93: 
            case 125: {
                System.out.println("Curious! Bailing from our intermediate context.");
                return false;
            }
        }
        if (Character.isDigit(codePoint) || codePoint == 45 || codePoint == 43 || codePoint == 46) {
            loader.push(new NumberParserContext(codePoint), this::setResult);
            this.childActive = true;
            return true;
        }
        loader.push(new TokenParserContext(codePoint), it -> {
            if (it.asString().toLowerCase(Locale.ROOT).equals("null")) {
                this.setResult(JsonNull.INSTANCE);
            } else if (it.asString().toLowerCase(Locale.ROOT).equals("true")) {
                this.setResult(JsonPrimitive.TRUE);
            } else if (it.asString().toLowerCase(Locale.ROOT).equals("false")) {
                this.setResult(JsonPrimitive.FALSE);
            } else {
                loader.throwDelayed(new SyntaxError("Found unrecognized token '" + it.asString() + "' while looking for a json element of any type."));
            }
        });
        this.childActive = true;
        return true;
    }

    public void setResult(JsonElement elem) {
        this.result = new AnnotatedElement(elem, this.comment);
    }

    @Override
    public void eof() throws SyntaxError {
        if (!this.childActive) {
            throw new SyntaxError("Unexpected end-of-file while looking for a json element!");
        }
    }

    @Override
    public boolean isComplete() {
        return this.result != null;
    }

    @Override
    public AnnotatedElement getResult() throws SyntaxError {
        return this.result;
    }
}

