/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl;

import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.Jankson;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonPrimitive;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.ParserContext;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.SyntaxError;

public class NumberParserContext
implements ParserContext<JsonPrimitive> {
    private String numberString = "";
    private boolean complete = false;
    private String acceptedChars = "0123456789.+-eExabcdef";

    public NumberParserContext(int firstCodePoint) {
        this.numberString = this.numberString + (char)firstCodePoint;
    }

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        if (this.complete) {
            return false;
        }
        if (this.acceptedChars.indexOf(codePoint) != -1) {
            this.numberString = this.numberString + (char)codePoint;
            return true;
        }
        this.complete = true;
        return false;
    }

    @Override
    public void eof() throws SyntaxError {
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public JsonPrimitive getResult() throws SyntaxError {
        if (this.numberString.startsWith(".")) {
            this.numberString = '0' + this.numberString;
        }
        if (this.numberString.endsWith(".")) {
            this.numberString = this.numberString + '0';
        }
        if (this.numberString.startsWith("0x")) {
            this.numberString = this.numberString.substring(2);
            try {
                Long l = Long.parseUnsignedLong(this.numberString, 16);
                return new JsonPrimitive(l);
            }
            catch (NumberFormatException nfe) {
                throw new SyntaxError("Tried to parse '" + this.numberString + "' as a hexadecimal number, but it appears to be invalid.");
            }
        }
        if (this.numberString.startsWith("-0x")) {
            this.numberString = this.numberString.substring(3);
            try {
                Long l = -Long.parseUnsignedLong(this.numberString, 16);
                return new JsonPrimitive(l);
            }
            catch (NumberFormatException nfe) {
                throw new SyntaxError("Tried to parse '" + this.numberString + "' as a hexadecimal number, but it appears to be invalid.");
            }
        }
        if (this.numberString.indexOf(46) != -1) {
            try {
                Double d = Double.valueOf(this.numberString);
                return new JsonPrimitive(d);
            }
            catch (NumberFormatException ex) {
                throw new SyntaxError("Tried to parse '" + this.numberString + "' as a floating-point number, but it appears to be invalid.");
            }
        }
        try {
            Long l = Long.valueOf(this.numberString);
            return new JsonPrimitive(l);
        }
        catch (NumberFormatException ex) {
            throw new SyntaxError("Tried to parse '" + this.numberString + "' as an integer, but it appears to be invalid.");
        }
    }
}

