/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl;

import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonArray;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonElement;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonNull;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonObject;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonPrimitive;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.DeserializationException;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.Marshaller;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.magic.TypeMagic;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class POJODeserializer {
    public static void unpackObject(Object target, JsonObject source) throws DeserializationException {
        JsonObject work = source.clone();
        for (Field f : target.getClass().getDeclaredFields()) {
            POJODeserializer.unpackField(target, f, work);
        }
        for (Field f : target.getClass().getFields()) {
            POJODeserializer.unpackField(target, f, work);
        }
        if (!work.isEmpty()) {
            System.out.println("Unable to deserialize: " + work.toJson(true, true));
        }
    }

    public static void unpackField(Object parent, Field f, JsonObject source) {
        if (source.containsKey(f.getName())) {
            JsonElement elem = source.get(f.getName());
            source.remove(f.getName());
            if (elem == null) {
                try {
                    f.set(parent, null);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            } else {
                try {
                    POJODeserializer.unpackFieldData(parent, f, elem, source.getMarshaller());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Nullable
    public static Object Unpack(Type t, JsonElement elem, Marshaller marshaller) {
        Class<?> rawClass = TypeMagic.classForType(t);
        if (rawClass.isPrimitive()) {
            return null;
        }
        if (elem == null) {
            return null;
        }
        return null;
    }

    public static boolean unpackFieldData(Object parent, Field field, JsonElement elem, Marshaller marshaller) throws Throwable {
        if (elem == null) {
            return true;
        }
        try {
            field.setAccessible(true);
        }
        catch (Throwable t) {
            return false;
        }
        if (elem == JsonNull.INSTANCE) {
            field.set(parent, null);
            return true;
        }
        Class<?> fieldClass = field.getType();
        if (field.get(parent) == null) {
            Object fieldValue = TypeMagic.createAndCast(field.getGenericType());
            if (fieldValue == null) {
                return false;
            }
            field.set(parent, fieldValue);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            Type[] parameters = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            POJODeserializer.unpackMap((Map)field.get(parent), parameters[0], parameters[1], elem, marshaller);
            return true;
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            Type elementType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            POJODeserializer.unpackCollection((Collection)field.get(parent), elementType, elem, marshaller);
            return true;
        }
        return false;
    }

    public static void unpackMap(Map<Object, Object> map, Type keyType, Type valueType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonObject)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Map - expected a JsonObject!");
        }
        Class<?> keyClass = TypeMagic.classForType(keyType);
        Class<?> valueClass = TypeMagic.classForType(valueType);
        JsonObject object = (JsonObject)elem;
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            try {
                Object k = marshaller.marshall(keyClass, (JsonElement)new JsonPrimitive(entry.getKey()));
                Object v = marshaller.marshall(valueClass, entry.getValue());
                if (k == null || v == null) continue;
                map.put(k, v);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void unpackCollection(Collection<Object> collection, Type elementType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonArray)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Set - expected a JsonArray!");
        }
        Class<?> elementClass = TypeMagic.classForType(elementType);
        JsonArray array = (JsonArray)elem;
        for (JsonElement arrayElem : array) {
            Object o = marshaller.marshall(elementClass, arrayElem);
            if (o == null) continue;
            collection.add(o);
        }
    }
}

