#ifndef _LIB_INI_H_
#define _LIB_INI_H_


#include <stdbool.h>
#include <pspiofilemgr.h>


#ifdef __cplusplus
extern "C" {
#endif


/*
	iniLoad/iniSave/iniSplitɂ
	ĂKey/Value͓ǂݍ񂾂܂܂̏ԂȂ̂
	R[obN֐ŏۂ͑啶/̋ʂ
	ǂ邩ӎ̂YȂŉ
	
	啶/ʂF悤ɂ̂ʓI
*/



//iniAddKeyŎw肷Keỹf[^^
typedef enum
{
	INI_TYPE_NONE = 0,	//
	INI_TYPE_DEC,		//10i
	INI_TYPE_HEX,		//16i
	INI_TYPE_OCT,		//8i
	INI_TYPE_BOOL,		//BOOL
	INI_TYPE_STR,		//
	INI_TYPE_DOUBLE,	//DOUBLE ( l )

}ini_type;


//Key,ValuẽyA
typedef struct
{
	ini_type	type;	//f[^^
	const char	*key;	//Key
	
	void *val_load;
	void *val_save;

	bool flag;
	int id;
} ini_pair;


//iniParseLine
typedef struct
{
	char *key;			//key
	char *key_end;		//key̍Ō
	char key_end_cd;	//key_end\0ŒuO̕
	
	char *val;			//value
	char *val_end;		//value̍Ō
	char val_end_cd;	//value_end\0ŒuO̕
	
} ini_line;



typedef struct
{
	ini_pair *pair;		//Key/Valueǉ/ݒ/폜ۂɎgpini_pairz
	int size;			//pairŎw肵zTCY( sizeof(pair) )
	
	char *buf;			//iniReadLineŎgobt@[w
	int bufLen;			//buf̃TCYiŎw肵liniReadLineœǂݍ߂1s̍ő啶j
} ini_data;


// iniSplitVal̃R[obN֐ void (*)(const char *val,void *callback_opt)
typedef void (*libini_cbsp)(const char *val,void *callback_opt);

// iniSave ̃R[obN֐ const char* (*)(const char *key,void *opt,ini_pair *pair)
typedef const char* (*libini_cbs)(const char *key,void *opt,ini_pair *pair);

// iniLoad ̃R[obN֐ bool (*)(const char *key, char *val,void *opt,ini_pair *pair)
typedef bool (*libini_cbl)(const char *key, char *val,void *opt,ini_pair *pair);


enum
{
	INIREADLINE_END		= 0,		//t@C̏IA܂ُ͈ȏ
	INIREADLINE_CR		= -1,		//sR[hCR̂
	INIREADLINE_LF		= -2,		//sR[hLF̂
	INIREADLINE_CRLF	= -3,		//sR[hCRLF
};



/*	iniReadLine
    t@C1sǂݍ
    
    @param: SceUID fd
    SceIoOpenŊJt@C
    
    @param: char *buf
    ǂݍ񂾕i[obt@[
    
    @param: int bufLen
    obt@[TCY
	TCY1sۂƎ擾oȂ̂ŕKvɉĎw
	Ō\0ǉdlŒ 2 ͕Kv
    
    @return: ȉ̒ʂ
	
	INIREADLINE_END		= t@CI[		buf -> '\0'̂
    INIREADLINE_CR		= sR[h(CR) 	buf -> '\0'̂
    INIREADLINE_LF		= sR[h(LF)	buf -> '\0'̂
    INIREADLINE_CRLF	= sR[h(CRLF)	buf -> '\0'̂
	ȊO			= ǂݍ񂾕	buf -> ǂݍ񂾕
 */

int iniReadLine( SceUID fd, char *buf, int bufLen );


/*	iniParseLine
    iniReadLineɂēǂݍ񂾕KeyAValue֕
    
    @param: ini_line *line
    ʂ󂯎 ini_lineϐ
    
    @param: void *buf
    Ώە
	
    @return: true = Afalse = s(Key = Valuě`ł͂Ȃ)
    
    Key/Value̎n܂/I
    @^u(\t)Ap/SpXy[XOʒuɂȂ܂
    @OΏەȂꍇ͖߂l false ƂȂ܂
 */
bool iniParseLine( ini_line *line ,char *buf );

/*	iniRestoreLine
    iniParseLine  KeyAVal ւƕꂽ1sւƕ
    
    @param: ini_line *line
    iniParseLineŎw肵 ini_line ϐ
	
 */
#define	iniRestoreLine( line )	if( (line)->key_end ) *(line)->key_end = (line)->key_end_cd;\
								if( (line)->val_end ) *(line)->val_end = (line)->val_end_cd;


/*	iniSplitVal
    iniParseLine瓾Valueijؕŕ
    
    @param: char *val
    Ώە
    
    @param: const char *delim
    ؂镶QiꂩvƂ̕ŋ؂j
    
    @param: libini_cbsp callback_sp
    ؂ꂽ󂯎R[obN֐
	
	[R[obN֐֑Ăl]
    val 			= ؂ꂽ
    callback_opt	= iniSplitValŎw肵f[^iCӁj
    
    @param: void *callback_opt
    R[obN֐֓nf[^
    
    ؂ꂽ͑Oォ疳( p/Sp 󔒁Atab )菜
    @R[obN֐֑Ă܂
 */
void iniSplitVal( char *val ,const char *delim ,libini_cbsp callback_sp ,void *callback_opt );



/*	iniSearchKey
  	data(ini_data*) w肵Key܂܂f[^(ini_pair*)擾
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: const char *key
    ΏۂKey
    NULLw肷Ƌ(KeyZbgĂȂꏊjT
	
    @return: ΏKey܂܂Ăf[^(ini_pair*)
    NULL = ݂Ȃ
 */
ini_pair* iniSearchKey( ini_data *data ,const char *key );

/*	iniAddKey
  	data(ini_data*)Key(Value)ǉ
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: const char *key
    ǉΏۂKey
	
    @param: ini_type type
    f[^^wiINI_TYPE_NONEȊO)
    
    @param: void *val_load
    iniLoadsۂɁA擾lۑϐ̃|C^[
    (ΏKey̌^ INI_TYPE_STR ̏ꍇ NULL wj
    
    @param: void *val_save
    iniSavesۂɁAۑlQƂϐւ̃|C^[
    (ΏKey̌^ INI_TYPE_STR ̏ꍇ NULL wj

    @param: int id
	KeyɊ֘AtID(C)
	
    @return: true = Afalse = siz̃TCYȂAɑ݂KeyAȌ^)
    
    void *val_load ,void *val_save ͂ꂼ
	@w肷 int_type ɂĕϐ̌^܂Ă܂
    
    *bool	= INI_TYPE_BOOL
    *int  	= INI_TYPE_DEC / INI_TYPE_OCT / INI_TPYE_HEX
    *double	= INI_TYPE_DOUBLE
 */
bool iniAddKey( ini_data *data ,const char *key ,ini_type type ,void *val_load ,void *val_save, int id );

/*	iniSetVal
	ɃXg֒ǉς݂(iniAddKey) Keyɑ΂
	iniLoad / iniSave ŎQƂ void *val_load ,void *val_save Đݒ肷
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: const char *key
    ǉς݂Key
    
    @param: void *val_load
    iniLoadsۂɁA擾lۑϐ̃|C^[
    (ΏKey̌^ INI_TYPE_STR ̏ꍇ NULL wj
    
    @param: void *val_save
    iniSavesۂɁAۑlQƂϐւ̃|C^[
    (ΏKey̌^ INI_TYPE_STR ̏ꍇ NULL wj

    @param: int id
	KeyɊ֘AtID(C)
	
    @return: true = Afalse = siKey݂Ȃ)
    
    void *val_load ,void *val_save ͂ꂼ
	@w肵 int_type ɂĕϐ̌^܂Ă܂
    
    *bool	= INI_TYPE_BOOL
    *int  	= INI_TYPE_DEC / INI_TYPE_OCT / INI_TPYE_HEX
    *double	= INI_TYPE_DOUBLE
 */
bool iniSetVal( ini_data *data ,const char *key ,void *val_load ,void *val_save, int id );


/*	iniRmvKey
  	data(ini_data*)Key폜iɁj
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: const char *key
    폜ΏۂKey
	
    @return: true = Afalse = siKey݂Ȃ)
 */
bool iniRmvKey( ini_data *data ,const char *key );



/*	iniLoad
  	t@Cݒ擾
  	
  	data(ini_data*)Ŏw肳ĂeKeỹf[^^ɉĒl擾
    
    @param: const char *path
    ǂݍރt@C
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: libini_cbl callback_load
    l^KeyR[obN֐
    ĂKeyɉValueϊ
    t@CɑΏKey̋LqȂΌĂяoȂ
    
    [R[obN֐֑Ăl]
    const char *key		= Key
    char *val			= Value
    void *opt			= R[obN֓nꂽf[^iiniLoadŎw肵callback_opt)
	ini_pair *pair		= Key(ڍ)

    𐳂oǂAbool^Ŗ߂lƂĕԋp
	
    @param: void *callback_opt
    R[obN֐֓nf[^
    R[obNwȂNULL
	
    @return: iniAddKeyŒǉKeyƔׂāAۂɃt@C擾oݒ萔
	
    0 = t@C݂ȂA̐ݒsAȊO = 炩̐ݒ肪擾oĂ
   	
  	Key/Value̎n܂EI͑Õ^u(\t)Ap/SpXy[XOʒuŎ
  	@啶͋ʂɔr܂iINI_TYPE_STR̂ݎgp҂Ŕfj
  	@
  	@llKeyiniAddKeyŌ^(8i/10i/16i)w肵Ȃ
  	@l擾Ȃ̂Œ
 */
int iniLoad( const char *path ,ini_data *data ,libini_cbl callback_load ,void *callback_opt );

/*	iniSave
	t@C֐ݒۑ
	
  	data(ini_data*)Ŏw肳ĂKey/Value
  	ꂼ̃f[^^ɉăt@C֕ۑ
    
    @param: const char *path
    ۑt@C
    
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: libini_cbs callback_save
    l^KeyR[obN֐
    ĂKeyɉăt@C֏ޕԋp
    t@CɑΏKey̋LqȂΌĂяoȂ
	
	[R[obN֐֑Ăl]
    const char *key		= Key
    void *opt			= R[obN֓nꂽf[^iiniSaveŎw肵callback_opt)
	ini_pair *pair		= Key(ڍ)

   Cӂ̕ԋpKeyɑ΂Ă̓e܂ANULLԋpƏ܂܂
	
    @param: void *callback_opt
    R[obN֐֓nf[^
    R[obNwȂNULL
	
    @return: true = Afalse = si󂫗eʕsŃt@C߂ȂA̐ݒsj
   	
   	ۑt@Cɑ݂ꍇ
   	@ΏۊO̕ۂ܂܏㏑̂ŖȂ
   	@
  	@llKeyiniAddKeyŌ^(8i/10i/16i)w肵Ȃ
  	@]ԂŕۑȂ̂Œ
*/
bool iniSave( const char *path ,ini_data *data ,libini_cbs callback_save ,void *callback_opt );


/*
	iniCounterPbrk
	(src)̐擪當Q(search)܂܂Ȃŏ̈ʒuԂ
	
    @param: const char * src
    ̕
    
    @param: const char *search
    Ώۂ̕
	
	@return: Q܂܂Ȃŏ̈ʒui擪j
	NULL = ݂Ȃ
*/
char* iniCounterPbrk( const char *src, const char *search );

/*
	iniCounterReversePbrk
	(src)̖當Q(search)܂܂Ȃŏ̈ʒuԂ
	
    @param: const char * src
    ̕
    
    @param: const char *search
    Ώۂ̕
	
	@return: Q܂܂Ȃŏ̈ʒuij
	NULL = ݂Ȃ
*/
char* iniCounterReversePbrk( const char *src, const char *search );

/*
	iniIsLoad
	iniLoadŒlǂݍ߂ݒ育ƂɊmF
	(iniLoad̖߂l͓ǂݍ߂ݒ萔Ȃ̂ŁA⏕́j
	
    @param: ini_data *data
    Ώۂini_dataϐ
    
    @param: const char *key
    ΏۂKey
	
	@return: true = Afalse = s
	
	iniLoadɎs
*/
int	iniIsLoad( ini_data *data, const char *key );



/*
	iniGetArraySize
	data->sizedata->pairz̗vf擾
	(data->pairz̐ݒ󋵂`FbNj
	
	@param: ini_data *data
    Ώۂini_dataϐ
	
	@return: data->pairz̗vf
	data->size̒lُȏꍇ0
*/
int iniGetArraySize( ini_data *data );




/*	J[l[h̃vOC֓
	⊮Kv3̕WCu֐
*/

extern int snprintf( char *buf, size_t n, const char *fmt, ... );
extern int strcasecmp( const char *s1, const char *s2 );
extern double strtod(const char *s, char **eptr);


#ifdef __cplusplus
}
#endif

#endif

