/*
 * Decompiled with CFR 0.152.
 */
package socketpunch;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;

public final class Main
extends JFrame {
    String CONST_PATH = System.getProperty("user.dir") + "\\log.txt";
    String CONST_SETTING_PATH = System.getProperty("user.dir") + "\\config.txt";
    String NEWLINE = System.getProperty("line.separator");
    DefaultListModel model = new DefaultListModel();
    private DefaultListModel queueModel = new DefaultListModel();
    boolean startedSending = false;
    int transferCount = 0;
    int failCount = 0;
    int bufferSize = 128;
    private JCheckBox autotryChk;
    private JTextArea consoleText;
    private JList dirList;
    private JTextPane ipText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JProgressBar progBar;
    private JLabel progText;
    private JList queueList;
    private JCheckBox saveLogChk;
    private JButton startButt;
    private JSpinner timeoutVal;

    public Main() {
        File file;
        this.setTitle("SocketPunch v0.3.4 - Joshtech");
        this.initComponents();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.ipText.setText(addr.getHostAddress());
        }
        catch (UnknownHostException ex) {
            this.consoleWrite("There appears to be a problem with the network!", true);
        }
        this.GetSettings();
        if (this.saveLogChk.isSelected() && (file = new File(this.CONST_PATH)).exists()) {
            for (int i = 0; i < 3; ++i) {
                this.WriteLog(this.CONST_PATH, "");
            }
        }
        this.consoleWrite("==============================", false);
        this.consoleWrite("                 SocketPunch v0.3.4", false);
        this.consoleWrite("             Joshtech @GBATemp.net", false);
        this.consoleWrite("==============================", false);
        this.consoleWrite("- Buffer is set to " + Integer.toString(this.bufferSize) + "kb", true);
        this.getCiaListing();
        this.resetControls();
    }

    public void GetSettings() {
        File tempFile = new File(this.CONST_SETTING_PATH);
        if (!tempFile.exists()) {
            this.consoleWrite("- Settings file could not be found. Creating default.", true);
            this.WriteTextFile(this.CONST_SETTING_PATH, "// This file contains settings for SocketPunch" + this.NEWLINE + "// Please keep in mind that buffersize should match with FBI (default 128)" + this.NEWLINE + "savelog=true" + this.NEWLINE + "buffersize=128");
            this.GetSettings();
        } else {
            String[] file;
            for (String fileLine : file = this.ReadTextFile(this.CONST_SETTING_PATH).split(this.NEWLINE)) {
                if (fileLine.contains("//")) continue;
                try {
                    String[] tempSplit = fileLine.split("=");
                    switch (tempSplit[0].toLowerCase()) {
                        case "savelog": {
                            this.saveLogChk.setSelected(Boolean.valueOf(tempSplit[1]));
                            break;
                        }
                        case "buffersize": {
                            this.bufferSize = Integer.parseInt(tempSplit[1]);
                            break;
                        }
                        case "ip": {
                            this.ipText.setText(tempSplit[1]);
                        }
                    }
                }
                catch (Exception e) {
                    this.consoleWrite("- There was an issue loading settings!", true);
                }
            }
        }
    }

    public void OpenDir(String path) {
        File[] list;
        File f = new File(path);
        for (File file : list = f.listFiles()) {
            try {
                if (file.isDirectory()) {
                    this.OpenDir(file.toString());
                    continue;
                }
                if (!file.isFile() || !file.toString().toLowerCase().contains(".cia")) continue;
                this.model.addElement(file.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String ReadTextFile(String path) {
        String tempString = "";
        try {
            FileReader file = new FileReader(path);
            int data = ((Reader)file).read();
            while (data != -1) {
                tempString = tempString + (char)data;
                data = ((Reader)file).read();
            }
            ((Reader)file).close();
        }
        catch (Exception e) {
            return "";
        }
        return tempString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void WriteTextFile(String path, String text) {
        BufferedWriter bw = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
            bw = new BufferedWriter(fw);
            bw.write(text);
            bw.newLine();
            bw.flush();
        }
        catch (IOException e) {
            this.consoleWrite("- Unable to write file. Weird!", true);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void WriteLog(String path, String text) {
        this.WriteTextFile(path, text);
    }

    public void getCiaListing() {
        this.consoleWrite("- Getting directory listings.", true);
        this.OpenDir(System.getProperty("user.dir"));
        if (this.model.getSize() == 0) {
            this.model.addElement("NO CIA'S FOUND!");
        }
        this.queueList.setModel(this.queueModel);
        this.queueList.setSelectedIndex(0);
        this.dirList.setModel(this.model);
        this.dirList.setSelectedIndex(0);
    }

    public void resetControls() {
        this.progBar.setValue(0);
        this.transferCount = 0;
        this.progText.setText(String.format("%.2fmb of %.2fmb @ %%%.2f", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
    }

    public void consoleWrite(String string, boolean withTime) {
        if (withTime) {
            String tempString = this.consoleText.getText() + this.getTimeStamp() + " " + string + this.NEWLINE;
            if (this.saveLogChk.isSelected()) {
                this.WriteLog(this.CONST_PATH, this.getTimeStamp() + " " + string);
            }
            this.consoleText.setText(tempString);
        } else {
            String tempString = this.consoleText.getText() + string + this.NEWLINE;
            if (this.saveLogChk.isSelected()) {
                this.WriteLog(this.CONST_PATH, string);
            }
            this.consoleText.setText(tempString);
        }
        this.consoleText.setCaretPosition(this.consoleText.getDocument().getLength());
    }

    public String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("[d/M/y HH:mm a]");
        return sdf.format(cal.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(File file) {
        FileInputStream in;
        DataOutputStream out;
        Socket socket;
        try {
            socket = new Socket(this.ipText.getText(), 5000);
            out = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException e) {
            if (this.failCount == 0) {
                this.consoleWrite("- Failed to open socket. Please check IP.", true);
            } else {
                this.consoleWrite("- Retrying!", true);
            }
            this.resetControls();
            return false;
        }
        try {
            in = new FileInputStream(file);
        }
        catch (IOException e) {
            this.consoleWrite("- Failed to open file stream.", true);
            this.resetControls();
            return false;
        }
        long counter = 0L;
        int updateCount = 0;
        try {
            int length;
            this.consoleWrite("- Sending info...", true);
            out.writeLong(file.length());
            this.progBar.setMaximum((int)file.length());
            this.consoleWrite(String.format("- Sending file with size of %.2fmb", Float.valueOf((float)file.length() / 1048576.0f)), true);
            byte[] buffer = new byte[1024 * this.bufferSize];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
                counter += (long)length;
                if (updateCount < 0) {
                    ++updateCount;
                    continue;
                }
                updateCount = 0;
                this.progBar.setValue((int)counter);
                this.progText.setText(String.format("%.2fmb of %.2fmb @ %.2f%%", Float.valueOf((float)counter / 1048576.0f), Float.valueOf((float)file.length() / 1048576.0f), Float.valueOf((float)counter / 1048576.0f / ((float)file.length() / 1048576.0f) * 100.0f)));
            }
            this.resetControls();
            this.consoleWrite("- File sent successfully.", true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.resetControls();
            this.consoleWrite(String.format("- Failed at %.2fmb of %.2fmb @ %.2f%%", Float.valueOf((float)counter / 1048576.0f), Float.valueOf((float)file.length() / 1048576.0f), Float.valueOf((float)counter / 1048576.0f / ((float)file.length() / 1048576.0f) * 100.0f)), true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
                out.close();
                socket.close();
            }
            catch (IOException e) {}
        }
    }

    private void initComponents() {
        this.progBar = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.queueList = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.ipText = new JTextPane();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.consoleText = new JTextArea();
        this.jLabel3 = new JLabel();
        this.startButt = new JButton();
        this.progText = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.dirList = new JList();
        this.jLabel4 = new JLabel();
        this.autotryChk = new JCheckBox();
        this.timeoutVal = new JSpinner();
        this.jLabel5 = new JLabel();
        this.saveLogChk = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.queueList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.queueListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.queueList);
        this.ipText.setText("Enter IP Address");
        this.ipText.setToolTipText("");
        this.ipText.setName("");
        this.jScrollPane3.setViewportView(this.ipText);
        this.jLabel1.setText("IP Address:   (This should be shown on device)");
        this.jLabel2.setText("CIA List:   (Double-Click to add to queue)");
        this.consoleText.setColumns(20);
        this.consoleText.setFont(new Font("Malgun Gothic", 0, 10));
        this.consoleText.setRows(5);
        this.jScrollPane2.setViewportView(this.consoleText);
        this.jLabel3.setText("Console Output:");
        this.startButt.setText("Punch!");
        this.startButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.startButtActionPerformed(evt);
            }
        });
        this.progText.setText(" ");
        this.dirList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.dirListMouseClicked(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.dirList);
        this.jLabel4.setText("CIA's in queue:   (Double-Click to remove from queue)");
        this.autotryChk.setText("Auto-Retry");
        this.timeoutVal.setValue(5);
        this.jLabel5.setText("Timeout Tries:");
        this.saveLogChk.setText("Save Log (Will be stored in working directory)");
        this.saveLogChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.saveLogChkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 548, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addComponent(this.progBar, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3).addComponent(this.startButt, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane4).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveLogChk)).addComponent(this.jLabel4)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.progText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutVal, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autotryChk).addGap(25, 25, 25))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 93, -2).addGap(14, 14, 14).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.saveLogChk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startButt).addGap(18, 18, 18).addComponent(this.progText)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autotryChk).addComponent(this.timeoutVal, -2, -1, -2).addComponent(this.jLabel5))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progBar, -2, 49, -2).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void startButtActionPerformed(ActionEvent evt) {
        Thread thread = new Thread("Connect"){

            @Override
            public void run() {
                if (!Main.this.startedSending) {
                    Main.this.startedSending = true;
                    Main.this.failCount = 0;
                    for (int i = 0; i < Main.this.queueList.getModel().getSize(); ++i) {
                        Object item = Main.this.queueList.getModel().getElementAt(i);
                        Main.this.queueList.setSelectedIndex(i);
                        boolean connectStatus = Main.this.connect(new File(item.toString()));
                        if (!connectStatus && Main.this.autotryChk.isSelected()) {
                            --i;
                            continue;
                        }
                        if (!connectStatus && Main.this.failCount < (Integer)Main.this.timeoutVal.getValue() - 1) {
                            --i;
                            ++Main.this.failCount;
                            continue;
                        }
                        Main.this.failCount = 0;
                    }
                    Main.this.startedSending = false;
                    Main.this.consoleWrite("- Queue has finished!", true);
                } else {
                    Main.this.consoleWrite("- A file transfer is already in progress.", true);
                }
            }
        };
        thread.start();
    }

    private void dirListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.queueModel.addElement(this.dirList.getSelectedValue());
        }
    }

    private void queueListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.queueModel.removeElement(this.queueList.getSelectedValue());
        }
    }

    private void saveLogChkActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main().setVisible(true);
            }
        });
    }
}

