//
//  PRPrincipia.h
//  Principia
//
//  Created by Shin Hirota on 5/11/13.
//  Copyright (c) 2013 Shin Hirota. All rights reserved.
//

var CR = "\n";
var CRCR = "\n\n";
var CRCRCR = "\n\n\n";

//////////////////////////////////////////////////////////////////////////////
// Constants
//////////////////////////////////////////////////////////////////////////////

pp.ID_INVALID = -1;
pp.idInvalid = pp.ID_INVALID;
pp.IDX_INVALID = -1;
pp.idxInvalid = pp.IDX_INVALID;

pp.PR_THEME_CNT_PER_PERSON = 3;
pp.PR_FIELD_CNT = 9;

pp.FD_ASTRONOMY = 0;
pp.FD_MECHANICS = 1;
pp.FD_HEAT = 2;
pp.FD_BIOLOGY = 3;
pp.FD_OPTICS = 4;
pp.FD_MATHS = 5;
pp.FD_ENGINEERING = 6; //sometimes it is dealt as a field
pp.FD_DRAWING = 7; //sometimes it is dealt as a field
pp.FD_IMPORTANT = 8;

// Items
pp.IP_PRISM = 0;
pp.IP_TELESCOPE = 1;
pp.IP_HOURGLASS = 2;
pp.IP_CLOCK = 3;
pp.IP_WATCH = 4;
pp.IP_TEMPERATURE = 5;
pp.IP_BALL = 6;
pp.IP_BAR = 7;
pp.IP_MICROSCOPE1 = 8;
pp.IP_MICROSCOPE2 = 9;
pp.IP_MICROSCOPE3 = 10;
pp.IP_PUMP = 11;
pp.IP_RING = 12;
pp.IP_CALCULATOR = 13;
pp.IP_POLISHER = 14;
pp.IP_ENGINE = 15;
pp.IP_QUADRANT = 16;

//'*** WAVEﾌｧｲﾙID
pp.wavNotice = 1;       //'ﾌﾟﾛﾝﾌﾟﾄ音(ｺﾏﾝﾄﾞ等)

//'*** MIDIﾌｧｲﾙID
/*
pp.midNothing = 0;      //'曲無し
pp.midMain = 1;         //'ﾒｲﾝ
pp.midEvent = 2;        //'ｲﾍﾞﾝﾄ
pp.midJudge = 3;        //'審査
pp.midEnd = 4;          //'ｴﾝﾄﾞ
pp.midCongrats = 5;     //'ﾌｧﾝﾌｧｰﾚ
*/

//'*** 発見ﾀｲﾌﾟ
pp.ttTheory = 0;        //'理論
pp.ttItem = 1;          //'道具
pp.ttThing = 2;         //'存在
pp.ttFigure = 3;        //'図
pp.ttBook = 4;          // 著作
//static NSString* const ttNames[] = { @"理論", @"道具", @"存在", @"図" };
pp.ttNames = [ "理論", "発明", "存在",  "図", "著作" ];
// NSString* ttNames[4];

pp.selOk = 0;
pp.selCancel = -1;

/*
 '********************************************************************
 '*                                                                  *
 '* 定数定義                                                         *
 '*                                                                  *
 '********************************************************************
 '*** ｱﾌﾟﾘｼｽﾃﾑ定数
 pp.fnAccessDB = "prin.mdb"      'ACCESSﾃﾞｰﾀﾍﾞｰｽﾌｧｲﾙ名
 static NSString* const fnDatabase = "prin.dat"      '変換済みﾃﾞｰﾀﾍﾞｰｽﾌｧｲﾙ名
 static NSString* const fnSenario1 = "senario1.dat"  'ｼﾅﾘｵﾌｧｲﾙ名
 */

pp.prJob0DefaultPersonId = 11;
pp.prJob1DefaultPersonId = 12;
pp.prJob2DefaultPersonId = 13;

pp.prJobNumASociety = 3;    //'1つの組織内の役職数
pp.prFieldNum = 6;          //'分野数
pp.prTrainTypeNum = 8;      //'訓練可能な分野数
pp.prThemeNumAPerson = 3;   //'1人の人物が同時に持てるﾃｰﾏ数
pp.prVoiceNumTheme = 3;     //'1つのﾃｰﾏに対する台詞数
pp.prWidthLag = 400;        //'幅調整遊び(ｽｸﾛｰﾙﾊﾞｰ、枠幅等のｽﾍﾟｰｽ)

//'*** ｼﾅﾘｵ1設定値
pp.prFirstYear = 1667;  //'ｹﾞｰﾑ開始年
pp.prFirstMonth = 4;    //'ｹﾞｰﾑ開始月

//'*** ﾃﾞﾌｫﾙﾄ値
pp.prDefaultFriendliness = 50;  //'友好度ﾃﾞﾌｫﾙﾄ値
pp.ocDefault = 0;              //'ﾃﾞﾌｫﾙﾄ職業ID

//'*** Idx定数
pp.jiMember = pp.prJobNumASociety; //'一般会員のIdx番号

//'情報種別選択定数
pp.siPerson = 1;        //'人物情報
pp.siReport = 2;        //'論文情報
pp.siSociety = 3;       //'組織情報
//'@@@ more...

//'研究種別選択定数
pp.srData = 1;          //'実験/観測/観察
pp.srDeduce = 2;        //'推理/解析
pp.srStopTheme = 3;     //'ﾃｰﾏ変更
//'@@@ more...

//'手紙ｺﾏﾝﾄﾞ種別選択定数
pp.slSubmit = 1;        //'論文提出
pp.slStop = 2;          //'公開停止
pp.slClaim = 3;         //'批判
pp.slDonate = 4;        //'寄付
pp.slJoin = 5;          //'入会希望
pp.slSecede = 6;        //'退会希望

//'売買ｺﾏﾝﾄﾞ種別選択定数
pp.ssBuy = 1;           //'購入
pp.ssSell = 2;          //'売却

//'作成選択定数
pp.smItem = 1;          //'試作品
pp.smFigure = 2;        //'図
pp.smReport = 3;        //'論文

//'意見選択定数
pp.soVeryFor = 0;       //'大賛成
pp.soFor = 1;           //'賛成
pp.soAgainst = 2;       //'反対
pp.soVeryAgainst = 3;   //'大反対

//'終了ｺﾏﾝﾄﾞ種別選択定数
pp.seMonth = 1;         //'今月終了
pp.seGame = 2;          //'引退

//'*** 終了理由
pp.goRetired = 0;       //'引退
pp.goDead = 1;          //'死亡
pp.goClear = 2;         //'大著出版

//'*** 人物状態
pp.pcYoung = 0;         //'若年
pp.pcActive = 1;        //'現役
pp.pcDead = 2;          //'死亡
pp.pcRetired = 3;       //'引退


//'*** 完成度特殊値
pp.crPreNotice = -1;        //'未発見
pp.crPostRenounce = -2;     //'破棄済み発見
pp.crPreMake = 0;           //'作成前(道具)
pp.crReady = 100;           //'作成済み(道具、物)

//'*** 表示文字定義
//pp.snFree = "無所属";    //'無所属時の所属表示
//pp.jnFree = "無所属";    //'無所属時の役職表示
//pp.jnNormal = "会員";    //'役職無し時の役職表示

//'*** ｹﾞｰﾑｽﾃｰﾀｽ列挙
pp.gsFirstTitle = 0;    //'ﾀｲﾄﾙ画面(起動時の)
pp.gsTitle = 1;         //'ﾀｲﾄﾙ画面
pp.gsStory = 2;         //'開始時ｽﾄｰﾘｰ
pp.gsSelectPlayer = 3;  //'ﾌﾟﾚｲﾔｰｾﾚｸﾄ
pp.gsStartGame = 4;     //'ｹﾞｰﾑ開始前
pp.gsEndGame = 5;       //'ｹﾞｰﾑ終了前(ｴﾝﾃﾞｨﾝｸﾞ終了待ち。ﾀｲﾄﾙはSetGameState無いでﾒｲﾝﾀｲﾏを起動しているため別ｽﾃｰﾄ)

pp.gsStartMonth = 11;   //'月開始前
pp.gsTurn = 12;         //'各人物のﾀｰﾝ中
pp.gsEndMonth = 13;     //'月終了後

pp.gsLoaded = 14;

//'*** 分野ID列挙(ﾃﾞｰﾀﾍﾞｰｽに合わせる事)
pp.fdAstronomy = 0;     //'天文学
pp.fdMechanics = 1;     //'力学
pp.fdHeat = 2;          //'熱力学
pp.fdBiology = 3;       //'生物学
pp.fdOptics = 4;        //'光学
pp.fdMathematics = 5;   //'数学

pp.fdEngineering = 6;   //'工作技術(第7の分野として扱うこともある)
pp.fdDrawing = 7;   //'描画力 (第8の分野として扱うこともある)
pp.fdImportant = 8;   //'重大テーマ(第9の分野として扱うこともある)

//pp.fieldNamesLess = [ "天文学", "力学", "熱力学", "生物学", "光学", "数学" ];
//pp.fieldNames = [ "天文学", "力学", "熱力学", "生物学", "光学", "数学", "工作技術", "描画力" ];
//pp.fieldName2s = [ "天文", "力学", "熱学", "生物", "光学", "数学", "工作", "描画" ];
pp.fieldIcons = [ res.Img_IcnSAstro, res.Img_IcnSMecha, res.Img_IcnSHeat,
                  res.Img_IcnSBio, res.Img_IcnSOpt, res.Img_IcnSMath, "", "" ];

pp.fieldCuts = [
    res.Img_CutAstronomy,
    res.Img_CutMechanics,
    res.Img_CutHeat,
    res.Img_CutBiology,
    res.Img_CutOptics,
    res.Img_CutMath,
    null,
    null,
    res.Img_CutMath
];

pp.figures = [
    { name: "葉", picture: res.Img_FigLeaf, poorPicture: res.Img_FigPoorFlower, discId: 61 },
    { name: "茎", picture: res.Img_FigStem, poorPicture: res.Img_FigPoorFlower, discId: 62 },
    { name: "コルク", picture: res.Img_FigCork, poorPicture: res.Img_FigPoorFlower, discId: 60 },
    { name: "アリ", picture: res.Img_FigAnt, poorPicture: res.Img_FigPoorBug, discId: 75 },
    { name: "カゲロウ", picture: res.Img_FigMayfly, poorPicture: res.Img_FigPoorBug, discId: 74 },
    { name: "ノミ", picture: res.Img_FigFlea, poorPicture: res.Img_FigPoorBug, discId: 76 },
    { name: "魚卵", picture: res.Img_FigFishEgg, poorPicture: res.Img_FigPoorFish, discId: 71 },
    { name: "幼魚", picture: res.Img_FigFishBaby, poorPicture: res.Img_FigPoorFish, discId: 72 },
    { name: "成魚", picture: res.Img_FigFish, poorPicture: res.Img_FigPoorFish, discId: 73 },
    { name: "毛髪", picture: res.Img_FigHair, poorPicture: res.Img_FigPoorLines, discId: 107 },
    { name: "皮膚", picture: res.Img_FigSkin, poorPicture: res.Img_FigPoorLines, discId: 68 },
    { name: "血液", picture: res.Img_FigBlood, poorPicture: res.Img_FigPoorLines, discId: 67 }
    //{ name: "カビ", picture: res.Img_FigMold, poorPicture: res.Img_FigPoorLines, discId: }
];

pp.cuts = [
    { name: "古代の天文学者", picture: res.Img_CutOpeningA },
    { name: "地動説を唱える科学者", picture: res.Img_CutOpeningB },
    { name: "考える科学者", picture: res.Img_CutStudy },
    { name: "天体観測", picture: res.Img_CutAstronomy },
    { name: "力学実験", picture: res.Img_CutMechanics },
    { name: "熱力学実験", picture: res.Img_CutHeat },
    { name: "生物観察", picture: res.Img_CutBiology },
    { name: "光学実験", picture: res.Img_CutOptics },
    { name: "執筆", picture: res.Img_CutMath },
    { name: "大学での講義", picture: res.Img_CutLecture },
    { name: "科学アカデミー", picture: res.Img_CutSociety },
    { name: "単式顕微鏡での生物観察", picture: res.Img_CutBiology2 },
    { name: "大型望遠鏡での天体観測", picture: res.Img_CutAstronomy2 },
    { name: "発明品試作", picture: res.Img_CutMake },
    { name: "大著出版", picture: res.Img_ItemBook },
    { name: "役員就任", picture: res.Img_CutPresident },
    { name: "勲爵授与", picture: res.Img_CutKnighted }
];

//'*** ｱｲﾃﾑ画像ﾀｲﾌﾟ
pp.ipPrism = 0;         //'ﾌﾟﾘｽﾞﾑ
pp.ipTelescope = 1;     //'望遠鏡
pp.ipHourglass = 2;     //'砂時計
pp.ipClock = 3;         //'振り子時計
pp.ipWatch = 4;         //'ｾﾞﾝﾏｲ時計
pp.ipTemperature = 5;   //'温度計
pp.ipBall = 6;          //'ﾏｸﾃﾞﾌﾞﾙｸ半球
pp.ipBar = 7;           //'計算尺
pp.ipMicroscope1 = 8;   //'顕微鏡1
pp.ipMicroscope2 = 9;   //'顕微鏡2
pp.ipMicroscope3 = 10;  //'顕微鏡3
pp.ipPump = 11;         //'真空ﾎﾟﾝﾌﾟ
pp.ipRing = 12;         //'ﾆｭｰﾄﾝﾘﾝｸﾞ
pp.ipCalculator = 13;   //'計算機
pp.ipPolisher = 14;     //'研磨機
pp.ipEngine = 15;       //'機関
pp.ipQuadrant = 16;     //'四分儀

//*** アイテムID（必要に応じて定義）
pp.iiPrism = 0;
pp.iiMonoMicroscope = 6;
pp.iiTelescope = 14;
pp.iiVessel = 18;
pp.iiHourglass = 27;
pp.iiCompass = 29;

pp.basicItemIds = [ pp.iiTelescope, pp.iiHourglass, pp.iiVessel, pp.iiMonoMicroscope, pp.iiPrism, pp.iiCompass ];

//*** テーマID
pp.tiFinal = 20;

//*** コマンド
pp.cmCancel = pp.selCancel;
pp.cmSystem = 0;
pp.cmResearch = 1;
pp.cmStudy = 2;
pp.cmTheory = 3;
pp.cmMake = 4;
pp.cmLetter = 5;
pp.cmMove = 6;
pp.cmOccupation = 7;
pp.cmShop = 8;
pp.cmInfo = 9;
pp.cmRest = 10;
pp.cmChange = 11;
pp.cmReport = 12;
pp.cmWrite = 13;

pp.cmPlaceOffset = 100;
pp.cmPersonOffset = 200;
pp.cmSocietyOffset = 300;
pp.cmUniversityOffset = 400;
pp.cmObservatoryOffset = 500;

pp.cmPagerOffset = 10000;
pp.cmpMap = pp.cmPagerOffset + 1;
pp.cmpResearch = pp.cmPagerOffset + 2;
pp.cmpThemeMap = pp.cmPagerOffset + 3;
pp.cmpSystem = pp.cmPagerOffset + 4;

pp.cmrSelect = 0;
pp.cmrData = 1;
pp.cmrDeduce = 2;
pp.cmrReport = 4;
pp.cmrWrite = 5;
pp.cmrColabo = 6;
pp.cmrInfo = 7;
pp.cmrCancel = 8;
pp.cmrDiscovery = 9;
pp.cmrUnselect = 10;
pp.cmrItem = 11;
pp.cmrInfoTheme = 12;
pp.cmrInfoSelf = 13;

pp.cmsLibrary = 0;
pp.cmsSave = 1;
pp.cmsLoad = 2;
pp.cmsMessageSpeed = 3;
pp.cmsCpuTurn = 4;
pp.cmsQuitGame = 5;
pp.cmsAutoMode = 6;
pp.cmsDebug = 7;
pp.cmsCheckText = 8;

pp.cmdInfo = 0;
pp.cmdTheory = 1;
pp.cmdFigure = 2;
pp.cmdItem = 3;
pp.cmdWriteReport = 4;
pp.cmdSubmitReport = 5;
pp.cmdStopReport = 6;

//*** 人物ID
pp.piNewton = 0;
pp.piHooke = 1;
pp.piHalley = 2;
pp.piGuericke = 3;
pp.piHevelius = 4;
pp.piHuygens = 5;
pp.piLeibniz = 6;
pp.piCassini = 7;
pp.piBoyle = 8;
pp.piBernoulliJa = 9;
pp.piBernoulliJo = 10;
pp.piJudgeA = 11;
pp.piJudgeB = 12;
pp.piJudgeC = 13;
pp.piBecher = 14;
pp.piBarrow = 15;
pp.piLeeuwenhoek = 16;
pp.piPicard = 17;

pp.piAnne = 18;

//*** 都市ID
pp.plLondon = 0;
pp.plAmsterdam = 3;
pp.plCambridge = 5;

//*** 組織ID
pp.soLondon = 0;
pp.soParis = 1;

//*** 発見ID (必要に応じて定義)
pp.diPendulumPlain = 0; // 理論
pp.diAirTemprature = 17; // 発明
pp.diDione = 41; // 存在
pp.diSkin = 68; // スケッチ
pp.diPrincipia = 111;

//*** チュートリアル進み具合
pp.tuOff = -2;
pp.tuInvlalid = -1; //(まだチュートリアルするかどうか聞いていない)

pp.tuStart = 0;
pp.tuPages1 = pp.tuStart + 1;
pp.tuPages2 = pp.tuPages1 + 1;
pp.tuPages3 = pp.tuPages2 + 1;
pp.tuPages4 = pp.tuPages3 + 1;
pp.tuSelectTheme1 = pp.tuPages4 + 1;
pp.tuSelectTheme2 = pp.tuSelectTheme1+ 1;
pp.tuSelectEquip1 = pp.tuSelectTheme2 + 1;
pp.tuSelectEquip2 = pp.tuSelectEquip1 + 1;
pp.tuExperiment1 = pp.tuSelectEquip2 + 1;
pp.tuExperiment2 = pp.tuExperiment1 + 1;
pp.tuDiscovery = pp.tuExperiment2 + 1;
pp.tuTheory1 = pp.tuDiscovery + 1;
pp.tuTheory2 = pp.tuTheory1 + 1;
pp.tuTheory3 = pp.tuTheory2 + 1;
pp.tuWriteReport1 = pp.tuTheory3 + 1;
pp.tuWriteReport2 = pp.tuWriteReport1 + 1;
pp.tuWriteReport3 = pp.tuWriteReport2 + 1;
pp.tuSubmitReport1 = pp.tuWriteReport3 + 1;
pp.tuSubmitReport2 = pp.tuSubmitReport1 + 1;
pp.tuSubmitReport3 = pp.tuSubmitReport2 + 1;
pp.tuThemeMap = pp.tuSubmitReport3 + 1;
pp.tuMap = pp.tuThemeMap + 1;
pp.tuLast = pp.tuMap + 1;



//'********************************************************************
//'*                                                                  *
//'* ｹﾞｰﾑﾊﾞﾗﾝｽ定数                                                    *
//'*                                                                  *
//'********************************************************************
//'*** ｺｽﾄ定数
pp.monMax = 9999;               //'資金の最大値
pp.monLecture = 30;             //講義受講ｺﾏﾝﾄﾞのｺｽﾄ
pp.monTrain = 50;               //訓練ｺﾏﾝﾄﾞのｺｽﾄ

pp.monDonate = 100;             //'寄付ｺﾏﾝﾄﾞのｺｽﾄ(寄付額)

pp.famJoinSociety = 200;        //'組織に入会可能になる名声値
pp.famKnighthood = 2000;        //勲爵授与の対象となる名声値

pp.friendlinessMax = 100;
pp.friendlinessMin = 0;

pp.fameMax = 9999;
pp.fameMin = 0;

pp.fieldExperienceMax = 100;
pp.fieldKnowledgeMax = 100;

//*** From PRMediator.h
pp.scnInvalid = 0;
pp.scnTitle = 1;
pp.scnOpenning = 2;
pp.scnSelectPlayer = 3;
pp.scnCommand = 4;


pp.colText1 = cc.color(0,50,100);
pp.colStroke1 = cc.color(255,255,200);

pp.saveDataNameEmpty = "---";


//*** リストタイプ
pp.ltPerson = 0;
pp.ltItem = 1;
pp.ltTheme = 2;
pp.ltDiscovery = 3;
pp.ltReport = 4;
pp.ltSociety = 5;
pp.ltPlace = 6;
pp.ltOccupation = 7;
pp.ltUniversity = 8;
pp.ltObservatory = 9;

//*** 汎用リストフィルタ
pp.flAll = 0;
pp.flTextCheck = 1;
pp.flActive = 2;

//*** アイテムリストフィルタ
pp.fiPerson = 11;
pp.fiField =12;

//*** テーマリストフィルタ
pp.ftPerson = 11;

//*** 発見リストフィルタ
pp.fdPerson = 11;
pp.fdType = 12;

//*** 論文リストフィルタ
pp.frPerson = 11;
pp.frPublished = 12;
pp.frDiscType = 13;

//*** 人物表示フィールドタイプ
/*
pp.fstNormal = 1;
pp.fstAptitudes = 2;
*/

pp.maxNumItemsInThemeP = 2;

//*** Pages
pp.PG_INVALID = -1;
pp.PG_MAP = 0;
pp.PG_RESEARCH = 1;
pp.PG_THEME_MAP = 2;
pp.PG_SYSTEM = 3;

//*** General ALIGN
pp.ALIGN_NONE = 0;
pp.ALIGN_TOP_LEFT = 1;
pp.ALIGN_TOP_RIGHT = 2;
pp.ALIGN_BOTTOM_LEFT = 3;
pp.ALIGN_BOTTOM_RIGHT = 4;

//*** Short names
pp.LEFT = cc.TEXT_ALIGNMENT_LEFT;
pp.RIGHT = cc.TEXT_ALIGNMENT_RIGHT;
pp.CENTER = cc.TEXT_ALIGNMENT_CENTER;


//*** UI waiting mode
pp.MW_NOT_WAITING = 0;
pp.MW_USER = 1;
pp.MW_TIMEOUT = 2;
pp.MW_USER_OR_TIMEOUT = 3;
pp.MW_ANIME = 4;


//*** CPU algorithm type
pp.cpuDoNothing = 0;

pp.minCpuBaseLevel = 0; // 何もしない
pp.maxCpuBaseLevel = 2;
pp.minCpuLevel = 0; // 何もしない
pp.maxCpuLevel = 3;
pp.minCpuTotalLevel = 2;
pp.maxCpuTotalLevel = 5;

pp.monthNames = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];

pp.LN_JAPANESE = 0;
pp.LN_ENGLISH = 1;
pp.LN_CHINESE = 2;

pp.clmCleanup = 1;
pp.clmMore = 2;

pp.ctCheckAll = 0;
pp.ctCheckOne = 1;
pp.ctNoCheck = 2;

pp.commuMinFriendliness = 60;
pp.commuMinFameDiff = 300;

pp.ROW_HEIGHT = 40;
