
var pp = {

    world: null,
    mediator: null,
    story: null,

    libItem: null,
    libFigure: null,
    libCut: null,

    font: null
};

pp.main = function main () {

    //cc.log("@ " + arguments.callee.name + " called.");

    cc.sys.dump();

    cc.log("tm.p:" + tm.p("BROWSER MODE", "MAC OS MODE", "WINDOWS MODE"));

    tm.initTmd();
    tm.loadTmd();

    pp.font = tm.p("MS Gothic", "Hiragino Sans W3", "Meiryo");

    pp.world = new pp.PrWorld();
    pp.mediator = new pp.PrMediator();
    pp.story = new pp.PrStory();

    pp.story.goto(pp.story.stoMain, "Main");
};

pp.isIdValid = function (id) {
    return (cc.isUndefined(id) == false && typeof(id) != "object" && id != pp.ID_INVALID);
};

pp.getSaveDataName = function () {
    return pp.mediator.getDateString() + " " + pp.mediator.person.fullName;
};

pp.doSaveGame = function doSaveGame (fileIdx) {
    cc.log("@ " + arguments.callee.name + " called. arguments = " + arguments.toString());

    var prefix = "" + tm.appName + "Save" + fileIdx + ".";

    var str = JSON.stringify(pp.world);

    cc.sys.localStorage.setItem(prefix, str);

    //cc.log("(doSaveGame) world=" + str);
};

pp.doCheckGame = function doCheckGame (fileIdx) {
    cc.log("@ " + arguments.callee.name + " called. arguments = " + arguments.toString());

    var prefix = "" + tm.appName + "Save" + fileIdx + ".";
    var str = cc.sys.localStorage.getItem(prefix);

    return (str != null);
};

pp.doLoadGame = function doLoadGame (fileIdx) {
    cc.log("@ " + arguments.callee.name + " called. arguments = " + arguments.toString());

    var prefix = "" + tm.appName + "Save" + fileIdx + ".";

    var str = cc.sys.localStorage.getItem(prefix);
    if (str) {
        //cc.log("(doLoadGame) Found. world=" + str);

        var world = JSON.parse(str);

        pp.world.attr(world);

        /*

        pp.world.year = world.year;
        pp.world.month = world.month;
        pp.world.commandedPersonNum = world.commandedPersonNum;

        pp.world.tutorialLastMessage = world.tutorialLastMessage;
        pp.world.tutorialNextSelection = world.tutorialNextSelection;
        pp.world.tutorialStage = world.tutorialStage;

        var len = world.reports.length;
        pp.world.reports = [];
        for (var i = 0; i < len; i++) {
            pp.world.reports.push(new pp.PrReport());
            pp.world.reports[i].attr(world.reports[i]);
        }

        for(var i = 0; i < world.items.length; i++) {
            pp.world.items[i].attr(world.items[i]);
        }

        for(var i = 0; i < world.persons.length; i++) {
            pp.world.persons[i].attr(world.persons[i]);
        }

        for(var i = 0; i < world.societies.length; i++) {
            pp.world.societies[i].attr(world.societies[i]);
        }

        pp.world.shuffledPersonIds = world.shuffledPersonIds;
        pp.world.interestedPersonId = world.interestedPersonId;
        */
    }
    else {
        cc.log("(doLoadGame) Not found.");
    }

    pp.mediator.updateIsDemo();
};

pp.ATLAS_QUESTION = 0;
pp.ATLAS_THEORY = 1;
pp.ATLAS_ITEM_PRE = 2;
pp.ATLAS_FIGURE_PRE = 3;
pp.ATLAS_ITEM = 4;
pp.ATLAS_FIGURE = 5;
pp.ATLAS_THING = 6;
pp.ATLAS_BOOK = 7;

pp.ATLAS_REPORT = 8;
pp.ATLAS_REPORT_RELEASED = 9;

pp.ATLAS_BEGINNER = 11;

pp.ATLAS_ASTRO = 16;
pp.ATLAS_MECHA = 17;
pp.ATLAS_HEAT = 18;
pp.ATLAS_BIO = 19;
pp.ATLAS_OPT = 20;
pp.ATLAS_MATH = 21;

pp.ATLAS_SOCIETY_M = 24;
pp.ATLAS_UNIVERSITY_M = 25;
pp.ATLAS_OBSERBATORY_M = 26;

pp.ATLAS_SOCIETY_S = 32;
pp.ATLAS_TITLE_S = 33;
pp.ATLAS_HOME_S = 34;
pp.ATLAS_DATA_S = 35;
pp.ATLAS_DEDUCE_S = 36;
pp.ATLAS_DISCOVERY_S = 37;
pp.ATLAS_KNIGHTHOOD_S = 38;
pp.ATLAS_HAMMER_S = 39;
pp.ATLAS_PERSON_S = 40;

pp.createSpriteFrameFromAtlas = function (idx) {
    var sf = new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*(idx%8), 32*Math.floor(idx/8), 32, 32));
    return sf;
};

pp.createSpriteFromAtlas = function (idx, color, scale) {
    var spr = new cc.Sprite(res.Img_IconAtlas, cc.rect(32*(idx%8), 32*Math.floor(idx/8), 32, 32));
    //spr.texture.setAliasTexParameters();
    if (color) spr.color = color;
    if (scale) spr.scale = scale;
    return spr;
};


pp.printCsv = function (array, keys) {

    var str = "";
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        str += '"' + key + '"';
        if (i != keys.length) {
            str += ","
        }
    }
    cc.log(str);

    for (var j = 0; j < array.length; j++) {
        var elem = array[j];

        var str = "";
        for (var i = 0; i < keys.length; i++) {
            var key = keys[i];
            var val = elem[key]
            str += '"' + val + '"';
            if (i != keys.length) {
                str += ","
            }
        }
        cc.log(str);
    }
}

pp.printCsvs = function () {

    // Themes
    if (false)
    {
        cc.log("id, name, fieldId, knowledge, voiceT1, voiceT2, voiceT3, voiceE1, voiceE2, voiceE3");

        for (var i = 0; i < pp.world.themes.length; i++) {
            var t = pp.world.themes[i];

            cc.log("'" +
                t.id + "','" + t.name + "','" + t.fieldId + "','" + t.knowledge + "','" +
                t.voiceT1 + "','" + t.voiceT2 + "','" + t.voiceT3 + "','" +
                t.voiceE1 + "','" + t.voiceE2 + "','" + t.voiceE3 + "'");
        }
    }

    // Discoveries
    if (false)
    {
        pp.printCsv(pp.world.discoveries, [
            "id",
            "name",
            "data",
            "deduce",
            "engineering",
            "importance",
            "itemId",
            "themeId",
            "type",
            "credibility",
            "thingName",
            "voice"
        ]);
    }

    // Items
    if (false)
    {
        pp.printCsv(pp.world.items, [
            "id",
            "name",
            "fieldId",
            "gain",
            "note",
            "picture",
            "price",
            "isActive"
        ]);
    }

    // Persons
    if (false)
    {
        pp.printCsv(pp.world.persons, [
            "id",
            "idString",
            "name",

            "firstName",
            "lastName",

            "comprehend",
            "compose",
            "dexterity",
            "note",
            "birthYear",
            "deathYear"
        ]);
    }

};

pp.unlockItemsForDebug = function () {

    pp.libItem.unlockAll();
    pp.libFigure.unlockAll();
    pp.libCut.unlockAll();
};

pp.getAptitudeStr = function (a) {

    if (a < 30) return "Ｅ"; // 0〜29
    if (a < 50) return "Ｄ"; // 30〜49
    if (a < 70) return "Ｃ"; // 50〜69
    if (a < 80) return "Ｂ"; // 70〜79
    if (a < 90) return "Ａ"; // 80〜89
    return "Ｓ";　　          // 90〜100

};

pp.getCutId = function (imagePath) {
    for (var i = 0; i < pp.cuts.length; i++) {
        var cut = pp.cuts[i];
        if (cut.picture == imagePath) return i;
    }
    return pp.idInvalid;
};

pp.getCutName = function (imagePath) {
    for (var i = 0; i < pp.cuts.length; i++) {
        var cut = pp.cuts[i];
        if (cut.picture == imagePath) return cut.name;
    }
    return "";
};

pp.prDate = function(year, month) {
    return (tmd.language != pp.LN_ENGLISH) ?
        "" + year + "年 " + month + "月" :
    pp.monthNames[month-1] + " " + year;
};

pp.prDateWithDay = function(year, month, day) {
    return __(
        "" + year + "/" + month + "/" + day,
        "" + day + " " + pp.monthNames[month-1] + ", " + year,
        "" + year + "/" + month + "/" + day
    );
};
