
pp.PrStory = cc.Class.extend({

    _nextFunc: null,
    _nextLabel: null,

    _currentFunc: null,
    _currentLocal: null,

    ctor: function () {

        this._name = "PrStory";

        pp.storyFuncCallStack = [];
        pp.storyFuncLabelStack = [];
        pp.storyFuncLocalStack = [ {} ];
    },

    goto: function (toFunc, toLabel, userSel, delayInSec) {

        //cc.log("[goto] " + (typeof toFunc == "string" ? "nextLabel=" + toFunc : "toFunc=" + toFunc.funcName + ", toLabel=" + toLabel) + ", userSel=" + userSel);

        this.prepareCallbackInfo(toFunc, toLabel);

        this.doGoto(userSel, delayInSec);
    },

    doGoto: function (userSel, delayInSec) {

        var currentLocal = this.getLocal();
        var func = this._nextFunc.bind(this, this._nextLabel, userSel, currentLocal.arg0, currentLocal.arg1, currentLocal.arg2);
        var delay = delayInSec || 0;
        setTimeout(func, delay*1000);

        this._nextLabel = null;
    },

    prepareCallbackInfo: function (arg0, arg1) {
        var nextFunc;
        var nextLabel;
        if (typeof arg0 == "string") {
            nextLabel = arg0;
            nextFunc = arg1 || this._nextFunc;
        }
        else {
            nextFunc = (arg0 || this._nextFunc); //.bind(this, nextLabel);
            nextLabel = arg1 || this._nextLabel;
        }
        this._nextFunc = nextFunc;
        this._nextLabel = nextLabel;
    },

    callTutorialFunc: function (retLabel, func, arg0, arg1, arg2) {

        this.callStoryFuncIf(
            retLabel,
            pp.world.tutorialStage != pp.tuOff,
            func, arg0, arg1, arg2);
    },

    callStoryFunc: function (retLabel, func, arg0, arg1, arg2) {
        pp.storyFuncCallStack.push(this._currentFunc);
        pp.storyFuncLabelStack.push(retLabel);
        var local = {
            arg0: arg0,
            arg1: arg1,
            arg2: arg2
        };
        pp.storyFuncLocalStack.push(local);
        this.goto(func, undefined, undefined);

        //cc.log("[callStoryFunc] CALLSTACK LENGTH=" + pp.storyFuncCallStack.length);
    },

    callStoryFuncIf: function (retLabel, cond, func, arg0, arg1, arg2) {

        if (!cond) { this.goto(retLabel, null, null); return; }

        this.callStoryFunc(retLabel, func, arg0, arg1, arg2);
    },

    loadDatabase: function (retLabel) {
        pp.world.loadDatabase(function () {

            pp.mediator.updateIsDemo();

            pp.world.persons[pp.piNewton].cpuLevel = 3;
            //pp.world.persons[pp.piLeibniz].cpuLevel = 3;
            //pp.world.persons[pp.piHuygens].cpuLevel = 3;

            this.goto(this._currentFunc, retLabel);
        }, this);
    },

    loadLcDatabase: function (retLabel) {
        lc.loadDatabase(function () {
            this.goto(this._currentFunc, retLabel);
        }, this)
    },

    loadDatabaseAndInitForCheck: function (retLabel) {
        pp.world.loadDatabase(function () {

            pp.mediator.personId = pp.piNewton;
            pp.mediator.person.isManual = true;
            pp.mediator.updateIsDemo();

            //*** Cheat Codes
            pp.mediator.person.money = pp.monMax;
            for(var i = 0; i < pp.world.items.length; i++) pp.mediator.person.itemNums[i] = 1;

            this.goto(this._currentFunc, retLabel);
        }, this);
    },


    getLocal: function () {
        return pp.storyFuncLocalStack[pp.storyFuncLocalStack.length-1] || {};
    },

    returnFromStoryFunc: function (ret) {
        var func = pp.storyFuncCallStack.pop();
        var label = pp.storyFuncLabelStack.pop();
        pp.storyFuncLocalStack.pop();
        //cc.log("  [returnFromStoryFunc]");
        this.goto(func, label, ret);

        //cc.log("[returnFromStoryFunc] CALLSTACK LENGTH=" + pp.storyFuncCallStack.length);
    },

    waitMediatorWithCallbackLabel: function (label, timeout) {
        this.prepareCallbackInfo(label);

        //cc.log("== waitMediatorWithCallbackInfo with _nextFunc="+ this._nextFunc.funcName + ", _nextLabel="+ this._nextLabel);
    },

    didWaitMediator: function (userSel) {
        //cc.log("## didWaitMediator with sel=" + userSel + ", nextFunc=" + this._nextFunc.funcName + ", nextLabel="+ this._nextLabel);

        if (this._nextFunc) {
            this.doGoto(userSel);
        }
        else {
            cc.log("WARNING: Empty nextFunc (" + this._nextFunc + ")");
        }

        pp.mediator.waitingMode = pp.MW_NOT_WAITING;
        //cc.log("MW_NOT_WAITING");
    },

    //----------------------------------------------------------------------

    wuiWaitUserInput: function (callbackLabel) {
        pp.mediator.wuiWaitUserInput();
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    //---------------------------------------------------------------

    //@@@
    uiShowCongrats: function (callbackLabel) {
        pp.mediator.uiShowCongrats();
    },
    //@@@
    wuiShowMessageTmp: function (callbackLabel, message, caption, backOpacity) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowMessageTmp(message, caption, backOpacity);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },
    //@@@
    wuiShowCut: function (callbackLabel, image) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowCut(image);

        if (pp.mediator.person && pp.mediator.person.isManual)
            pp.libCut.unlock(pp.getCutId(image));

        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowBigMessage: function (callbackLabel, message, align) {
        pp.mediator.wuiShowBigMessage(message, align);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowThankYou: function (callbackLabel, personId) {
        pp.mediator.wuiShowThankYou(personId);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowClickToStart: function (callbackLabel) {
        pp.mediator.wuiShowClickToStart();
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowMessageFlat: function (callbackLabel, message, caption, backOpacity) {
        this.wuiShowMessage(callbackLabel, message, caption, backOpacity, pp.POP_FRM_FLAT);
    },

    wuiShowMessage: function (callbackLabel, message, caption, backOpacity, frameType, captionType, forceWaitUser) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowMessage(message, caption, backOpacity, frameType, captionType, forceWaitUser);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowTutorial: function (callbackLabel, message, keepBalloons, popPos, caption) {
        pp.mediator.wuiShowTutorial(message, keepBalloons, popPos, caption);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowMessageEx: function (callbackLabel, message, image, backOpacity) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.libCut.unlock(pp.getCutId(image));

        pp.mediator.wuiShowMessageEx(message, image, backOpacity);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowLetter: function (callbackLabel, subject, body, date, personId, caption, allowOverlap) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowLetter(subject, body, date, personId, caption, allowOverlap);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowPerson: function (callbackLabel, personId, pageIdx, caption, buttonType, waitingMode, popPos, allowOverlap) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowPerson(personId, pageIdx, caption, buttonType, waitingMode, popPos, allowOverlap);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowReportTabbed: function (callbackLabel, reportId, caption, waitingMode, backOpacity, allowOverlap) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowReportTabbed(reportId, caption, waitingMode, backOpacity, allowOverlap);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowPrObj: function (callbackLabel, popClass, id, waitingMode, backOpacity, allowOverlap, options) {

        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowPrObj(popClass, id, waitingMode, backOpacity, allowOverlap, options);

        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowReport: function (callbackLabel, reportId, waitingMode, backOpacity, allowOverlap) {
        if (tm.m()) {
            this.wuiShowReportTabbed(callbackLabel, reportId, null, waitingMode, backOpacity, allowOverlap);
        }
        else {
            this.wuiShowPrObj(callbackLabel, pp.PopDetailReport, reportId, waitingMode, backOpacity, allowOverlap);
        }
    },

    wuiShowFigure: function (callbackLabel, figId, score, waitingMode) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailFigure, [figId, score], waitingMode);
    },

    wuiShowItem: function (callbackLabel, itemId, personId, waitingMode) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailItem, [itemId, personId], waitingMode);
    },

    wuiShowSociety: function (callbackLabel, societyId, waitingMode, options) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailSociety, societyId, waitingMode, null, null, options);
    },

    wuiShowPlace: function (callbackLabel, placeId, waitingMode, options) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailPlace, placeId, waitingMode, null, null, options);
    },

    wuiShowUniversity: function (callbackLabel, univId, waitingMode, options) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailUniversity, univId, waitingMode, null, null, options);
    },

    wuiShowObservatory: function (callbackLabel, obsId, waitingMode, options) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailObservatory, obsId, waitingMode, null, null, options);
    },

    wuiShowDiscovery: function (callbackLabel, discId, personId, waitingMode) {
        this.wuiShowPrObj(callbackLabel, pp.PopDetailDiscovery, [discId, personId], waitingMode);
    },

    wuiShowTheme: function (callbackLabel, themeId, waitingMode, buttonType) {
        //this.wuiShowPrObj(callbackLabel, pp.PopDetailTheme, themeId, waitingMode);

        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowTheme(themeId, waitingMode, buttonType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    //------

    wuiShowParamChange: function (callbackLabel, paramName, fromVal, toVal, paramOwnerName, allowOverlap, popPos) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowParamChange(paramName, fromVal, toVal, paramOwnerName, allowOverlap, popPos);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowVoice: function (callbackLabel, personId, image, voice, caption, allowOverlap) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowVoice(personId, image, voice, caption, allowOverlap);

        if (pp.mediator.person && pp.mediator.person.isManual)
            pp.libCut.unlock(pp.getCutId(image));

        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowVoiceS: function (callbackLabel, personIdx, voice, allowOverlap, allowStay) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        if (tm.m() && (personIdx == 4)) {
            var personId = pp.mediator.personEId;
            this.wuiShowVoice(callbackLabel, personId, null, voice);
        }
        else {
            pp.mediator.wuiShowVoiceS(personIdx, voice, allowOverlap, allowStay);
            this.waitMediatorWithCallbackLabel(callbackLabel);
        }
    },

    wuiShowVoiceSById: function (callbackLabel, personId, voice) {

        var idx = pp.idxInvalid;
        if (pp.mediator.scn instanceof pp.ScnSociety)
            idx = pp.mediator.scn.personIdxFromId(personId);

        if (idx == pp.idxInvalid) {
            this.wuiShowVoice(callbackLabel, personId, null, voice);
        }
        else {
            this.wuiShowVoiceS(callbackLabel, idx, voice);
        }
    },

    wuiShowCutS: function (callbackLabel, image) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        if (pp.mediator.person && pp.mediator.person.isManual)
            pp.libCut.unlock(pp.getCutId(image));

        pp.mediator.wuiShowCutS(image);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiShowReportS: function (callbackLabel, reportId) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiShowReportS(reportId);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSetFocusOnPlace: function (callbackLabel, placeId) {
        if (pp.mediator.toShowMessage == false) { this.goto(callbackLabel); return; }

        pp.mediator.wuiSetFocusOnPlace(placeId);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSetScene: function (callbackLabel, scnClass, arg0, transitionClass, delay, forced) {
        if (pp.mediator.toShowMessage == false && !forced) { this.goto(callbackLabel); return; }

        if (pp.mediator.scn instanceof scnClass && forced != true) {
            this.prepareCallbackInfo(callbackLabel);
            this.didWaitMediator();
        }
        else {
            pp.mediator.wuiSetScene(scnClass, arg0, transitionClass, delay);
            this.waitMediatorWithCallbackLabel(callbackLabel);
        }
    },

    wuiPushScene: function (callbackLabel, scnClass, arg0, transitionClass, delay, forced) {
        if (pp.mediator.toShowMessage == false && !forced) { this.goto(callbackLabel); return; }

        pp.mediator.wuiPushScene(scnClass, arg0, transitionClass, delay);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiPopScene: function (callbackLabel, transitionClass, delay, forced) {
        if (pp.mediator.toShowMessage == false && !forced) { this.goto(callbackLabel); return; }

        pp.mediator.wuiPopScene(transitionClass, delay);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectOkCancel: function (callbackLabel, messages, frameType) {
        pp.mediator.wuiSelectOkCancel(messages, frameType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectYesNo: function (callbackLabel, messages) {
        pp.mediator.wuiSelectYesNo(messages);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectOptions: function (callbackLabel, options, caption, xMagnitude) {
        pp.mediator.wuiSelectOptions(options, caption, xMagnitude);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectOptionsWithCancel: function (callbackLabel, options, caption, xMagnitude, backOpacity, frameType, fontSize) {
        pp.mediator.wuiSelectOptionsWithCancel(options, caption, xMagnitude, backOpacity, frameType, fontSize);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectThemeIdx: function (callbackLabel) {
        pp.mediator.wuiSelectThemeIdx();
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectTheme: function (callbackLabel) {
        pp.mediator.wuiSelectTheme();
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectPerson: function (callbackLabel, caption, filterType) {
        pp.mediator.wuiSelectPerson(caption, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectReport: function (callbackLabel, caption, filterType) {
        pp.mediator.wuiSelectPrObj(pp.ltReport, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);

    },

    wuiSelectSociety: function (callbackLabel, caption, filterType) {
        pp.mediator.wuiSelectPrObj(pp.ltSociety, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);

    },

    wuiSelectDiscovery: function (callbackLabel, filterType) {
        pp.mediator.wuiSelectPrObj(pp.ltDiscovery, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectOccupation: function (callbackLabel, filterType) {
        pp.mediator.wuiSelectPrObj(pp.ltOccupation, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectPlace: function (callbackLabel) {
        pp.mediator.wuiSelectPrObj(pp.ltPlace, null);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectItem: function (callbackLabel, filterType) {
        pp.mediator.wuiSelectPrObj(pp.ltItem, filterType);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectUniversity: function (callbackLabel) {
        pp.mediator.wuiSelectPrObj(pp.ltUniversity, null);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiSelectObservatory: function (callbackLabel) {
        pp.mediator.wuiSelectPrObj(pp.ltObservatory, null);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    //------

    wuiEffectItemSelected: function (callbackLabel, itemId, pos) {
        pp.mediator.wuiEffectItemSelected(itemId, pos);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    },

    wuiEffectItemUnselected: function (callbackLabel, itemId, pos) {
        pp.mediator.wuiEffectItemSelected(itemId, pos, true);
        this.waitMediatorWithCallbackLabel(callbackLabel);
    }

});

//////////////////////////////////////////////////////////////////////////////

pp.PrStory.buildStoryFunc = function (funcName, funcContent) {
   var func = function (label, userSel, arg0, arg1, arg2) {

        this._currentFunc = this[funcName];
        this._nextFunc = this[funcName];

        //cc.log(funcName + " called. label=" + label + ", sel=" + userSel);

        funcContent.call(this, label, userSel, arg0, arg1, arg2);
    };
    func.funcName = funcName;
    pp.PrStory.prototype[funcName] = func;
};

//////////////////////////////////////////////////////////////////////////////

var sto;
var stol;
var goto = function () {};
var gotoIf = function () {};
var sleep = function () {};

//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrStory.prototype;
cc.defineGetterSetter(_p, "local", _p.getLocal);
