/**
 * Created by hirota on 1/17/15.
 */


var tmd = tmd || {};

var tmdCache = tmdCache || {};

var tm = tm || {
        appName: "principia"
    };

tm.system_settings = {

    language: {
        caption: "言語／Language",
        options: ["日本語", "English", "中文"]
    },

    messageSpeed: {
        caption: "メッセージ速度",
        options: ["速い", "ふつう", "遅い", "止まる"]
    },

    cpuBaseLevel: {
        caption: "コンピューターの思考",
        options: ["怠惰（練習用）", "通常", "強い"]
    },

    toShowCpuTurn: {
        caption: "コンピューターのターン",
        options: ["全員見る", "１人だけ見る", "見ない"]
    },

    toShowOpening: {
        caption: "オープニング",
        options: ["表示しない", "表示する"]
    },

    toShowTutorial: {
        caption: "チュートリアル",
        options: ["表示しない", "開始時に選択"]
    },

    researchBoost: {
        caption: "研究の進捗",
        options: ["標準", "10倍", "100倍"]
    }

};

tm.initTmd = function () {

    tmd = {
        dataVersion: "0.1",

        sound: true,
        language: 0,
        toShowCpuTurn: pp.ctNoCheck,
        messageSpeed: 3,
        savedDataNames: [ "---", "---", "---", "---", "---", "---" ],

        toShowOpening: 1,
        toShowTutorial: 1,
        cpuBaseLevel: 1,

        researchBoost: 0,
        debugPreselectedPersonId: pp.ID_INVALID
    };

    tmd.unlockedItemIds = new Array(32);
    for (var i = 0; i < tmd.unlockedItemIds.length; i++) {
        tmd.unlockedItemIds[i] = false;
    }

    tmd.unlockedFigureIds = new Array(pp.figures.length);
    for (var i = 0; i < tmd.unlockedFigureIds.length; i++) {
        tmd.unlockedFigureIds[i] = false;
    }

    tmd.unlockedCutIds = new Array(pp.cuts.length);
    for (var i = 0; i < tmd.unlockedCutIds.length; i++) {
        tmd.unlockedCutIds[i] = false;
    }

    switch (cc.sys.language) {
        case 'jp':
        case 'ja':
            tmd.language = pp.LN_JAPANESE;
            break;
        default:
            tmd.language = pp.LN_ENGLISH;
            break;
    }

    pp.libItem = new pp.LibItem();
    pp.libFigure = new pp.LibFigure();
    pp.libCut = new pp.LibCut();
};

tm.saveTmd = function () {
    var str = JSON.stringify(tmd);
    cc.sys.localStorage.setItem(tm.appName, str);

    cc.log("(saveTmd) Data saved."); // str = " + str);
};

tm.loadTmd = function () {
    var str = cc.sys.localStorage.getItem(tm.appName);
    if (str) {
        tmd = JSON.parse(str);

        pp.libItem = new pp.LibItem();
        pp.libFigure = new pp.LibFigure();
        pp.libCut = new pp.LibCut();

        cc.log("(loadTmd) Data found and loaded."); // str= " + str);
    }
    else {
        cc.log("(loadTmd) Data not found.")
    }
};

tm.m = function (valMobile, valPc) {

    if (cc.isUndefined(valMobile))
        return tm.isMobile();

    return tm.isMobile() ? valMobile : valPc;
};

tm.p = function (valBrowser, valMacOrIos, valWinOrAndroid) {

    if (cc.sys.browserType)
        return valBrowser;

    if (cc.sys.os == cc.sys.OS_OSX || cc.sys.os == cc.sys.OS_IOS)
        return valMacOrIos;

    return valWinOrAndroid;
};

tm.pauseNode = function (node) {
    if (!node) return;
    node.pause();
    var children = node.getChildren();
    for (var i = 0; i < children.length; i++) {
        tm.pauseNode(children[i]);
    }
};

tm.resumeNode = function (node) {
    if (!node) return;
    node.resume();
    var children = node.getChildren();
    for (var i = 0; i < children.length; i++) {
        tm.resumeNode(children[i]);
    }
};

tm.to2ByteWidthNumber = function (i) {

    switch (i) {
        case 0: return "０";
        case 1: return "１";
        case 2: return "２";
        case 3: return "３";
        case 4: return "４";
        case 5: return "５";
        case 6: return "６";
        case 7: return "７";
        case 8: return "８";
        case 9: return "９";
    }

    return "" + i; // Eg. "10" for 10 instead of "１０"
};

tm.toWideCharNumbers = function (i) {

    var str = "" + i;

    return str.replace(/[0-9]/g, function(s) {
        return String.fromCharCode(s.charCodeAt(0) + 0xFEE0);
    });
};

tm.clone = function (obj) {
    var newObj = (obj.constructor) ? new obj.constructor : {};

    for (var key in obj) {
        var copy = obj[key];
        // Beware that typeof null == "object" !
        if (((typeof copy) == "object") && copy &&
            !(copy instanceof cc.Node) /*&& !(copy instanceof HTMLElement)*/) {
            newObj[key] = tm.clone(copy);
        } else {
            newObj[key] = copy;
        }
    }
    return newObj;
};

tm.blink = function (duration, blinks) {
    return new cc.Blink(duration, cc.sys.browserType ? blinks : duration * blinks);
};

tm.Sequence = {};

tm.Sequence._actionOneTwo = function (actionOne, actionTwo) {
    var sequence = new cc.Sequence();
    sequence.initWithTwoActions(actionOne, actionTwo);
    return sequence;
};

tm.repeatForever = function (tempArray) {

    var paramArray = (tempArray instanceof Array) ? tempArray : arguments;
    if ((paramArray.length > 0) && (paramArray[paramArray.length - 1] == null))
        cc.log("parameters should not be ending with null in Javascript");

    var prev = paramArray[0];
    for (var i = 1; i < paramArray.length; i++) {
        if (paramArray[i])
            prev = tm.Sequence._actionOneTwo(prev, paramArray[i]);
    }

    return new cc.RepeatForever(prev);
};


tm.LabelTTF = cc.Layer.extend({

    _label: null,
    _labelForStrokes: null,
    _strokeSize: 1,
    _fontHeight: 1,
    //sprPpi: null,

    ctor: function (str, font, height, strokeColor, textColor, strokeSize) {

        this._super();

        var lbl = new cc.LabelTTF(str, font, height);
        this.addChild(lbl, 0); //-1);
        this.attr({
            ignoreAnchor: false
        });
        if (lbl.setLineHeight) lbl.setLineHeight(height * 1.25);
        this._label = lbl;

        textColor = textColor ? textColor : cc.color.WHITE;
        strokeSize = strokeSize ? strokeSize : 1;

        this._fontHeight = height;
        this._strokeSize = strokeSize;

        lbl.setFontFillColor(textColor);

        this.setCascadeOpacityEnabled(true);

        this._labelForStrokes = null;

        this.setFontStroke(strokeColor, strokeSize);

        this.uiUpdate();
    },

    setFontFillColor: function (color) {
        this._label.setFontFillColor(color);
    },

    setFontStroke: function (strokeColor, strokeSize) {

        if (strokeSize)
            this._strokeSize = strokeSize;
        else
            strokeSize = this._strokeSize;


        if (this._labelForStrokes) {
            this._labelForStrokes.forEach(function (lbl) {
                if (lbl)
                    lbl.removeFromParent();
            });
        }
        this._labelForStrokes = null;

        if (strokeColor) {

            this._labelForStrokes = [ null, null, null, null ];

            for (var i = 0; i < 4; i++) {

                this._labelForStrokes[i] = new cc.LabelTTF(this._label.string, this._label.fontName, this._fontHeight);
                this._labelForStrokes[i].attr({
                    x: strokeSize * ([-1,0,1,0][i]),
                    y: strokeSize * ([0,-1,0,1][i])
                });
                if (this._labelForStrokes[i].setLineHeight) this._labelForStrokes[i].setLineHeight(this._fontHeight * 1.25);
                this._labelForStrokes[i].setFontFillColor(strokeColor);
                this._labelForStrokes[i].setCascadeOpacityEnabled(true); //@@@

                this.addChild(this._labelForStrokes[i], -2);
            }
        }
    },

    setContentSize: function (width, height) {

        this._super(width, height);

        var DY = tm.p(0, 0, 0);

        this._label.attr({ x: this.width / 2, y: this.height / 2 + DY });

        if (this._labelForStrokes) {
            for (var i = 0; i < this._labelForStrokes.length; i++) {
                this._labelForStrokes[i].attr({
                    x: this._label.x + this._strokeSize * ([-1,0,1,0][i]),
                    y: this._label.y + this._strokeSize * ([0,-1,0,1][i])
                });
            }
        }
    },

    setString: function (str) {

        this._label.setString(str);

        if (this._labelForStrokes) {
            for (var i = 0; i < this._labelForStrokes.length; i++) {
                this._labelForStrokes[i].setString(str);
            }
        }

        this.uiUpdate();
    },

    setHorizontalAlignment: function (alignment) {

        this._label.setHorizontalAlignment(alignment);

        if (this._labelForStrokes) {
            for (var i = 0; i < this._labelForStrokes.length; i++) {
                this._labelForStrokes[i].setHorizontalAlignment(alignment);
            }
        }
    },

    setDimensions: function (width, height) {

        this._label.setDimensions(width, height);

        if (this._labelForStrokes) {
            for (var i = 0; i < this._labelForStrokes.length; i++) {
                this._labelForStrokes[i].setDimensions(width, height);
            }
        }

        this.uiUpdate();
    },

    uiUpdate: function () {
        this.setContentSize(this._label.width, this._label.height - tm.p(0, this._fontHeight * 0.2, 0));
    },

    getString: function () {
        return this._label.getString();
    }

});


var _p = tm.LabelTTF.prototype;
// Override properties
cc.defineGetterSetter(_p, "string", _p.getString, _p.setString);


tm.isInside = function (touchPos, node) {

    if (node == null) {
        return false;
    }

    var nodeWorldPos;
    nodeWorldPos = node.convertToWorldSpace();//cc.p(node.x, node.y));

    var nodeRect;
    if (node.ignoreAnchor) {
        nodeRect = cc.rect(nodeWorldPos.x, nodeWorldPos.y, node.width, node.height);
    }
    else {
        nodeRect = cc.rect(
            nodeWorldPos.x,// - (node.width * node.anchorX),
            nodeWorldPos.y,// - (node.height * node.anchorY),
            node.width,
            node.height);
    }

    var ret;

    if (touchPos.x > nodeRect.x &&
        touchPos.x < nodeRect.x + nodeRect.width-1 &&
        touchPos.y > nodeRect.y &&
        touchPos.y < nodeRect.y + nodeRect.height-1) {

        ret = true;
    }
    else {
        ret = false;
    }
/*
    cc.log("nodeRect=(" + nodeRect.x + ", " + nodeRect.y + ", " + nodeRect.width + ", " + nodeRect.height + ")");
    cc.log("touchPos=(" + touchPos.x + ", " + touchPos.y + ")");
    cc.log("isInside=" + ret + "\n");
*/
    return ret;


};


tm.getTouchPos = function (touch) {

    var touchPos = touch.getLocationInView();

    if (cc.sys.browserType == null) {
        touchPos.y = cc.winSize.height - touchPos.y;
    }

    return touchPos;
};

tm.int = function (a) {
    return Math.floor(a);
};

tm.max = function (a, b) {
    return a > b ? a : b;
};

tm.imax = function (a, b) {
    return tm.int(tm.max(a, b));
};

tm.min = function (a, b) {
    return a > b ? b : a;
};

tm.imin = function (a, b) {
    return tm.int(tm.min(a, b));
};

tm.itrim = function (a, amin, amax) {
    return tm.imin(amax, tm.imax(amin, a));
};

tm.arc4random = function () {
    return tm.int(cc.rand());
};

tm.irand = function (from, to) {
    if (cc.isUndefined(from)) {
        return tm.arc4random();
    }
    if (cc.isUndefined(to)) {
        return tm.irand(0, from - 1);
    }

    from = tm.int(from);
    to = tm.int(to);

    if (from == to) return from;
    if (to < from) { var a = to; to = from; from = a; }

    return tm.arc4random() % (to - from + 1) + from;
};

tm.padRight = function (str, length) {
    return (str + " ".repeat(length)).substr(0, length);
};

tm.insertNewLines = function (str, nCharPerLine, newLineChar, ignoreSpace) {

    newLineChar = newLineChar || CR;

    var newStr = "";
    do {
        var lines = str.split(newLineChar);
        if (lines.length > 1 && lines[0].length <= nCharPerLine) {
            newStr += lines.shift() + newLineChar;
            str = "";
            while (lines.length > 0) {
                str += lines.shift();
                if (lines.length > 0) str += newLineChar;
            }
            continue;
        }

        var aLine = str.substr(0, nCharPerLine);
        var rest = str.substr(nCharPerLine);

        var iSpace = aLine.lastIndexOf(" ");
        if (rest && iSpace != -1 && !ignoreSpace) {
            if (aLine.charAt[aLine.length] == " ") {
                aLine = aLine.substr(0, nCharPerLine - 1);
            }
            else if (rest.charAt[0] == " ") {
                rest = rest.substr(1);
            }
            else {
                aLine = str.substr(0, iSpace);
                rest = str.substr(iSpace+1);
            }
        }

        newStr += aLine;
        if (rest) {
            newStr += newLineChar;
            str = rest;
        }
        else break;
    }
    while (true);

    return newStr;
};

tm.buildOptionStr = function (tmdName) {

    var setting = tm.system_settings[tmdName];

    var options = setting.options;
    var caption = __(setting.caption);
    var val = tmd[tmdName];

    return caption + ": " + __(options[val]);
};

tm.truncate = function (str, nChar) {
    if (str.length <= nChar) return str;

    return str.substr(0, nChar) + "..";

};

tm.isNumber = function (str) {
    var num = Number(str);
    return !isNaN(num) && cc.isNumber(num);
};

//----------------------------------------------------------------------

cc.Animation.prototype.addSpriteFrameWithTextureEx = function (texture, rect, offset, nFrame) {

    for (var i = 0; i < (nFrame ? nFrame : 1); i ++) {

        var pFrame = new cc.SpriteFrame(texture, rect);
        if (offset) {
            pFrame.setOffset(offset);
        }
        this.addSpriteFrame(pFrame);
    }
};

cc.Animation.prototype.addSpriteFrameWithFileEx = function (filename, nFrame, offset) {

    for (var i = 0; i < (nFrame ? nFrame : 1); i ++) {

        var spr = new cc.Sprite(filename);
        var pFrame = new cc.SpriteFrame(spr.getTexture(), spr.getTextureRect());
        if (offset) {
            pFrame.setOffset(offset);
        }
        this.addSpriteFrame(pFrame);
    }
};

tm.isNative = function () {
    return cc.sys.browserType == null;
};

tm.isMobile = function () {
    return cc.winSize.width < cc.winSize.height;
};

tm.TransitionFade = 0;
tm.TransitionFlipX = 1;
tm.TransitionSlideInL = 2;

cc.Director.prototype.popSceneWithTransitionB = function (transition, duration)
{
    if (tm.isNative()) {

        var transitionType =
            transition == cc.TransitionFade ? tm.TransitionFade :
            transition == cc.TransitionFlipX ? tm.TransitionFlipX :
            transition == cc.TransitionSlideInL ? tm.TransitionSlideInL :
                tm.TransitionFade;

        jsb.reflection.callStaticMethod("JsbDirector", "popScene:WithTransition:", duration, transitionType);

    }
    else {
        cc.assert(this._runningScene, "running scene should not null");

        this._scenesStack.pop();
        var c = this._scenesStack.length;

        if (c === 0)
            this.end();
        else {
            //var sceneWithTransition = new transition(duration, this._scenesStack[c-1]);
            var sceneWithTransition = transition.create(duration, this._scenesStack[c-1]);

            this._scenesStack[c-1] = sceneWithTransition;

            this._sendCleanupToScene = true;
            this._nextScene = this._scenesStack[c - 1];
        }
    }

};

//----------------------------------------------------------------------

String.prototype.format = function()
{
    var args = arguments;

    return this.replace(/{(\d+)}/g, function(match, number) {
        return typeof args[number] != 'undefined' ? args[number] : match;
    });
};
