
pp.PrObject = cc.Class.extend({

    attr: function (attrs) {
        for (var key in attrs) {
            if (key == "__proto__") {
                continue;
            }

            var newValue = attrs[key];
            if (this[key] instanceof pp.PrObject) {
                this[key].attr(newValue);
            }
            else if (cc.isArray(this[key]) && this[key][0] instanceof pp.PrObject) {
                this[key].length = newValue.length;
                for (var i = 0; i < newValue.length; i++) {
                    if (!this[key][i]) {
                        this[key][i] = new this[key][0].constructor();
                    }
                    this[key][i].attr(newValue[i]);
                }
            }
            else {
                this[key] = newValue;
            }
        }
    },

    ctor: function () {
    },

    getFieldsToSave: function () {
        // virtual method; toJSON の対象にすべきプロパティ名のリストを返す
        // null は全て対象の意味
        // [] は全て非対象の意味
        return [];
    },

    toJSON: function () {

        var obj = {};
        var whiteList = this.getFieldsToSave();

        for (var key in this) {
            if (["__instanceId"].indexOf(key) >= 0) continue;
            if (Array.isArray(whiteList) && whiteList.indexOf(key) < 0) continue;

            obj[key] = this[key];
        }

        return obj;
    }

});

pp.PrObject.prototype.tableName = function () {
    cc.log("You must override this function in a subclass.");
    return null;
};

pp.PrObject.prototype.createArray = function (database) {

    var dbTableLc;
    var dbTable = database[this.tableName()];

    if (tmd.language == pp.LN_ENGLISH) {
        dbTableLc = database[this.tableName() + "En"];
    }
    else if (tmd.language == pp.LN_CHINESE) {
        dbTableLc = database[this.tableName() + "Zh"];
    }

    var resultArray = new Array(dbTable.length);

    for (var i = 0; i < dbTable.length; i++) {
        resultArray[i] = new this.constructor(dbTable[i], database);

        if (dbTableLc) {
            var toOverwrite = dbTableLc[i];
            resultArray[i].attr(toOverwrite);
        }
    }

    return resultArray;
};
