
pp.PrPerson = pp.PrObject.extend({

    /*

    Replacing regexp from Objective-C code. :)
    (1) Variables
     :%s/.* [a-zA-Z_\*]* \([a-zA-Z\*]*\);/\1: null,/

    (2) Methods with args
     :%s/-([^)]*)\([a-zA-Z]*\).*)\()*[^)]*\);/\1: function(\2) {},/

    (3) Method without args
     :%s/-([^)]*)\([a-zA-Z]*\);/\1: function() {},/

    */

    //Dummies for properties
    reports: null,
    fullName: null,
    age: null,
    imageFileName: null,
    discoveries: null,
    societyName: null,
    jobName: null,

    //---

    id: null,
    idString: null,
    name: null,

    firstName: null,
    lastName: null,

    comprehend: null,
    compose: null,
    dexterity: null,
    note: null,
    birthYear: null,
    deathYear: null,

    //--- Dynamic data ---

    fame: 0,
    money: 0,
    placeId: 0,
    state: 0,
    occupationId: 0,
    societyId: 0,
    jobIdx: 0,

    fieldPs: null,
    themePs: null,
    discCredibilities: null,
    itemNums: null, // 0 or 1
    friendlinesses: null,

    knightedSocietyId: 0,

    discourageMonths: 0,
    gutlessMonths: 0,

    diary: "",

    //--- Preference ---
    preferredPage: 0,

    //--- Others ---
    isManual: false,
    firstTurn: false,

    //--- For CPU ---
    cpuLevel: 0,
    homePlaceId: 0,


    getFieldsToSave: function () {

        var whiteList = [
            "id",
            "fame",
            "money",
            "placeId",
            "state",
            "occupationId",
            "societyId",
            "jobIdx",
            "fieldPs",
            "themePs",
            "discCredibilities",
            "itemNums",
            "friendlinesses",
            "knightedSocietyId",
            "discourageMonths",
            "gutlessMonths",
            "preferredPage",
            "isManual",
            "firstTurn",
            "cpuLevel",
            "homePlaceId"
        ];

        return whiteList;
    },


    ctor: function (personObjFromDb, db) {
        this._super();

        this.id = personObjFromDb.id;

        this.firstName = personObjFromDb["firstName"];
        this.lastName = personObjFromDb["lastName"];
        this.birthYear = personObjFromDb["birthyear"];
        this.compose = personObjFromDb["compose"];
        this.comprehend = personObjFromDb["comprehend"];
        this.deathYear = personObjFromDb["deathyear"];

        this.idString = personObjFromDb["idstring"];
        this.name = personObjFromDb["name"];
        this.note = personObjFromDb["note"];

        this.fieldPs = new Array(pp.PR_FIELD_CNT);
        for (var i = 0; i < this.fieldPs.length; i++) {
            this.fieldPs[i] = new pp.PrFieldP();
            this.fieldPs[i].fieldId = i;
        }

        this.fieldPs[pp.FD_ASTRONOMY].aptitude = personObjFromDb["astronomy"];
        this.fieldPs[pp.FD_HEAT].aptitude = personObjFromDb["heat"];
        this.fieldPs[pp.FD_BIOLOGY].aptitude = personObjFromDb["biology"];
        this.fieldPs[pp.FD_MATHS].aptitude = personObjFromDb["mathematics"];
        this.fieldPs[pp.FD_MECHANICS].aptitude = personObjFromDb["mechanics"];
        this.fieldPs[pp.FD_OPTICS].aptitude = personObjFromDb["optics"];

        this.fieldPs[pp.FD_ENGINEERING].aptitude = personObjFromDb["dexterity"];
        this.fieldPs[pp.FD_DRAWING].aptitude = personObjFromDb["draw"];

        this.fieldPs[pp.FD_IMPORTANT].aptitude = personObjFromDb["mathematics"];

        this.jobIdx = pp.IDX_INVALID;

        this.isManual = false;
        this.firstTurn = true;

        this.score = 0;
        this.knightedSocietyId = pp.idInvalid;
        this.preferredPage = pp.PG_INVALID;

        this.cpuLevel = 1;
    },

    initDiary: function () {
        this.diary = this.fullName + "年表\n\n";
    },

    addDiary: function(message) {
        this.diary += pp.mediator.getDateString() + "\n" +
            message + "\n\n";
    },

    initDiscCredibilities: function () {
        var discs = pp.world.discoveries;

        for (var i = 0; i < this.themePs.length; i++) {
            var themeP = this.themePs[i];
            for (var j = 0; j < discs.length; j++) {
                var disc =  discs[j];
                if (themeP.themeId != disc.themeId) continue;

                if (themeP.deduce >= disc.deduce && themeP.data >= disc.data) {
                    switch (disc.type) {
                        case pp.ttFigure:
                            this.discCredibilities[disc.id] = pp.crPreMake;
                            break;
                        case pp.ttItem:
                            this.discCredibilities[disc.id] = pp.crPreMake;
                            break;
                        case pp.ttThing:
                        case pp.ttBook:
                            this.discCredibilities[disc.id] = disc.importance;
                            break;
                        case pp.ttTheory:
                            this.discCredibilities[disc.id] = tm.min(disc.credibility, 50);
                            break;
                    }
                }
            }
        }
    },

    //--- Helpers ---

    getScore: function () {
        var score = 0;

        var myReports = this.getReports();

        for (var i = 0; i < myReports.length; i++) {
            var report = myReports[i];

            if (report.societyId == pp.idInvalid) {
                continue;
            }

            score += 1;
        }

        return score;
    },

    getAge: function () {
        return pp.world.year - this.birthYear;
    },

    getFullName: function () {
        return (tmd.language == pp.LN_JAPANESE) ?
            this.firstName + "・" + this.lastName :
            this.name;
    },

    getImageFileName: function () {
        return "res/image/Face" + this.idString + ".png";
    },

    getItems: function (fieldId, toSort) {
        var result = [];

        for (var i = 0; i < pp.world.items.length; i++) {
            var item = pp.world.items[i];
            if (this.itemNums[i] > 0 && pp.isIdValid(fieldId) && item.fieldId == fieldId) {
                result.push(item);
            }
        }

        if (toSort) {
            result.sort(function (itemA, itemB) {
                return itemB.gain - itemA.gain;
            });
        }

        return result;
    },

    getDiscoveries: function () {
        return this.getDiscoveriesWithType(null);
    },

    getReports: function (themeId, released) {
        var result = [];

        if (pp.isIdValid(themeId) == false) {
            themeId = pp.idInvalid;
        }

        for (var i = 0; i < pp.world.reports.length; i++) {
            var report = pp.world.reports[i];
            var disc = pp.world.discoveries[report.discoveryId];

            if (!cc.isUndefined(released) && (report.societyId != pp.idInvalid) != released)
                continue;

            if (report.personId == this.id && (themeId == pp.idInvalid || disc.themeId == themeId)) {
                result.push(report);
            }
        }
        return result;
    },

    getReportForDisc: function (discId) {
        var reports = this.reports;
        for (var i = 0; i < reports.length; i++) {
            var report = reports[i];
            if (report.discoveryId == discId) {
                return report;
            }
        }
        return null;
    },

    getSocietyName: function () {
        if (this.societyId == pp.ID_INVALID) {
            return __("無所属");
        }
        else {
            return pp.world.societies[this.societyId].name;
        }
    },

    getKnighthoodName: function (defaultName) {
        if (this.knightedSocietyId == pp.ID_INVALID) {
            return defaultName || "－－－－";
        }
        else {
            return pp.world.societies[this.knightedSocietyId].knightName;
            //return "騎士"; //pp.world.societies[this.knightedSocietyId].knightName + "爵";
        }
    },

    isNpc: function () {
        return  this.id == pp.piJudgeA ||
                this.id == pp.piJudgeB ||
                this.id == pp.piJudgeC;

    },

    getJobName: function () {
        if (this.societyId == pp.ID_INVALID) {
            return __("無所属");
        }
        else {
            switch (this.jobIdx) {
                default:
                case pp.IDX_INVALID:
                    return __("会員");
                case 0:
                    return pp.world.societies[this.societyId].jobName0;
                case 1:
                    return pp.world.societies[this.societyId].jobName1;
                case 2:
                    return pp.world.societies[this.societyId].jobName2;
            }
        }
    },

    getDiscoveryCountWithThemePIdx: function(themePIdx) {
        var themep = this.themePs[themePIdx];

        return this.getDiscoveryCountWithThemeId(themep.themeId);
    },

    getDiscoveryCountWithThemeId: function(themeId) {
        var count = 0;

        for (var i = 0; i < pp.world.discoveries.length; i++) {
            var disc = pp.world.discoveries[i];
            if (disc.themeId != themeId) {
                continue;
            }
            if (this.discCredibilities[disc.id] == pp.crPreNotice) {
                continue;
            }
            count++;
        }
        return count;
    },

    getDiscoveriesWithType: function(discType, themeId) {

        discType = cc.isNumber(discType) ? discType : null;
        themeId = cc.isUndefined(themeId) ? pp.idInvalid : themeId;

        var result = [];
        for (var i = 0; i < this.discCredibilities.length; i++) {
            if (this.discCredibilities[i] == pp.crPreNotice) continue;
            var disc = pp.world.discoveries[i];
            if (discType != null && disc.type != discType) continue;
            if (themeId != pp.idInvalid && disc.themeId != themeId) continue;
            result.push(pp.world.discoveries[i]);
        }
        return result;
    },

    getReportIdFromDiscId: function(discId) {
        var myReports = this.reports;

        for (var i = 0; i < myReports.length; i++) {
            var report = myReports[i];
            if (report.discoveryId == discId) {
                return report.id;
            }
        }
        return pp.ID_INVALID;
    },

    getDiscCredibilityStr: function (discId) {

        var ret;
        var disc = pp.world.discoveries[discId];

        if (this.discCredibilities[discId] < 0) {
            ret = "**";
        }
        else {

            switch (disc.type) {

                case pp.ttTheory:
                    ret = "" + this.discCredibilities[discId] + " / " + disc.credibility;
                    break;

                case pp.ttFigure:
                    ret = "" + this.discCredibilities[discId];
                    break;

                case pp.ttThing:
                case pp.ttBook:
                case pp.ttItem:
                    ret = "**";
                    break;
            }
        }
        return ret;
    },

    getDiscCredibilityStrForList: function (discId) {

        var ret;
        var disc = pp.world.discoveries[discId];

        if (this.discCredibilities[discId] <= 0) {

            switch (disc.type) {

                case pp.ttFigure:
                case pp.ttItem:
                    ret = __("未作成", "Not Yet");
                    break;

                case pp.ttTheory:
                case pp.ttThing:
                case pp.ttBook:
                    ret = "**";
                    break;
            }
        }
        else {
            switch (disc.type) {

                case pp.ttTheory:
                case pp.ttFigure:
                    ret = "" + this.discCredibilities[discId];
                    break;

                case pp.ttItem:
                    ret = __("完成", "Done");
                    break;

                case pp.ttThing:
                case pp.ttBook:
                    ret = "**";
                    break;
            }
        }
        return ret;
    },

    getObservatoryId: function () {
        for (var i = 0; i < pp.world.observatories.length; i++) {
            var obs = pp.world.observatories[i];
            if (obs.placeId == this.placeId) return i;
        }
        return pp.idInvalid;
    },

    getUniversityId: function () {
        for (var i = 0; i < pp.world.universities.length; i++) {
            var univ = pp.world.universities[i];
            if (univ.placeId == this.placeId) return i;
        }
        return pp.idInvalid;
    },

    getStatusString: function () {
        return this.getStatusStringAndColor()[0];
    },

    getStatusStringAndColor: function (normalStr) {

        var normalStr = cc.isUndefined(normalStr) ? __("正常") : normalStr;

        if (this.discourageMonths > 0)
            return [__("落胆"), cc.color(220, 0, 0), cc.color.WHITE];

        if (this.gutlessMonths > 0)
            return [__("無気力"), cc.color(220, 0, 0), cc.color.WHITE];

        return [normalStr, cc.color(0, 0, 0), null];
    },

    isGutless: function () {
        return this.gutlessMonths > 0;
    },

    isDiscouraged: function () {
        return this.discourageMonths > 0;
    },

    //--- Functions for CPU

    getPreferredThemes: function () {

        if (this.preferredThemes) return this.preferredThemes;

        var preferredThemes = [];
        for (var i = 0; i < pp.world.themes.length; i++) {
            var theme = pp.world.themes[i];
            if (theme.fieldId == pp.fdImportant) continue;
            preferredThemes.push(theme);
        }

        var person = this;

        preferredThemes.sort(function (themeA, themeB) {
            var weight = function (theme) {
                var w;
                var fieldp = person.fieldPs[theme.fieldId];

                w = fieldp.aptitude * 2.0 - theme.knowledge * 1.0;

                return w;
            };

            return weight(themeB) - weight(themeA);
        });

        return this.preferredThemes = preferredThemes;
    },

    getPreferredSociety: function () {

        if (this.societyId != pp.idInvalid)
            return pp.world.societies[this.societyId];

        if (this.placeId == pp.plLondon || this.placeId == pp.plCambridge || this.placeId == pp.plAmsterdam) {
            return pp.world.societies[pp.soLondon];
        }

        return pp.world.societies[pp.soParis];
    },

    getPersonWithLeastAmity: function () {

        var pid = pp.idInvalid;
        var leastAmity = 100;
        var persons = pp.world.persons;

        for (var i = 0; i < persons.length; i++) {
            var withPerson = persons[i];
            if (withPerson.state != pp.pcActive) continue;
            if (leastAmity > this.friendlinesses[i]) {
                if (i == this.id) continue;
                leastAmity = this.friendlinesses[i];
                pid = i;
            }
        }
        return persons[pid];
    },

    isFinalThemeUnlocked: function () {

        var counts = new Array(6);
        var total = 0;
        for (var i = 0; i < 6; i++) {
            var field = pp.world.fields[i];
            counts[i] = field.getAuthorityCount(this.id);
            total += counts[i];
        }

        //条件１：合計８つ以上の権威である
        if (total >= 8)
            return true;

        //条件２：
        // 　天文学、力学、数学で最低１つのテーマの権威であり、
        //   合計５つ以上の権威である
        if (counts[pp.fdAstronomy] > 0 && counts[pp.fdMechanics] > 0 && counts[pp.fdMathematics] > 0 && total >= 5)
            return true;

        return false;
    }

});

pp.PrPerson.prototype.tableName = function () {
    return "persons";
};

pp.PrPerson.prototype.loadSenario = function (objs, db) {

    var personsFromDbS1 = db["personsS1"];

    for (var j = 0; j < objs.length; j++) {

        var person = objs[j];
        var personObjFromDbS1 = personsFromDbS1[person.id];

        person.fame = personObjFromDbS1["fame"];
        person.money = personObjFromDbS1["money"];
        person.placeId = personObjFromDbS1["place"];

        person.homePlaceId = person.placeId;

        person.state = personObjFromDbS1["state"];
        person.occupationId = personObjFromDbS1["occupation"];
        person.societyId = personObjFromDbS1["society"];
        person.societyId = person.societyId != undefined ? person.societyId : pp.ID_INVALID;

        person.fieldPs[pp.FD_ASTRONOMY].knowledge = personObjFromDbS1["astronomyknowledge"];
        person.fieldPs[pp.FD_HEAT].knowledge = personObjFromDbS1["heatknowledge"];
        person.fieldPs[pp.FD_BIOLOGY].knowledge = personObjFromDbS1["biologyknowledge"];
        person.fieldPs[pp.FD_MATHS].knowledge = personObjFromDbS1["mathematicsknowledge"];
        person.fieldPs[pp.FD_MECHANICS].knowledge = personObjFromDbS1["mechanicsknowledge"];
        person.fieldPs[pp.FD_OPTICS].knowledge = personObjFromDbS1["opticsknowledge"];

        person.fieldPs[pp.FD_ASTRONOMY].experience = personObjFromDbS1["astronomyexperience"];
        person.fieldPs[pp.FD_HEAT].experience = personObjFromDbS1["heatexperience"];
        person.fieldPs[pp.FD_BIOLOGY].experience = personObjFromDbS1["biologyexperience"];
        person.fieldPs[pp.FD_MATHS].experience = personObjFromDbS1["mathematicsexperience"];
        person.fieldPs[pp.FD_MECHANICS].experience = personObjFromDbS1["mechanicsexperience"];
        person.fieldPs[pp.FD_OPTICS].experience = personObjFromDbS1["opticsexperience"];

        person.fieldPs[pp.FD_ENGINEERING].experience = personObjFromDbS1["engineering"];
        person.fieldPs[pp.FD_DRAWING].experience = personObjFromDbS1["drawExperience"];


        person.themePs = new Array(pp.prThemeNumAPerson);
        for (var i = 0; i < person.themePs.length; i++) {
            var themeP = person.themePs[i] = new pp.PrThemeP();

            var themeIdFromDbS1 = personObjFromDbS1["theme" + (i + 1)];
            if (themeIdFromDbS1 || themeIdFromDbS1 == 0) {
                themeP.themeId = themeIdFromDbS1;
                themeP.deduce = personObjFromDbS1["deduce" + (i + 1)];
                themeP.data = personObjFromDbS1["data" + (i + 1)];
            }
        }

        person.itemNums = new Array(db.items.length);
        for (var i = 0; i < person.itemNums.length; i++) {
            person.itemNums[i] = 0;
        }

        person.friendlinesses = new Array(db.persons.length);
        for (var i = 0; i < person.friendlinesses.length; i++) {
            person.friendlinesses[i] = 50;
        }

        person.discCredibilities = new Array(db.discoveries.length);
        for (var i = 0; i < person.discCredibilities.length; i++) {
            person.discCredibilities[i] = pp.crPreNotice;
        }

        person.diary = "";

        person.initDiscCredibilities();
    }
};

//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrPerson.prototype;
cc.defineGetterSetter(_p, "reports", _p.getReports);
cc.defineGetterSetter(_p, "age", _p.getAge);
cc.defineGetterSetter(_p, "fullName", _p.getFullName);
cc.defineGetterSetter(_p, "imageFileName", _p.getImageFileName);
cc.defineGetterSetter(_p, "items", _p.getItems);
cc.defineGetterSetter(_p, "discoveries", _p.getDiscoveries);
cc.defineGetterSetter(_p, "societyName", _p.getSocietyName);
cc.defineGetterSetter(_p, "jobName", _p.getJobName);
