
pp.PrTheme = pp.PrObject.extend({

    id: pp.ID_INVALID,
    name: "",
    fieldId: pp.ID_INVALID,
    discoveryCount: 0,
    knowledge: 0,
    voiceT1: "",
    voiceT2: "",
    voiceT3: "",
    voiceE1: "",
    voiceE2: "",
    voiceE3: "",
    description: "",

    discoveryId: 0,

    ctor: function (objInDb) {

        this._super();

        this.id = objInDb.id;
        this.fieldId = objInDb.field;
        this.name = objInDb.name;
        this.knowledge = objInDb["knowledge"];
        this.voiceT1 = objInDb.voiceT1;
        this.voiceT2 = objInDb.voiceT2;
        this.voiceT3 = objInDb.voiceT3;
        this.voiceE1 = objInDb.voiceE1;
        this.voiceE2 = objInDb.voiceE2;
        this.voiceE3 = objInDb.voiceE3;
        this.discoveryCount = 0; // count later
        this.description = objInDb["description"] || "";

        this.discoveryId = pp.ID_INVALID;
        var val = objInDb["discovery"];
        if (!cc.isUndefined(val)) {
            this.discoveryId = val;
        }
    },

    getDiscoveries: function () {

        if (this.discoveries) return this.discoveries;

        var discs = [];
        for (var i = 0; i < pp.world.discoveries.length; i++) {
            var disc = pp.world.discoveries[i];
            if (disc.themeId == this.id) {
                discs.push(disc);
            }
        }

        discs.sort(
            function (discA, discB) {
                return (discA.data + discA.deduce) - (discB.data + discB.deduce);
            }
        );

        //cc.log("$$$ discoveries calculated for theme [" + this.name + "]");

        return this.discoveries = discs;
    },

    getMaxData: function () {

        if (this.maxData) return this.maxData;

        var maxData = 0;
        var discs = this.getDiscoveries();

        for (var i = 0; i < discs.length; i++) {
            var disc = discs[i];

            if (maxData < disc.data) {
                maxData = disc.data;
            }
        }

        //cc.log("### maxData calculated for theme [" + this.name + "], value=[" + maxData + "]");

        return this.maxData = maxData;
    },

    getMaxDeduce: function () {

        if (this.maxDeduce) return this.maxDeduce;

        var maxDeduce = 0;
        var discs = this.getDiscoveries();

        for (var i = 0; i < discs.length; i++) {
            var disc = discs[i];

            if (maxDeduce < disc.deduce) {
                maxDeduce = disc.deduce;
            }
        }

        //cc.log("=== maxDeduce calculated for theme [" + this.name + "], value=[" + maxDeduce + "]");

        return this.maxDeduce = maxDeduce;
    },

    getReleasedReports: function () {

        var reports = [];

        for (var i = 0; i < pp.world.reports.length; i++) {
            var report = pp.world.reports[i];

            if (report.getThemeId() == this.id && report.societyId != pp.idInvalid)
                reports.push(report);
        }

        return reports;
    },

    getAuthorityPerson: function (toReload) {

        if (this.person && !toReload) return this.person;

        var reports = this.getReleasedReports();
        var personScores = [];
        for (var i = 0; i < pp.world.persons.length; i++) {
            personScores.push(0);
        }

        for (var i = 0; i < reports.length; i++) {
            var report = reports[i];
            personScores[report.personId] += report.backing;
        }

        var maxScore = 0;
        var maxScorePId = pp.idInvalid;
        for (var i = 0; i < personScores.length; i++) {
            if (maxScore < personScores[i]) {
                maxScorePId = i;
                maxScore = personScores[i];
            }
        }

        //cc.log("Theme:" + this.name + ", maxScore=" + maxScore + ", pId=" + maxScorePId);

        return this.person = maxScorePId == pp.idInvalid ? null : pp.world.persons[maxScorePId];
    },

    getCompleteRatio: function (personId) {

        var discs = this.getDiscoveries();
        var reports = this.getReleasedReports();

        var discNum = discs.length;
        var reportNum = reports.length;

        if (pp.isIdValid(personId)) {
            var hisReportNum = 0;
            for (var i = 0; i < reports.length; i++) {
                var report = reports[i];
                if (report.personId == personId) {
                    hisReportNum++;
                }
            }

            return [ reportNum/discNum, hisReportNum/discNum ];
        }
        else
        {
            return reportNum / discNum;
        }
    },

    getWorkingPersons: function () {
        var persons = [];

        for (var i = 0; i < pp.world.persons.length; i++) {
            var person = pp.world.persons[i];
            if (person.state != pp.pcActive) continue;
            for (var j = 0; j < person.themePs.length; j++) {
                var themeP = person.themePs[j];
                if (themeP.themeId == this.id)
                    persons.push(person);
            }
        }
        return persons;
    },

    isUnlocked: function (personId) {
        var person = pp.world.persons[personId];
        var fieldId = this.fieldId;
        var fieldp = person.fieldPs[fieldId];

        return fieldp.knowledge >= this.knowledge;
    },

    getCommentator: function () {

        var currentPerson = pp.mediator.person;

        var persons = this.getWorkingPersons();
        for (var i = 0; i < persons.length; i++) {
            var person = persons[i];
            if (person.id != currentPerson.id) return person;
        }

        var fieldId = this.fieldId;
        var persons = pp.world.getActivePersons();
        persons.sort(function (personA, personB) {
            var weight = function (person) {
                return person.fieldPs[fieldId].aptitude;
            };
            return weight(personB) - weight(personA);
        });

        for (var i = 0; i < persons.length; i++) {
            var person = persons[i];
            if (person.id != currentPerson.id) return person;
        }

        return pp.world.persons[pp.piJudgeA];
    }

});

pp.PrTheme.prototype.tableName = function () {
    return "themes";
};
