
stoPersonTurn = function () {

    var person = pp.mediator.person;

    sto.callStoryFunc(this.stoCheckPersonState);

    pp.mediator.uiBlinkPerson(pp.mediator.personId);
    pp.mediator.uiUpdate();

    pp.mediator.logTemp("(" + person.name + ") " + __(str.s744)); //"行動中...");

Switch:
    if (person.isManual) {
        goto("ManualCommand");
    }
    if (pp.mediator.toShowMenuInDemo &&
        (pp.world.interestedPersonId == pp.idInvalid || pp.world.interestedPersonId == person.id)) {
        goto("MenuInDemo");
    }
    goto("CpuCommand");

ManualCommand:
    sto.callStoryFunc(this.stoManualCommand);

    if (pp.mediator.gameState == pp.gsLoaded) {
        pp.mediator.gameState = pp.gsTurn;
        pp.mediator.logStartMonth(); //@@@
    }
    goto("Exit");

MenuInDemo:
    sto.callStoryFunc(this.stoComSystemOnDemo);
    pp.mediator.toShowMenuInDemo = false;
    pp.mediator.uiSetEnabledPager(true);
    if (pp.mediator.gameState == pp.gsTitle)
        goto("Exit");
    goto("Switch");

CpuCommand:
    sto.callStoryFunc(this.stoCpuCommand);

Next:
Exit:
    pp.mediator.uiUpdatePlace(person.placeId);

    return;
};


stoCheckPersonState = function () {

    var person = pp.mediator.person;

    if (person.gutlessMonths != 1) goto("NotOneG");

    sto.wuiShowMessage(
        __(str.s927, person.fullName, __("無気力")));
        //person.fullName + "は 無気力 から回復しました。");
    pp.mediator.log("   >>" +
        __(str.s927, person.name, __("無気力")));
        //person.name + "は 無気力 から回復しました。");

NotOneG:
    if (person.discourageMonths != 1) goto("NotOneD");

    sto.wuiShowMessage(
        __(str.s927, person.fullName, __("落胆")));
    //person.fullName + "は落胆から回復しました。");
    pp.mediator.log("   >>" +
        __(str.s927, person.name, __("落胆")));
    //person.name + "は落胆から回復しました。");

NotOneD:
    if (person.gutlessMonths == 0) goto("ZeroG");

    person.gutlessMonths = tm.max(0, person.gutlessMonths-1);
    cc.log(person.idString + ": gutlessMonths = " + person.gutlessMonths);

ZeroG:
    if (person.discourageMonths == 0) goto("ZeroD");

    person.discourageMonths = tm.max(0, person.discourageMonths-1);
    cc.log(person.idString + ": discourageMonths = " + person.discourageMonths);

ZeroD:
    return;
};


stoBeforeExeCommand = function () {

    if ((
        (pp.mediator.person && pp.mediator.person.isManual) ||
        (pp.mediator.person && pp.mediator.person.id == pp.world.interestedPersonId) ||
        (pp.mediator.isDemo && pp.world.interestedPersonId == pp.idInvalid && pp.mediator.isFirstPersonOfMonth)
        ) == false)
    {
        return;
    }

    sto.callStoryFunc(this.stoAutoSave);
};

