
stoComCommunicate = function (preSelectedPersonId) {

    var doPerson = pp.mediator.person;
    var withPerson;
    var done = false;
    var withPersonId;

    if (pp.isIdValid(preSelectedPersonId)) {
        withPersonId = preSelectedPersonId;
        goto("DidSelectPerson");
    }

SelPerson:
    if (pp.isIdValid(preSelectedPersonId)) {
        goto("Exit");
    }

    //'選択ﾌｫｰﾑ表示
    withPersonId = sto.wuiSelectPerson(
        __(str.s75)
        //"誰と交流しますか？"
    );
    if (withPersonId == pp.selCancel)
        goto("Exit");

DidSelectPerson:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComCommunicate, withPersonId);
    goto("Exit");

NotCheckingText:
    withPerson = pp.world.persons[withPersonId];

    if (doPerson.id == withPerson.id)
    {
        stol.wuiShowMessage("SelPerson",
            __(str.s76)
           // "自分自身です。"
        );
    }

    if (doPerson.placeId != withPerson.placeId)
    {
        stol.wuiShowMessage("SelPerson",
            __(str.s77)
           // "所在地が異なるので交流できません。"
        );
    }

    var ret = sto.wuiSelectOkCancel(
        __(str.s78, withPerson.fullName)
        //withPerson.fullName + "と交流します。よろしいですか？"
    );

    if (ret == pp.selCancel)
        goto("SelPerson");

    //'交流実行
    sto.callStoryFunc(this.stoExeCommunicate, withPersonId);
    done = true;

Exit:
    return done;
};



stoExeCommunicate = function (withPersonId, forcedFriendliness, forcedFameDiff) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedFriendliness);

    var doPerson = pp.mediator.person;
    var withPerson = pp.world.persons[withPersonId];

    var personA = doPerson;
    var personB = withPerson;

    // 会話前設定

    var personACalledAs =
        __(str.s79, personA.lastName);
        //personA.lastName + "さん";
    var personBCalledAs =
        __(str.s79, personB.lastName);
        //personB.lastName + "さん";

    var strThanksA =
        __(str.s81);
        //"ありがとうございます。";
    var strThanksB =
        __(str.s81);
       // "ありがとうございます。";

    var interestedTheme = personB.getPreferredThemes()[0];
    var interestedField = pp.world.fields[interestedTheme.fieldId].name;

    var friendliness = personA.friendlinesses[personB.id];
    var fameDiff = personB.fame - personA.fame;

    if (isCheckingText) {
        friendliness = forcedFriendliness;
        fameDiff = forcedFameDiff;
    }

    if (friendliness >= pp.commuMinFriendliness && fameDiff < pp.commuMinFameDiff) {
        if (personA.age > personB.age) {
            personBCalledAs = personB.firstName;
            if (personA.id == pp.piBarrow && personB.id == pp.piNewton) {
                personACalledAs =
                    __(str.s83, personA.lastName);
                    //personA.lastName + "先生";
                strThanksA =
                    __(str.s84);
                    //"どうもありがとう。";
            }
        }
        else {
            personACalledAs = personA.firstName;
            if (personB.id == pp.piBarrow && personA.id == pp.piNewton) {
                personBCalledAs =
                    __(str.s83, personB.lastName);
                    //personB.lastName + "先生";
                strThanksB =
                    __(str.s84);
                    //"どうもありがとう。";
            }
        }
    }

    for (var i = 0; i < personB.themePs.length; i++) {
        var themeP = personB.themePs[i];

        if (themeP.themeId != pp.ID_INVALID) {
            interestedTheme = pp.world.themes[themeP.themeId];
            interestedField = pp.world.fields[interestedTheme.fieldId].name;
            break;
        }
    }


    var voices;
    var persons = [personA.id, personB.id];
    var mess =
        __(str.s87, personA.fullName, personB.fullName);
        //personA.fullName + "が" + personB.fullName + "と交流しました。";
    var up = 0;

    pp.mediator.setBgm(res.Mus_Congrats2);

    if (friendliness >= pp.commuMinFriendliness) {
        if (fameDiff <= 0) {
            //=== 友好度GOOD, 名声GOOD
            voices = [
                __(str.s88, personBCalledAs),
                "@" + __(str.s89, personACalledAs) + CR + __(str.s90, interestedTheme.name),
                __(str.s91, personBCalledAs),
                "@" + __(str.s92, interestedField)
            ];

            /*
                personBCalledAs + "、こんにちは。研究は進んでいますか？",
                "@これは" + personACalledAs + "！ようこそおいで下さいました！\n" +
                interestedTheme.name + "について新しい事実を見つけつつあります。近いうちに論文を発表できると思いますよ。",
                "なんと！さすがは" + personBCalledAs + "ですね。それは大いに期待ができそうだ。",
                "@しかし" + interestedField + "は本当に奥が深いです。\nわかればわかるほど新たな疑問がわいてきます。"
                */

            up = 5;
        }
        else if (fameDiff < pp.commuMinFameDiff) {
            //=== 友好度GOOD, 名声OK
            voices = [
                __(str.s93, personBCalledAs),
                "@" + __(str.s94, personACalledAs) + CR + __(str.s95, interestedTheme.name, interestedField),
                __(str.s96) + __(str.s97, personBCalledAs) ,
                "@" + strThanksB
            ];

            /*
                personBCalledAs + "、こんにちは。最近はいかがですか。",
                "@やあ" + personACalledAs + "、元気そうだね。\n" +
                "最近は" + interestedTheme.name + "に興味を持っています。近代" + interestedField + "としては格好の研究対象ですよ。",
                "それは面白そうですね。\n" +
                personBCalledAs + "ならまたすばらしい発見をなさるに違いない。",
                "@" + strThanksB
            ];
            */

            up = 5;
        }
        else {
            //=== 友好度GOOD, 名声NG
            voices = [
                __(str.s98, personBCalledAs),
                "@" + __(str.s99, personACalledAs),
                __(str.s100, personBCalledAs) + __(str.s101, personBCalledAs),
                "@" + __(str.s924)
            ];

            /*
                personBCalledAs + "、本日はお目にかかれて光栄でございます。",
                "@ええと、" + personACalledAs + "でしたかな。何かご用でも？",
                personBCalledAs + "の研究いつも拝見しております。" +
                "私も" + personBCalledAs + "のような業績をあげようと日々努力しているところです。",
                "@そうですか、それは楽しみですね。\nこれからも頑張って下さい。"
            ];
            */

            up = 5;
        }
    }
    else {
        if (fameDiff <= 0) {
            //=== 友好度NG, 名声GOOD
            voices = [
                __(str.s102, personBCalledAs),
                "@" + __(str.s103, personACalledAs),
                __(str.s104),
                "@" + __("そうですか・・・。", "Is that so...")
            ];
            /*
                personBCalledAs + "はおいでですかね。",
                "@・・・これは" + personACalledAs + "。何かご用でも？",
                "とくに用事はないのですが、近くまで来たものですから。\nお忙しいようなのこれで失礼します。",
                "@そうですか・・・。"
            ];
            */

            up = 5;
        }
        else if (fameDiff < pp.commuMinFameDiff) {
            //=== 友好度NG, 名声OK
            voices = [
                __(str.s105, personBCalledAs),
                "@" + __(str.s929)
                /*
                personBCalledAs + "ですか？",
                "@・・・申し訳ないが急いでいるので失礼。"
                */
            ];

            mess =
                __(str.s106, personA.fullName, personB.fullName);
                //personA.fullName + "は" + personB.fullName + "と交流できませんでした。";
        }
        else {
            //=== 友好度NG, 名声NG
            persons = personA.id;
            voices =
                __(str.s107, personBCalledAs);
                // "・・・" + personBCalledAs + "は留守のようだな。";
            mess =
                __(str.s108, personA.fullName, personB.fullName);
                //personA.fullName + "は" + personB.fullName + "に会えませんでした。";
        }
    }

    // 会話
    sto.wuiShowVoice(
        persons,
        null,
        voices,
        __("交流"),
        false);

    //'ﾒｯｾｰｼﾞ表示
    //sto.wuiShowMessage(mess);

    up = tm.imin(up, pp.friendlinessMax - friendliness);

    sto.wuiShowParamChange(
        __(personB.fullName + "との友好度", "Amity with " + personB.fullName,"跟" + personB.fullName + "的友好度"),
        friendliness, friendliness+up);
    personA.friendlinesses[personB.id] = friendliness + up;
    personB.friendlinesses[personA.id] = friendliness + up;

    // Log
    pp.mediator.logPersonCommand(doPerson.id,
        __(str.s111, withPerson.name));
        //withPerson.name + "と交流しています。");
};
