
stoComDonate = function (preSelectedPersonId) {

    var done = false;

    var person = pp.mediator.person;
    var toPersonId;

    //'資金ﾁｪｯｸ
    if (person.money < pp.monDonate)
    {
        stol.wuiShowMessage("Exit",
            __(str.s122, pp.monDonate));

            //"資金不足です。\n必要資金: " + pp.monDonate);
    }

    if (pp.isIdValid(preSelectedPersonId)) {
        toPersonId = preSelectedPersonId;
        goto("DidSelectPerson");
    }

SelPerson:
    if (pp.isIdValid(preSelectedPersonId)) {
        goto("Exit");
    }

    //'*** 寄付
    toPersonId = sto.wuiSelectPerson();
    if (toPersonId == pp.selCancel)
        goto("Exit");

DidSelectPerson:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComDonate, toPersonId);
    goto("Exit");

NotCheckingText:
    if (toPersonId == person.id)
    {
        stol.wuiShowMessage("SelPerson",
            __(str.s123)
            //"自分に資金援助は行えません。"
        );
    }

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s125, pp.monDonate, pp.world.persons[toPersonId].fullName, pp.monDonate));

        //    "資金 " + pp.monDonate + " を" + pp.world.persons[toPersonId].fullName +
        //    "に寄付します。\nよろしいですか？\n必要資金: " + pp.monDonate);

    if (ret == pp.selCancel) {
        goto("SelPerson");
    }

    //'実行
    sto.callStoryFunc(this.stoExeDonate, toPersonId);

    done = true;

Exit:
    return done;

};



stoExeDonate = function (toPersonId, forcedFriendliness, forcedAccepted)
{
    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedFriendliness);

    var person = pp.mediator.person;
    var toPerson = pp.world.persons[toPersonId];
    var mes;

    //'手紙に相手がﾌﾟﾚｲﾔｰならﾒｯｾｰｼﾞ必表示
    if (toPerson.isManual)
        pp.mediator.toShowMessageTemporary = true;

    sto.wuiSetFocusOnPlace(person.placeId);

    var friendliness = person.friendlinesses[toPersonId];
    if (isCheckingText) friendliness = forcedFriendliness;

    //'*** ﾒｯｾｰｼﾞ
    if (friendliness >= 70)
    {
        mes =
            __(str.s126, toPerson.lastName);
            //toPerson.lastName + "氏の研究は素晴らしい。微力ながら力になりたいものだ。";
    }
    else if (friendliness >= 40)
    {
        mes =
            __(str.s127, toPerson.lastName);
            //toPerson.lastName + "氏との関係は大事にしていきたい。\n私の誠意が伝わればうれしいのだが。";
    }
    else
    {
        mes =
            __(str.s128, toPerson.lastName);
            //toPerson.lastName + "の奴は信用できない。・・・しかし敵に回すと厄介だ。";
    }

    sto.wuiShowVoice(person.id, res.Img_CutMath, mes,
        __(str.s129));
        //"資金援助");

    sto.wuiShowLetter(
        __(str.s130, toPerson.fullName),
        __(str.s131, pp.monDonate),
        pp.mediator.getDateStringWithDay(),
        //toPerson.fullName + "様",
        //"貴方の優れた研究には深く尊敬の念を抱いています。一層のご活躍を期待し資金" + pp.monDonate + "の援助を申し出る次第です。",
        //pp.world.year + "/" + pp.world.month + "/1",
        person.id);

    sto.wuiShowMessage(
        __(str.s132, person.fullName, toPerson.fullName)
        //person.fullName + "が" + toPerson.fullName + "に手紙を送りました。"
    );

    sto.wuiSetFocusOnPlace(toPerson.placeId);

    //'*** 返答
    if (friendliness >= 70)
    {
        mes =
            __(str.s133, person.lastName);
        //person.lastName + "氏からの手紙か・・・。彼の心遣いには感謝せざるを得ないな";
    }
    else if (friendliness >= 40)
    {
        mes =
            __(str.s134, person.lastName);
            //"資金援助の申し出か。" + person.lastName + "氏とはなかなか頼もしい人物だ。";
    }
    else
    {
        mes =
            __(str.s135, person.lastName);
            //person.lastName + "が何を考えてるのかは明白だな。まったく単純な思考の持ち主だ。";
    }
    sto.wuiShowVoice(toPerson.id, null, mes,
        __(str.s136));
        //"資金援助");

    //'*** 相手に確認
    var toAccept;
    if (toPerson.isManual == false)
        goto("NotManual");
Manual:
    var ret = sto.wuiSelectYesNo(__(str.s137, person.lastName));
        //person.lastName + "からの資金援助を受け入れますか？");
    toAccept = ret == 0;

    if (toAccept == false)
        goto("NotAccept");
    goto("Accept");

NotManual:
    toAccept = tm.irand(5) != 0;
    if (isCheckingText) toAccept = forcedAccepted;

    var up;
    var p0;
    var p1;

    if (toAccept == false)
        goto("NotAccept");

Accept:
    //'*** 受け入れ
    if (friendliness >= 40)
        mes = __(str.s138);
            //"ありがたくご好意を受け取ることにしよう。";
    else
        mes = __(str.s139);
            //"しかし受け取って置いて損は無いか・・・。";

    sto.wuiShowVoice(toPersonId, null, mes, __(str.s140)); //"資金援助 - 承諾");

    //'資金授受
    person.money -= pp.monDonate;
    toPerson.money = tm.imin(toPerson.money + pp.monDonate, pp.monMax);

    //'友好度上昇
    up = 10;
    p0 = person.friendlinesses[toPersonId];
    p1 = tm.imin(p0 + up, pp.friendlinessMax);
    up = p1 - p0;
    person.friendlinesses[toPersonId] = p1;
    toPerson.friendlinesses[person.id] = p1;

    goto("EndIf");

NotAccept:
    //'*** 拒否
    if (friendliness >= 40)
        mes = __(str.s141);
            //"しかしいわれの無い申し出を受けるのも上品とは言えない。丁重にお断りしよう。";
    else
        mes = __(str.s142);
            //"こんなものは受け取れない。彼からの資金援助を受けるほど貧窮してはいない。";

    sto.wuiShowVoice(toPersonId, null, mes, __(str.s143)); //"資金援助 - 拒否");

    //'友好度低下
    up = -5;
    p0 = person.friendlinesses[toPersonId];
    p1 = tm.imax(p0 + up, pp.friendlinessMin);
    up = p1 - p0;
    person.friendlinesses[toPersonId] = p1;
    toPerson.friendlinesses[person.id] = p1;

EndIf:

    sto.wuiShowParamChange(
        __(toPerson.fullName + "との友好度", "Amity with " + toPerson.fullName, "跟" + toPerson.fullName + "的友好度"),
        p0,
        p1);

    /*
        "友好度",
        p0, p1,
        person.fullName + "と" + toPerson.fullName
        */


    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s145, toPerson.name, toAccept ? __("成立") : __("不成立")));
        //toPerson.name + "へ資金提供を申し出ました。結果：" + (toAccept ? "成立" : "不成立"));

    pp.mediator.toShowMessageTemporary = false;

    pp.mediator.uiUpdate();
};
