
stoComJoinSociety = function (preSelectedSocietyId) {

    var done = false;

    var society;
    var societyId;

    var person = pp.mediator.person;

    if (person.societyId != pp.idInvalid)
    {
        society = pp.world.societies[person.societyId];
        stol.wuiShowMessage("Exit",
            __(str.s161, society.name));
            //"すでに" + society.name + "に入会ずみです。");
    }

    if (pp.isIdValid(preSelectedSocietyId)) {
        societyId = preSelectedSocietyId;
        goto("DidSelectSociety");
    }

SelSociety:
    if (pp.isIdValid(preSelectedSocietyId)) {
        goto("Exit");
    }

    societyId = sto.wuiSelectSociety();//"組織選択");
    if (societyId == pp.selCancel) {
        goto("Exit");
    }

DidSelectSociety:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComJoinSociety, societyId);
    goto("Exit");

NotCheckingText:
    society = pp.world.societies[societyId];

    // 所在地チェック
    if (person.placeId != society.placeId) {
        var place = pp.world.places[society.placeId];
        stol.wuiShowMessage("SelSociety",
            __(str.s163, society.name, place.name));
            //society.name + "の所在地である" + place.name + "にいる必要があります。");
    }

    var sel = sto.wuiSelectOkCancel(
        __(str.s164, society.name));
        //society.name + "に入会希望を提出します。\nよろしいですか？");
    if (sel == pp.selCancel)
        goto("SelSociety");

    sto.callStoryFunc(this.stoExeJoinSociety, societyId);
    done = true;

Exit:
    return done;
};

stoExeJoinSociety = function (societyId, forcedValues) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedValues);

    var society = pp.world.societies[societyId];
    var person = pp.mediator.person;

    //'希望される組織の役員がﾌﾟﾚｲﾔｰなら必ずﾒｯｾｰｼﾞ表示
    if (society.toShowMessageByJobPerson())
        pp.mediator.toShowMessageTemporary = true;

    var ret = sto.callStoryFunc(this.stoCanJoinSociety, societyId, forcedValues);
    if (ret == false)
        goto("Rejected");

Accepted:
    //'*** 入会許可
    //'入会
    person.societyId = societyId;
    person.jobIdx = pp.idxInvalid;

    //'ﾒｯｾｰｼﾞ表示
    if (person.isManual == false)
        goto("NotManual");

Manual:
    sto.wuiShowMessageEx(
        __(str.s165, person.fullName, society.name),
        //person.fullName + "が" + society.name + "に入会しました！",
        res.Img_CutSociety);

    goto("EndIf");

NotManual:
    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowMessage(
        __(str.s166, person.fullName, society.name));
        //person.fullName + "が" + society.name + "に入会しました。");

    pp.mediator.toShowMessageTemporary = false;

EndIf:
    //'名声上昇
    var up = society.authority;
    sto.wuiShowParamChange(__("名声"), person.fame, person.fame + up, person.fullName);
    person.fame += up;

    //'組織権威上昇
    up = tm.int(person.fame/10) - 10;
    sto.wuiShowParamChange(__("権威"), society.authority, society.authority + up, society.name);
    society.authority += up;

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(
            __(str.s169, society.name));
            //society.name + "に入会を希望し、入会。");
    }

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s170, society.name));
        //society.name + "に入会を希望しました。結果：入会許可");

    goto("Exit");

Rejected:
    //'*** 入会不許可
    //'ﾒｯｾｰｼﾞ表示
    sto.wuiShowMessage(
        __(str.s171, society.name));
        //society.name + "は入会を許可しませんでした。");

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(
            __(str.s172, society.name));
            //society.name + "への入会を希望するが、許可されず。");
    }

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s173, society.name));
        //society.name + "に入会を希望しました。結果：不許可");

Exit:
    pp.mediator.toShowMessageTemporary = false;

    return;
};

stoCanJoinSociety = function (societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var person = pp.mediator.person;
    var society = pp.world.societies[societyId];

    var accepted;
    var fame = person.fame;


    pp.mediator.setBgm(res.Mus_Society);

    //---------- SCENE SOCIETY ----------
    sto.wuiPushScene(pp.ScnSociety, societyId, cc.TransitionFlipX, 3);
    sto.wuiShowCutS(res.Img_CutSociety);


    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 2 : fr >= 50 ? 1 : 0;
    opA += fame >= 700 ? 3 : fame >= 200 ? 2 : fame >= 100 ? 1 : -2;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 2 : fr >= 50 ? 1 : 0;
    opB += fame >= 700 ? 3 : fame >= 200 ? 2 : fame >= 100 ? 1 : -2;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 2 : fr >= 50 ? 1 : 0;
    opC += fame >= 700 ? 3 : fame >= 200 ? 2 : fame >= 100 ? 1 : -2;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏
    mes =
        __(str.s174, person.fullName, society.name) +
        __(str.s175);

        //person.fullName + "氏が我らが" + society.name + "への入会を希望しているようです。" +
        //"彼の今までの業績などを考慮し、入会を認めるべきか否かを決定したいと思います。";

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s176, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'Ｂ氏
    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:
    switch (opB)
    {
        default:
        case 4:
            mes =
                __(str.s178, person.lastName);
                //"あの名高い" + person.lastName + "氏が入会を希望とは、光栄なことです。取り急ぎ入会の手続きを取らせましょう。";
            break;

        case 3:
            mes =
                __(str.s179, person.lastName, society.name);
            //person.lastName + "氏の業績は素晴らしい。是非我らが" + society.name +  "へ迎えようではありませんか。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                    __(str.s180, personA.lastName);
                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;

        case 2:
        case 1:
            mes =
                __(str.s181, person.lastName);
                //"うーん。" + person.lastName + "氏ですか・・・。噂を聞いた事はありますが、" +
                //"特に目立った業績をあげているとは思えませんね。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s183, society.jobName0);
                    //society.jobName0 + "の意見はどうですか？";
            }
            break;

        case 0:
            mes =
                __(str.s184, person.lastName, society.name);
                //person.lastName + "とはどんな人物なのですか？私はそんな男の名前を聞いた事がありません。" +
                //"この栄誉ある" + society.name + "には必要ありません。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                    __(str.s186, personA.lastName);
                    //personA.lastName + "さんの意見は？";
            }
            break;
    }

SettledB:
    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:
    switch (opA)
    {
        default:
        case 4:
            mes =
                __(str.s188, person.lastName, society.name);
                //"なんと！\n" + person.lastName + "氏が入会すれば、我らが" +
                //society.name + "の権威もますます高まると言うもの。是非この話を進めましょう。";
            break;

        case 3:
            mes =
                __(str.s190, person.lastName);
                //"賛成だ。" + person.lastName + "氏の活躍を考えれば異論などでようはずもない。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                    __(str.s191, personC.lastName);
                    //personC.lastName + "君はどう思うかね？";
            }
            break;

        case 2:
        case 1:
            mes =
                __(str.s192);
                //"あの方か。個人的にはそれほど優れた人物であるとの認識は持っていないのだが・・・。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                        __(str.s193, society.jobName2);
                    //society.jobName2 + "はどう思うかね？";
            }
            break;

        case 0:
            mes =
                __(str.s194, person.lastName) +
                __(str.s195, society.name) +
                __(str.s196);

                //"その" + person.lastName + "氏という方は、何か勘違いをされているのでは？" +
                //"この" + society.name + "は国王も認める権威ある組織。" +
                //"彼のような人物は全く相応しくありません。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        default:
        case 4:
            mes =
                __(str.s198, person.fullName);
                //"これは大変なことになりました・・・。あの高名な" +
                //person.fullName + "氏が直々に入会をご希望とは・・・。";
            break;

        case 3:
            mes =
                __(str.s200, society.name);
                //"異論などあるはずもありません。私などより" + society.name + "に相応しい人物でしょう。";
            break;

        case 2:
        case 1:
            mes =
                __(str.s201);
                //"あまり目立った働きはされていないのではないでしょうか？もうすこし業績があれば望ましいのですが。";
            break;

        case 0:
            mes =
                __(str.s202, society.name);
                //"この人物を入会させるなんてとんでもありません。" +
                //"彼のような人物が会員となれば" + society.name + "の威厳は地に落ちます。絶対に反対です。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    // 意見が割れてる？

    if (((opA > 2 && opB <= 2) || (opB > 2 && opA <=2) ||
         (opB > 2 && opC <= 2) || (opC > 2 && opB <=2) ||
         (opC > 2 && opA <= 2) || (opA > 2 && opC <=2)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0, __(str.s204));
        //"意見が分かれましたね。できれば全員一致で決定したかったところですが、仕方ないでしょう。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:

    //'3人のﾎﾟｲﾝﾄが8以上なら入会許可
    if (opA + opB + opC >= 8)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0, __(str.s205, person.lastName));
        //"・・・それでは" + person.lastName + "氏の入会を許可しよう。決定だ。");
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0, __(str.s206, person.lastName));
        //person.lastName + "氏の入会は不許可としよう。いいですね？");
    accepted = false;

Exit:
    //---------- POP SCENE ----------
    sto.wuiPopScene(cc.TransitionFlipX, 3);

    return accepted;
};
