
stoComMove = function (preSelectedPlaceId) {

    var person = pp.mediator.person;
    var toPlace;
    var done = false;
    var placeId;

    if (pp.isIdValid(preSelectedPlaceId)) {
        placeId = preSelectedPlaceId;
        goto("DidSelectPlace");
    }

SelPlace:
    if (pp.isIdValid(preSelectedPlaceId)) {
        goto("Exit");
    }

    //'選択ﾌｫｰﾑ表示
    placeId = sto.wuiSelectPlace();
    if (placeId == pp.selCancel)
        goto("Exit");

DidSelectPlace:

    toPlace = pp.world.places[placeId];

    if (person.placeId == placeId)
    {
        stol.wuiShowMessage("SelPlace", __(str.s273)); //"現在所在地です。");
    }

    var fromPlace = pp.world.places[person.placeId];

    //'移動ｺｽﾄ計算  (ｺｽﾄ) = (x座標差 + y座標差) * const
    var cost = fromPlace.getCostToPlace(toPlace.id);

    var ret = sto.wuiSelectOkCancel([
        __(str.s274, toPlace.name),
        __(str.s275, cost)
        //toPlace.name + "に移動します。よろしいですか？",
        //"必要資金: " + cost
    ]);
    if (ret == pp.selCancel)
        goto("SelPlace");

    if (person.money < cost) {
        stol.wuiShowMessage("SelPlace",
            __(str.s276)
            //"資金不足です。"
        );
    }

    var occupation = pp.world.occupations[person.occupationId];

    //'職業が所在地依存なら警告ﾒｯｾｰｼﾞを表示
    if (occupation.placeId == pp.idInvalid)
        goto("EndIf");

    ret = sto.wuiSelectOkCancel(
        __(str.s277, occupation.name));
        //"職業『" + occupation.name + "』を辞職することになります。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("SelPlace");

EndIf:

    //'移動実行
    sto.callStoryFunc(this.stoExeMove, placeId);
    done = true;

Exit:
    return done;
};



stoExeMove = function (toPlaceId) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var person = pp.mediator.person;
    var fromPlaceId = person.placeId;
    var toPlace = pp.world.places[toPlaceId];

    person.placeId = toPlaceId;

    var cost = toPlace.getCostToPlace(fromPlaceId);

    //'資金を減らす
    person.money -= cost;

    //'職業が場所依存であったら辞職
    if (pp.world.occupations[person.occupationId].placeId != pp.idInvalid)
    {
        person.occupationId = pp.ocDefault;
    }

    //'移動
    person.placeId = toPlaceId;

    pp.mediator.uiUpdate();
    pp.mediator.uiUpdatePlace(toPlaceId);
    pp.mediator.uiUpdatePlace(fromPlaceId);

    //'ﾒｯｾｰｼﾞ表示
    sto.wuiShowMessage(
        __(str.s278, person.fullName, toPlace.name));
       // person.fullName + "が" + toPlace.name + "に移動しました。");

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s279, toPlace.name));
        //toPlace.name + "に移動しました。");

    return;
};
