
stoComPagedSystem = function () {

    var done = false;
    var person = pp.mediator.person;

    // Change Scene
    if (pp.mediator.scn instanceof pp.ScnPaged) {
        goto("NoPush");
    }

    sto.wuiPushScene(pp.ScnPagedSystem, null, cc.TransitionFade, 1);
    goto("SelCommand");

NoPush:
    sto.wuiSetScene(pp.ScnPagedSystem, null, cc.TransitionFade, 1);

SelCommand:
    sto.callTutorialFunc(this.stoTutPages4);

    var ret = sto.wuiWaitUserInput();

    var arg0 = null;
    var arg1 = null;
    var comId;

    if (cc.isArray(ret)) {
        comId = ret[0];
        arg0 = ret[1];
        arg1 = ret[2];
    }
    else {
        comId = ret;
    }

    var ret = sto.callTutorialFunc(this.stoTutCheckSelection, comId);
    if (ret == false) {
        goto("SelCommand");
    }

    if (comId == pp.cmpMap) {
        person.preferredPage = pp.PG_MAP;
        goto("Exit");
    }
    if (comId == pp.cmpResearch) {
        person.preferredPage = pp.PG_RESEARCH;
        goto("DidPop");
    }
    if (comId == pp.cmpThemeMap) {
        person.preferredPage = pp.PG_THEME_MAP;
        goto("DidPop");
    }
    if (comId == pp.cmpSystem) {
        person.preferredPage = pp.PG_SYSTEM;
        goto("SelCommand");
    }


    if (comId == pp.cmsSave) {
        goto("Save");
    }
    if (comId == pp.cmsLoad) {
        goto("Load");
    }
    if (comId == pp.cmsMessageSpeed) {
        goto("Speed");
    }
    if (comId == pp.cmsCpuTurn) {
        goto("Turn");
    }
    if (comId == pp.cmsAutoMode) {
        goto("AutoMode");
    }
    if (comId == pp.cmsQuitGame) {
        goto("ExitGame");
    }
    if (comId == pp.cmsDebug) {
        goto("Test");
    }
    if (comId == pp.cmsLibrary) {
        goto("Library");
    }
    if (comId == pp.cmsCheckText) {
        goto("CheckText");
    }

    cc.assert(false, "Unknown command.");

Save:
    ret = sto.callStoryFunc(this.stoComSave);
    goto("SelCommand");

Load:
    ret = sto.callStoryFunc(this.stoComLoad);
    if (ret == false)
        goto("SelCommand");

    pp.world.commandedPersonNum -= 1;
    pp.mediator.gameState = pp.gsLoaded;

    pp.mediator.uiUpdateAllPlaces();

    done = true;
    goto("Exit");

Speed:
    sto.callStoryFunc(this.stoComSelectTmdOptions, "messageSpeed");

    pp.mediator.uiUpdate();

    goto("SelCommand");

Turn:
    sto.callStoryFunc(this.stoComSelectTmdOptions, "toShowCpuTurn", null, [1,0,1]);

    pp.mediator.uiUpdate();

    goto("SelCommand");

Test:
    sto.callStoryFunc(this.stoComDebug);
    goto("SelCommand");

AutoMode:
    ret = sto.callStoryFunc(this.stoComAutoMode);
    if (ret == false)
        goto("SelCommand");

    pp.world.commandedPersonNum -= 1;

    done = true;
    goto("Exit");

ExitGame:
    ret = sto.callStoryFunc(this.stoComExitGame);
    if (ret == false)
        goto("SelCommand");

    done = true;
    goto("Exit");

Library:
    sto.callStoryFunc(this.stoComLibrary);
    goto("SelCommand");

CheckText:
    sto.callStoryFunc(this.stoComCheckText);
    goto("SelCommand");

Exit:
    // Restore Scene
    sto.wuiPopScene(cc.TransitionFade, 1);

DidPop:
    return done;
};
