
stoComSecedeSociety = function () {

    var done = false;

    var society;
    var person = pp.mediator.person;

    if (person.societyId == pp.idInvalid)
    {
        stol.wuiShowMessage("Exit",
            __(str.s362));
            //"組織に所属していないので退会できません。");
    }

    society = pp.world.societies[person.societyId];

    var sel = sto.wuiSelectOkCancel(
        __(str.s363, society.name));
        //society.name + "に退会希望を提出します。\nよろしいですか？");

    if (sel == pp.selCancel) {
        goto("Exit");
    }

    sto.callStoryFunc(this.stoExeSecedeSociety);
    done = true;

Exit:
    return done;
};

stoExeSecedeSociety = function () {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var person = pp.mediator.person;
    if (person.societyId == pp.idInvalid)
        return;

    var society = pp.world.societies[person.societyId];

    //'退会、各低下値取得
    var sUp = 0;
    var pUp = 0;

    var ret = this.secedeSociety(person.id);
    pUp = ret[0];
    sUp = ret[1];

    //'*** ﾒｯｾｰｼﾞ表示
    sto.wuiShowMessage(
        __(str.s364, person.fullName, society.name));
        //person.fullName + "が" + society.name + "を退会しました。");

    //'組織権威低下
    sto.wuiShowParamChange(__("権威"), society.authority, society.authority + sUp, society.name);
    society.authority += sUp;

    //'名声低下
    pUp = tm.int(pUp * 1.2);     //'自主的にやめたので低下値上積み
    sto.wuiShowParamChange(__("名声"), person.fame, person.fame + pUp, person.fullName);
    person.fame += pUp;

    pp.mediator.uiUpdate();

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(
            __(str.s367, society.name));
            //"自主的に" + society.name + "を退会。");
    }

    return;
};

pp.PrStory.prototype.secedeSociety = function (personId) {

    var person = pp.world.persons[personId];
    var society = pp.world.societies[person.societyId];

    var pPersonFameDiff = 0;
    var pSocietyAuthDiff = 0;

    if (person.jobIdx != pp.idxInvalid)
    {
        //'*** 役職に就いている
        //'名声低下値加算(役職辞任に伴い)
        pPersonFameDiff += tm.int(society.authority / 3 * (2-person.jobIdx)); //@@@

        //'辞任
        if (person.jobIdx == 0)
            society.job0PersonId = pp.idInvalid;
        else if (person.jobIdx == 1)
            society.job1PersonId = pp.idInvalid;
        else if (person.jobIdx == 2)
            society.job2PersonId = pp.idInvalid;

        person.jobIdx = pp.idxInvalid;
    }

    //'名声値低下値追加(組織脱退に伴い)
    pPersonFameDiff -= society.authority;

    //'脱会
    person.societyId = pp.idInvalid;

    //'組織権威低下(上昇)値
    pSocietyAuthDiff = tm.int(-person.fame / 10 + 8);

    return [pPersonFameDiff, pSocietyAuthDiff];
};
