
stoComStudy = function () {

    var person = pp.mediator.person;
    var item;
    var done = false;
    var itemId;

    var options = [
        __("講義受講"),
        __("読書"),
        __("訓練")
    ];

SelSubCommand:

    var ret;
    var userSel = sto.wuiSelectOptionsWithCancel(options, __("学習"));

    if (userSel == pp.selCancel) {
        return false;
    }
    else if (userSel == 0) {
        goto("Lecture");
    }
    else if (userSel == 1) {
        goto("ReadBook");
    }
    else if (userSel == 2) {
        goto("Train");
    }

Lecture:
    if (person.getUniversityId() == pp.idInvalid) {
        stol.wuiShowMessage("SelSubCommand", __(str.s686)); //"大学所在地にいません。");
    }

    done = sto.callStoryFunc(this.stoComLecture);
    if (done)
        goto("Exit");
    goto("SelSubCommand");

ReadBook:
    done = sto.callStoryFunc(this.stoComReadBook);
    if (done)
        goto("Exit");
    goto("SelSubCommand");

Train:
    done = sto.callStoryFunc(this.stoComTrain);
    if (done)
        goto("Exit");
    goto("SelSubCommand");


Exit:
    return done;
};

stoComLecture = function () {

    var person = pp.mediator.person;

Select:
    var fieldNamesLess = [];
    for (var i = 0; i <= pp.fdMathematics; i++)
        fieldNamesLess.push(pp.world.fields[i].name);
    var selFieldId = sto.wuiSelectOptionsWithCancel(fieldNamesLess, __("講義受講"));

    if (selFieldId == pp.selCancel) {
        return false;
    }

    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComLecture, selFieldId);
    goto("Select");

NotCheckingText:
    var fieldName = pp.world.fields[selFieldId].name;
    var mon = pp.monLecture;

    var sel = sto.wuiSelectOkCancel([
        __(str.s395, fieldName),
        __(str.s396, mon)
        //fieldName + "の講義を受講します。\nよろしいですか？",
        //"必要資金：" + mon
    ]);

    if (sel == pp.selCancel) {
        goto("Select");
    }

    if (person.money < mon) {
        goto("NotEnoughMoney");
    }

    sto.callStoryFunc(this.stoExeLecture, selFieldId);
    return true;

NotEnoughMoney:
    sto.wuiShowMessage(
        __(str.s397)
        //"資金が足りません。"
    );
    goto("Select");
};

stoExeLecture = function (fieldId, forcedValue) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var p0;
    var p1;
    var up;
    var mes;
    var person = pp.mediator.person;

    var fieldp = person.fieldPs[fieldId];

    p0 = fieldp.knowledge;

    //上昇値計算
    up = fieldp.aptitude / 10 + tm.irand(-1, 1);
    up = tm.itrim(up, 1, 10);
    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);
    if (up+p0 > pp.fieldKnowledgeMax) up = pp.fieldKnowledgeMax - p0;
    p1 = p0 + up;

    if (!cc.isUndefined(forcedValue))
        p1 = forcedValue;

    //'*** ﾒｯｾｰｼﾞ作成
    switch (fieldId)
    {
        case pp.fdAstronomy:
            //'学習-天文学
            mes =
                p1 < 10 ? __(str.s398) :
                p1 < 30 ? __(str.s399) :
                p1 < 50 ? __(str.s400) :
                p1 < 100 ? __(str.s401) :
                           __(str.s402);
            /*
                p1 < 10 ? "地球が丸いというのもにわかには信じがたい。裏側にいる人間は落っこちてしまうではないか。" :
                p1 < 30 ? "この天空は不変不滅の世界。美しい幾何学的な軌道がそれを証明しているのだろう。" :
                p1 < 50 ? "惑星が太陽を焦点とする楕円運動しているとすれば、その軌道を決定するものは一体何なのだろうか・・・。" :
                p1 < 100 ? "天文学の進歩とは観測技術の進歩であると言えるな。高性能の望遠鏡は天界の法則をたどる道しるべとなるはずだ。" :
                           "惑星の軌道は完全な楕円軌道からは少しずつ外れている。惑星同士の位置関係が関係しているとすると・・・。";
                           */
            break;


        case pp.fdBiology:
            //'学習-生物学
            mes =
                p1 < 10 ? __(str.s403) :
                p1 < 30 ? __(str.s404) :
                p1 < 50 ? __(str.s405) :
                p1 < 100 ? __(str.s406) :
                           __(str.s407);

            /*
                p1 < 10 ? "私も生物なので腹が減っては学習にも身が入らないな。\nまずは食事にしよう。" :
                p1 < 30 ? "生物の体も機械と同様に、自然界の法則に従って機能しているのだな。" :
                p1 < 50 ? "コルクは沢山の部屋が集まって出来ているのか。他の植物にも当てはまるのではないだろうか？" :
                p1 < 100 ? "針と言っても所詮は人間の作り上げた物であって、拡大すれば丸みを帯びている。神の作品である生物はどんなに拡大しても構造を持っている。" :
                           "物質が大きいとか小さいとかいうことはあくまでも相対的な基準だ。どれほど拡大してみても決して終わることはない。";
                           */
            break;

        case pp.fdHeat:
            //'学習-熱力学
            mes =
                p1 < 10 ? __(str.s408) :
                p1 < 30 ? __(str.s409) :
                p1 < 50 ? __(str.s410) :
                p1 < 100 ? __(str.s411) :
                            __(str.s412);

            /*
                p1 < 10 ? "真空と言われても良くわからないな。頭の中が空っぽになったようだ。" :
                p1 < 30 ? "物質の燃焼は真空中では発生しないのか。空気と燃焼には密接な関わりがあるということか。" :
                p1 < 50 ? "燃焼した物体の質量が増加するとはおかしな事だが、しかし実際には起こっている・・・。" :
                p1 < 100 ? "ポンプがくみ上げる水の高さに限度があるということは、真空の力にも限界があることだ。その力の源は・・・？" :
                           "真空と言っても圧力が測定できないほど低くなった状態に過ぎない・・・。むしろ地上こそ高圧状態の特異な系とも言える。";
                           */
            break;

        case pp.fdMechanics:
            //'学習-力学
            mes =
                p1 < 10 ? __(str.s413) :
                p1 < 30 ? __(str.s414) :
                p1 < 50 ? __(str.s415) :
                p1 < 100 ? __(str.s416) :
                            __(str.s417);

            /*
             p1 < 10 ? "馬車は急には止まれない・・・。\n外を出歩く時は気をつけるとしよう。" :
                p1 < 30 ? "振り子の揺れる周期は一定なのか・・・。これはいろいろなことに応用できそうな事実だ。" :
                p1 < 50 ? "相互作用が働かない限り物体は等速直線運動を続ける。しかし地上の物体は常に地球に向かって加速度運動をしている・・。" :
                p1 < 100 ? "地球が自転しているのであれば、もはや物体は地球に向かって落ちているとは言えない。落下地点は遠心力で東へずれる。" :
                           "天空にも地上と同様の自然法則が成り立つはずだ。この星空も永遠に輝き続けるとわけではない。";
                           */
            break;

        case pp.fdOptics:
            //'学習-光学
            mes =
                p1 < 10 ? __(str.s418) :
                p1 < 30 ? __(str.s419) :
                p1 < 50 ? __(str.s420) :
                p1 < 100 ? __(str.s421) :
                            __(str.s422);

            /*
             p1 < 10 ? "眼鏡がないぞ眼鏡が・・・。\nおっとおでこの上にあったか。" :
                p1 < 30 ? "水中のものをみると、実際よりも浅いところに置かれているように見える。それは光が屈折しているからか。" :
                p1 < 50 ? "影がはっきりとした像を見せるのは、光が粒子であることの証拠だ。波動であれば障害物の裏側に回りこむからな。" :
                p1 < 100 ? "光は干渉現象を示すのは光が波動であることの証拠と言える。しかし別の理論で説明できないだろうか・・・。" :
                           "色によって屈折率が異なることは、屈折式望遠鏡には限界があることを意味している。反射望遠鏡が主流になっていくだろう。";
            */
            break;

        case pp.fdMathematics:
            //'学習-数学
            mes =
                p1 < 10 ? __(str.s423) :
                p1 < 30 ? __(str.s423) :
                p1 < 50 ? __(str.s424) :
                p1 < 100 ? __(str.s425) :
                            __(str.s426);
            /*
             p1 < 10 ? "100の位から1を借りてきて・・・おや、答えが合わない。\n金の計算なら得意なのだが・・・。" :
                p1 < 30 ? "円周率は3.14159・・・どこまで求めることが出来るのだろう。" :
                p1 < 50 ? "賭け事は確率論の格好の題材といえる。実際事象が多く繰り返される程、理論値に近づいていくらしい。" :
                p1 < 100 ? "ある物体の位置、速度、加速度が与えられた場合その後の軌道は決定する。しかし実際の計算は四則演算では至難の技だな。" :
                           "自然現象を論じることにおいてここまで数学が有用であることは驚きを覚える。未来永劫に起こることすべてが計算できてしまうのだろうか・・・。";
                           */
            break;
    }

    //'資金減少
    person.money -= pp.monLecture;
    pp.mediator.uiUpdate();

    //'表示
    //sto.wuiShowVoice(person.id, null, mes, );
    sto.wuiShowVoice(
        person.id,
        res.Img_CutLecture,
        mes,
        __("講義受講") + " - " + pp.world.fields[fieldId].name,
        true);

    //'その分野の知識を上げる
    fieldp.knowledge = p1;
    pp.mediator.uiUpdate();

    //'ﾊﾟﾗﾒｰﾀ変化ﾒｯｾｰｼﾞ表示
    sto.wuiShowParamChange(
        __(pp.world.fields[fieldId].name + "知識",
            "Knowledge of " + pp.world.fields[fieldId].name,
            pp.world.fields[fieldId].name + "知识"
        ),
        p0, p1);

Exit:

    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s429, pp.world.fields[fieldId].name));
        //"" + pp.fieldNames[fieldId] + "についての講義を受講しています。");

    return true;
};

stoComReadBook = function () {

Select:
    var fieldNamesLess = [];
    for (var i = 0; i <= pp.fdMathematics; i++)
        fieldNamesLess.push(pp.world.fields[i].name);
    var selFieldId = sto.wuiSelectOptionsWithCancel(fieldNamesLess, __("読書"));

    if (selFieldId == pp.selCancel) {
        return false;
    }

    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComReadBook, selFieldId);
    goto("Select");

NotCheckingText:
    var fieldName = pp.world.fields[selFieldId].name;

    var sel = sto.wuiSelectOkCancel(
        __(str.s431, fieldName)
        //fieldName + "に関する本を読みます。\nよろしいですか？"
    );

    if (sel == pp.selCancel) {
        goto("Select");
    }

    sto.callStoryFunc(this.stoExeReadBook, selFieldId);
    return true;
};


stoComTrain = function () {

Select:
    var fieldNames = [];
    for (var i = 0; i <= pp.fdDrawing; i++)
        fieldNames.push(pp.world.fields[i].name);
    var selFieldId = sto.wuiSelectOptionsWithCancel(fieldNames, __("訓練"));

    if (selFieldId == pp.selCancel) {
        return false;
    }

    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComTrain, selFieldId);
    goto("Select");

NotCheckingText:
    var fieldName = pp.world.fields[selFieldId].name;

    var sel = sto.wuiSelectOkCancel(
        __(str.s433, fieldName)
        //fieldName + "に関する訓練を行います。\nよろしいですか？"
    );

    if (sel == pp.selCancel) {
        goto("Select");
    }

    sto.callStoryFunc(this.stoExeTrain, selFieldId);
    return true;
};

stoExeReadBook = function (fieldId, forcedValue) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var p0;
    var p1;
    var up;
    var mes;
    var person = pp.mediator.person;

    var fieldp = person.fieldPs[fieldId];

    p0 = fieldp.knowledge;

    //上昇値計算
    up = fieldp.aptitude / 20 + tm.irand(-1, 1);
    up = tm.itrim(up, 1, 5);
    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);
    if (up+p0 > pp.fieldKnowledgeMax) up = pp.fieldKnowledgeMax - p0;
    p1 = p0 + up;

    if (!cc.isUndefined(forcedValue))
        p1 = forcedValue;

    //'*** ﾒｯｾｰｼﾞ作成
    switch (fieldId)
    {
        case pp.fdAstronomy:
            //'学習-天文学
            mes =
                p1 < 10 ? __(str.s434) :
                p1 < 30 ? __(str.s435) :
                p1 < 50 ? __(str.s436) :
                p1 < 100 ? __(str.s437) :
                            __(str.s438);
/*
                p1 < 10 ? "地球が丸いというのもにわかには信じがたい。裏側にいる人間は落っこちてしまうではないか。" :
                p1 < 30 ? "この天空は不変不滅の世界。美しい幾何学的な軌道がそれを証明しているのだろう。" :
                p1 < 50 ? "惑星が太陽を焦点とする楕円運動しているとすれば、その軌道を決定するものは一体何なのだろうか・・・。" :
                p1 < 100 ? "天文学の進歩とは観測技術の進歩であると言えるな。高性能の望遠鏡は天界の法則をたどる道しるべとなるはずだ。" :
                            "惑星の軌道は完全な楕円軌道からは少しずつ外れている。惑星同士の位置関係が関係しているとすると・・・。";
                            */
            break;


        case pp.fdBiology:
            //'学習-生物学
            mes =
                p1 < 10 ? __(str.s439) :
                p1 < 30 ? __(str.s440) :
                p1 < 50 ? __(str.s441) :
                p1 < 100 ? __(str.s442) :
                            __(str.s443);
/*
 p1 < 10 ? "私も生物なので腹が減っては学習にも身が入らないな。\nまずは食事にしよう。" :
                p1 < 30 ? "生物の体も機械と同様に、自然界の法則に従って機能しているのだな。" :
                p1 < 50 ? "コルクは沢山の部屋が集まって出来ているのか。他の植物にも当てはまるのではないだろうか？" :
                p1 < 100 ? "針と言っても所詮は人間の作り上げた物であって、拡大すれば丸みを帯びている。神の作品である生物はどんなに拡大しても構造を持っている。" :
                            "物質が大きいとか小さいとかいうことはあくまでも相対的な基準だ。どれほど拡大してみても決して終わることはない。";
                            */
            break;

        case pp.fdHeat:
            //'学習-熱力学
            mes =
                p1 < 10 ? __(str.s444) :
                p1 < 30 ? __(str.s445) :
                p1 < 50 ? __(str.s446) :
                p1 < 100 ? __(str.s447) :
                            __(str.s448);
/*
                p1 < 10 ? "真空と言われても良くわからないな。頭の中が空っぽになったようだ。" :
                p1 < 30 ? "物質の燃焼は真空中では発生しないのか。空気と燃焼には密接な関わりがあるということか。" :
                p1 < 50 ? "燃焼した物体の質量が増加するとはおかしな事だが、しかし実際には起こっている・・・。" :
                p1 < 100 ? "ポンプがくみ上げる水の高さに限度があるということは、真空の力にも限界があることだ。その力の源は・・・？" :
                            "真空と言っても圧力が測定できないほど低くなった状態に過ぎない・・・。むしろ地上こそ高圧状態の特異な系とも言える。";
                            */
            break;

        case pp.fdMechanics:
            //'学習-力学
            mes =
                p1 < 10 ? __(str.s449) :
                p1 < 30 ? __(str.s450) :
                p1 < 50 ? __(str.s451) :
                p1 < 100 ? __(str.s452) :
                            __(str.s453);
            /*
                p1 < 10 ? "馬車は急には止まれない・・・。\n外を出歩く時は気をつけるとしよう。" :
                p1 < 30 ? "振り子の揺れる周期は一定なのか・・・。これはいろいろなことに応用できそうな事実だ。" :
                p1 < 50 ? "相互作用が働かない限り物体は等速直線運動を続ける。しかし地上の物体は常に地球に向かって加速度運動をしている・・。" :
                p1 < 100 ? "地球が自転しているのであれば、もはや物体は地球に向かって落ちているとは言えない。落下地点は遠心力で東へずれる。" :
                            "天空にも地上と同様の自然法則が成り立つはずだ。この星空も永遠に輝き続けるとわけではない。";
                            */
            break;

        case pp.fdOptics:
            //'学習-光学
            mes =
                p1 < 10 ? __(str.s454) :
                p1 < 30 ? __(str.s455) :
                p1 < 50 ? __(str.s456) :
                p1 < 100 ? __(str.s457) :
                            __(str.s458);
            /*
                p1 < 10 ? "眼鏡がないぞ眼鏡が・・・。\nおっとおでこの上にあったか。" :
                p1 < 30 ? "水中のものをみると、実際よりも浅いところに置かれているように見える。それは光が屈折しているからか。" :
                p1 < 50 ? "影がはっきりとした像を見せるのは、光が粒子であることの証拠だ。波動であれば障害物の裏側に回りこむからな。" :
                p1 < 100 ? "光は干渉現象を示すのは光が波動であることの証拠と言える。しかし別の理論で説明できないだろうか・・・。" :
                            "色によって屈折率が異なることは、屈折式望遠鏡には限界があることを意味している。反射望遠鏡が主流になっていくだろう。";
                            */
            break;

        case pp.fdMathematics:
            //'学習-数学
            mes =
                p1 < 10 ? __(str.s459) :
                p1 < 30 ? __(str.s459) :
                p1 < 50 ? __(str.s460) :
                p1 < 100 ? __(str.s461) :
                            __(str.s462);
/*
                p1 < 10 ? "100の位から1を借りてきて・・・おや、答えが合わない。\n金の計算なら得意なのだが・・・。" :
                p1 < 30 ? "円周率は3.14159・・・どこまで求めることが出来るのだろう。" :
                p1 < 50 ? "賭け事は確率論の格好の題材といえる。実際事象が多く繰り返される程、理論値に近づいていくらしい。" :
                p1 < 100 ? "ある物体の位置、速度、加速度が与えられた場合その後の軌道は決定する。しかし実際の計算は四則演算では至難の技だな。" :
                            "自然現象を論じることにおいてここまで数学が有用であることは驚きを覚える。未来永劫に起こることすべてが計算できてしまうのだろうか・・・。";
                            */
            break;
    }

    //'表示
    //sto.wuiShowVoice(person.id, null, mes, );
    sto.wuiShowVoice(
        person.id,
        res.Img_CutStudy,
        mes,
        __("読書") + " - " + pp.world.fields[fieldId].name,
        true);

    //'その分野の知識を上げる
    fieldp.knowledge = p1;
    pp.mediator.uiUpdate();

    //'ﾊﾟﾗﾒｰﾀ変化ﾒｯｾｰｼﾞ表示
    sto.wuiShowParamChange(
        __(pp.world.fields[fieldId].name2 + "知識",
            "Knowledge of " + pp.world.fields[fieldId].name,
            pp.world.fields[fieldId].name2 + "知识"
        ),
        p0, p1);

Exit:
    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s465, pp.world.fields[fieldId].name)
        //"" + pp.world.fields[fieldId].name + "についての本を読んでいます。"
    );

    return true;
};

stoExeTrain = function (fieldId, forcedValue) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var p0;
    var p1;
    var up;
    var mes;
    var person = pp.mediator.person;

    var fieldp = person.fieldPs[fieldId];

    p0 = fieldp.experience;

    //上昇値計算
    up = fieldp.aptitude / 20 + tm.irand(0, 4);
    up = tm.imax(up, 1);
    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);
    if (up+p0 > pp.fieldExperienceMax) up = pp.fieldExperienceMax - p0;
    p1 = p0 + up;

    if (!cc.isUndefined(forcedValue))
        p1 = forcedValue;

    //'*** ﾒｯｾｰｼﾞ作成
    switch (fieldId)
    {
        case pp.fdAstronomy:
            //'学習-天文学
            mes =
                p1 < 10 ? __(str.s434) :
                p1 < 30 ? __(str.s435) :
                p1 < 50 ? __(str.s436) :
                p1 < 100 ? __(str.s437) :
                            __(str.s438);
            /*
             p1 < 10 ? "地球が丸いというのもにわかには信じがたい。裏側にいる人間は落っこちてしまうではないか。" :
             p1 < 30 ? "この天空は不変不滅の世界。美しい幾何学的な軌道がそれを証明しているのだろう。" :
             p1 < 50 ? "惑星が太陽を焦点とする楕円運動しているとすれば、その軌道を決定するものは一体何なのだろうか・・・。" :
             p1 < 100 ? "天文学の進歩とは観測技術の進歩であると言えるな。高性能の望遠鏡は天界の法則をたどる道しるべとなるはずだ。" :
             "惑星の軌道は完全な楕円軌道からは少しずつ外れている。惑星同士の位置関係が関係しているとすると・・・。";
             */
            break;


        case pp.fdBiology:
            //'学習-生物学
            mes =
                p1 < 10 ? __(str.s439) :
                p1 < 30 ? __(str.s440) :
                p1 < 50 ? __(str.s441) :
                p1 < 100 ? __(str.s442) :
                            __(str.s443);
            /*
             p1 < 10 ? "私も生物なので腹が減っては学習にも身が入らないな。\nまずは食事にしよう。" :
             p1 < 30 ? "生物の体も機械と同様に、自然界の法則に従って機能しているのだな。" :
             p1 < 50 ? "コルクは沢山の部屋が集まって出来ているのか。他の植物にも当てはまるのではないだろうか？" :
             p1 < 100 ? "針と言っても所詮は人間の作り上げた物であって、拡大すれば丸みを帯びている。神の作品である生物はどんなに拡大しても構造を持っている。" :
             "物質が大きいとか小さいとかいうことはあくまでも相対的な基準だ。どれほど拡大してみても決して終わることはない。";
             */
            break;

        case pp.fdHeat:
            //'学習-熱力学
            mes =
                p1 < 10 ? __(str.s444) :
                p1 < 30 ? __(str.s445) :
                p1 < 50 ? __(str.s446) :
                p1 < 100 ? __(str.s447) :
                            __(str.s448);
            /*
             p1 < 10 ? "真空と言われても良くわからないな。頭の中が空っぽになったようだ。" :
             p1 < 30 ? "物質の燃焼は真空中では発生しないのか。空気と燃焼には密接な関わりがあるということか。" :
             p1 < 50 ? "燃焼した物体の質量が増加するとはおかしな事だが、しかし実際には起こっている・・・。" :
             p1 < 100 ? "ポンプがくみ上げる水の高さに限度があるということは、真空の力にも限界があることだ。その力の源は・・・？" :
             "真空と言っても圧力が測定できないほど低くなった状態に過ぎない・・・。むしろ地上こそ高圧状態の特異な系とも言える。";
             */
            break;

        case pp.fdMechanics:
            //'学習-力学
            mes =
                p1 < 10 ? __(str.s449) :
                p1 < 30 ? __(str.s450) :
                p1 < 50 ? __(str.s451) :
                p1 < 100 ? __(str.s452) :
                            __(str.s453);
            /*
             p1 < 10 ? "馬車は急には止まれない・・・。\n外を出歩く時は気をつけるとしよう。" :
             p1 < 30 ? "振り子の揺れる周期は一定なのか・・・。これはいろいろなことに応用できそうな事実だ。" :
             p1 < 50 ? "相互作用が働かない限り物体は等速直線運動を続ける。しかし地上の物体は常に地球に向かって加速度運動をしている・・。" :
             p1 < 100 ? "地球が自転しているのであれば、もはや物体は地球に向かって落ちているとは言えない。落下地点は遠心力で東へずれる。" :
             "天空にも地上と同様の自然法則が成り立つはずだ。この星空も永遠に輝き続けるとわけではない。";
             */
            break;

        case pp.fdOptics:
            //'学習-光学
            mes =
                p1 < 10 ? __(str.s454) :
                p1 < 30 ? __(str.s455) :
                p1 < 50 ? __(str.s456) :
                p1 < 100 ? __(str.s457) :
                            __(str.s458);
            /*
             p1 < 10 ? "眼鏡がないぞ眼鏡が・・・。\nおっとおでこの上にあったか。" :
             p1 < 30 ? "水中のものをみると、実際よりも浅いところに置かれているように見える。それは光が屈折しているからか。" :
             p1 < 50 ? "影がはっきりとした像を見せるのは、光が粒子であることの証拠だ。波動であれば障害物の裏側に回りこむからな。" :
             p1 < 100 ? "光は干渉現象を示すのは光が波動であることの証拠と言える。しかし別の理論で説明できないだろうか・・・。" :
             "色によって屈折率が異なることは、屈折式望遠鏡には限界があることを意味している。反射望遠鏡が主流になっていくだろう。";
             */
            break;

        case pp.fdMathematics:
            //'学習-数学
            mes =
                p1 < 10 ? __(str.s459) :
                p1 < 30 ? __(str.s459) :
                p1 < 50 ? __(str.s460) :
                p1 < 100 ? __(str.s461) :
                            __(str.s462);
            /*
             p1 < 10 ? "100の位から1を借りてきて・・・おや、答えが合わない。\n金の計算なら得意なのだが・・・。" :
             p1 < 30 ? "円周率は3.14159・・・どこまで求めることが出来るのだろう。" :
             p1 < 50 ? "賭け事は確率論の格好の題材といえる。実際事象が多く繰り返される程、理論値に近づいていくらしい。" :
             p1 < 100 ? "ある物体の位置、速度、加速度が与えられた場合その後の軌道は決定する。しかし実際の計算は四則演算では至難の技だな。" :
             "自然現象を論じることにおいてここまで数学が有用であることは驚きを覚える。未来永劫に起こることすべてが計算できてしまうのだろうか・・・。";
             */
            break;

        case pp.fdEngineering:
            mes =
                p1 < 10 ? __(str.s495) :
                p1 < 30 ? __(str.s496) :
                p1 < 50 ? __(str.s497) :
                p1 < 100 ? __(str.s498) :
                           __(str.s499);
/*
                p1 < 10 ?   "ここを削るのか・・・。しまった、削りすぎて無くなってしまった。" :
                p1 < 30 ?   "レンズを磨くのも大変な作業だな。僅かなずれがあるだけでそのレンズは使い物にならないのだ。" :
                p1 < 50 ?   "歯車を組み合わせると、こんな複雑な運動も再現できるのか。これならかなり高度な機械も実現できそうだな。" :
                p1 < 100 ?  "人間の手は機械では到底行えない精密な作業をする力を持っている。そしてそれは鍛錬次第と言えそうだ。" :
                            "いくら優れた設計であっても、技術力が伴わなければそれらは机上の空論でしかないのだ。";
                            */
            break;

        case pp.fdDrawing:
            mes =
                p1 < 10 ? __(str.s500) :
                p1 < 30 ? __(str.s501) :
                p1 < 50 ? __(str.s502) :
                p1 < 100 ? __(str.s503) :
                            __(str.s504);
            /*
                p1 < 10 ?   "あのご婦人の美しいことと言ったら・・・。これではスケッチどころではない・・・。" :
                p1 < 30 ?   "違う。虎を描いているのだが、どうしても猫になってしまう。何がいけないのだろうか・・・。" :
                p1 < 50 ?   "遠いものは小さく、近くのものは大きく見える。その遠近法に気をつけたらスケッチにも立体感が出てきたな。" :
                p1 < 100 ?  "対象物の構造を知った上で描くべきだ。そうすることによって、それぞれの部品の細かい表現に現実感がでる。" :
                            "線一本一本の意味を意識して描かないと、絵の質感は出せないものだ。少しでも手を抜いたらそれは見る人に感じ取られてしまう。";
                            */
            break;

    }

    //'表示
    //sto.wuiShowVoice(person.id, null, mes, );
    sto.wuiShowVoice(
        person.id,
        null, //res.Img_CutStudy,
        mes,
        __("訓練") + " - " + pp.world.fields[fieldId].name,
        true);

    //'その分野の熟練を上げる
    fieldp.experience = p1;
    pp.mediator.uiUpdate();

    //'ﾊﾟﾗﾒｰﾀ変化ﾒｯｾｰｼﾞ表示
    sto.wuiShowParamChange(
        __(pp.world.fields[fieldId].name2 + "熟練", "Skill of " + pp.world.fields[fieldId].name),
        p0, p1);

Exit:
    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s507, pp.world.fields[fieldId].name));
        //"" + pp.world.fields[fieldId].name + "について訓練しています。");

    return true;
};
