
stoEveKnight = function (personId) {

    var person = pp.world.persons[personId];
    var prevToShowMessageTemporary = pp.mediator.toShowMessageTemporary;

    person.knightedSocietyId = person.societyId;

    pp.mediator.setBgm(res.Mus_Main, 1);

    //---------- SCENE SOCIETY ----------
    sto.wuiPushScene(pp.ScnSociety, person.societyId, cc.TransitionFlipX, 3);

    //pp.mediator.uiUpdatePlace(person.placeId);
    //pp.mediator.uiBlinkPerson(person.id);

    var society = pp.world.societies[person.societyId];
    var monarch = pp.world.persons[society.monarchId];
    sto.wuiShowMessage(
        __(str.s819, society.name, monarch.firstName + __("", " ") + monarch.lastName, person.lastName, society.knightName)
        //"その日、" + society.name + "には" + monarch.firstName + monarch.lastName + "の姿があった。" +
        //"今やその名声が揺るぎないものとなった" + person.lastName + "を騎士（" + society.knightName + "）に叙任するためである。"
    );

    var mes = [
        "@" + person.fullName + __("よ。", ".", "。"),

        "@" + __(str.s820, society.nationName),
        //"そなたの自然哲学に対する貢献は計り知れぬ。" +
        //"その卓越した功績を讃え、今日そなたを騎士に叙任しよう。\n" +
        //"今後も" + society.nationName + "のために力を尽くすがよい。",

        __(str.s821),
        //"・・・光栄の極みです、国王陛下。",

        __(str.s822, society.nationName)
        //"今や自然哲学と技術の発展は国家の繁栄に欠かせないものとなりました。" +
        //"微力ながら国王陛下と" + society.nationName + "のために一層尽力いたしましょう。"
    ];

    sto.wuiShowVoice([person.id, monarch.id], null, mes, __(str.s823)); //"勲爵叙任");

    //'年表追加
    if (person.isManual) {

        person.addDiary(
            __(str.s824, monarch.firstName, society.knightName));
            //monarch.firstName + "により騎士（" + society.knightName + "）に叙任される。");
    }

    if (!person.isManual)
        goto("NotManual");

Manual:
    sto.wuiShowMessageEx(
        __(str.s825, person.fullName, monarch.firstName),
        //person.fullName + "は騎士（" + society.knightName + "）に叙任されました！",
        res.Img_CutKnighted);

    goto("EndIf");

NotManual:

    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowMessage(
        __(str.s825, person.fullName, monarch.firstName));
        //person.fullName + "は騎士（" + society.knightName + "）に叙任されました！",

    pp.mediator.toShowMessageTemporary = prevToShowMessageTemporary;

EndIf:
    //'名声UP
    //'上昇値の元を計算
    var fup = 500;

    sto.wuiShowParamChange(__("名声"), person.fame, person.fame+fup, person.fullName);

    person.fame += fup;

    pp.mediator.uiUpdate();

    //'研究費授与
    var mup = 500;
    mup = tm.imin(mup, pp.monMax - person.money);

    sto.wuiShowParamChange(__("資金"), person.money, person.money+mup, person.fullName);
    person.money += mup;

    pp.mediator.uiUpdate();

    //'組織権威上昇
    var aup = tm.imin(fup / 10, 20);
    sto.wuiShowParamChange(__("権威"), society.authority, society.authority+aup, society.name);
    society.authority += aup;

    //pp.mediator.uiBlinkPerson(pp.ID_INVALID);

    //---------- SCENE SOCIETY ----------
    sto.wuiPopScene(cc.TransitionFlipX, 3);

    pp.mediator.toShowMessageTemporary = prevToShowMessageTemporary;
};
