
stoGameMain = function () {

    pp.mediator.setBgm(null);
    sto.wuiSetScene(pp.ScnGame, null, cc.TransitionFade, 1);

    pp.mediator.uiSetSceneMode(pp.SCN_GAME_MAIN);
    pp.mediator.uiHideCommandWindow();

    if (!pp.mediator.isDemo)
        pp.mediator.uiSetEnabledPager(false);

    //*** Reset previous selections
    pp.ScnPagedResearch.prevPageIdx = 0;

    if (pp.mediator.isCheckingText) goto("SkipMess");

    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowMessage(__(str.s738)); //"ゲームを開始します", "");
    pp.mediator.log("[" + __("ゲーム開始") + "]");

    pp.mediator.toShowMessageTemporary = false;

SkipMess:
    sto.callTutorialFunc(this.stoTutGameDidStart);

StartMonth:
    pp.mediator.logStartMonth();

    if (pp.mediator.gameState == pp.gsTurn) {
        goto("PersonsTurns");
    }

    pp.mediator.gameState = pp.gsStartMonth;

    sto.callStoryFunc(this.stoStartMonth);

    if (pp.mediator.gameState == pp.gsEndGame) {
        goto("EndGame");
    }

PersonsTurns:
    pp.mediator.gameState = pp.gsTurn;

    sto.callStoryFunc(this.stoPersonsTurns);

    if (pp.mediator.gameState == pp.gsTitle) {
        pp.mediator.setBgm("");
        goto("Exit");
    }
    if (pp.mediator.gameState == pp.gsEndGame) {
        goto("EndGame");
    }

EndMonth:
    pp.mediator.gameState = pp.gsEndMonth;

    sto.callStoryFunc(this.stoEndMonth);

    if (pp.mediator.gameState == pp.gsEndGame) {
        goto("EndGame");
    }
    goto("StartMonth");

EndGame:
    sto.callStoryFunc(this.stoEndGame, pp.mediator.gameOverReason != pp.goClear);
    if (pp.mediator.gameState != pp.gsTitle) {
        pp.world.commandedPersonNum++;
        goto("PersonsTurns");
    }

Exit:
    return;
};

//////////////////////////////////////////////////////////////////////////////

stoStartMonth = function () {

    if (pp.mediator.isDemo || tmd.toShowCpuTurn == pp.ctCheckAll) {
        pp.mediator.setBgm(res.Mus_Main, 1);
    }

    if (pp.world.month != 1) {
        goto("NotJan");
    }

Jan:
    sto.callStoryFunc(this.stoStartYear);

NotJan:
    for (var i = 0; i < pp.world.persons.length; i++) {
        var person = pp.world.persons[i];
        var occup = pp.world.occupations[person.occupationId];
        person.money += occup.income;
        person.money = tm.min(person.money, pp.monMax);
    }

    pp.world.commandedPersonNum = 0;
    pp.mediator.isFirstPersonOfMonth = true;

    pp.world.initPersonIds();
    if (!pp.mediator.isCheckingText) {
        pp.world.shufflePersonIds();
    }
};


stoEndMonth = function () {

    pp.world.month++;

    if (pp.world.month <= 12)
        goto("NotNextYear");

NextYear:
    pp.world.month = 1;
    pp.world.year++;
    sto.callStoryFunc(this.stoEndYear);

NotNextYear:

    pp.mediator.uiUpdate();

    return;
};


stoStartYear = function () {
    //cc.log("=== stoStartYear called");

    //'*** 人物年行事
    var pidx = 0;

For:
    var person = pp.world.persons[pidx];

    //'*** 若年者が研究開始するかチェック

    if (person.state != pp.pcYoung)
        goto("DoneStartCheck");

    if (person.age < 16)
        goto("DoneStartCheck");

    person.state = pp.pcActive;

    pp.mediator.toShowMessageTemporary = true;

    pp.mediator.uiUpdatePlace(person.placeId);
    pp.mediator.uiBlinkPerson(person.id);

    sto.callStoryFunc(this.stoEvePersonActivated, person.id);

    pp.mediator.toShowMessageTemporary = false;

    pp.mediator.uiBlinkPerson(pp.ID_INVALID);

DoneStartCheck:

    //*** 騎士叙任チェック

    if (person.societyId == pp.idInvalid || person.knightedSocietyId != pp.idInvalid || person.fame < pp.famKnighthood)
        goto("Continue");

    //*** 騎士叙任
    pp.mediator.toShowMessageTemporary = person.isManual || pp.world.interestedPersonId == person.id;

    sto.callStoryFunc(this.stoEveKnight, person.id);

    pp.mediator.toShowMessageTemporary = false;

Continue:
    pidx++;
    if (pidx < pp.world.persons.length)
        goto("For");

ExitFor:

    sto.callStoryFunc(this.stoEveChangeSocietyJobs, 0);

    if (pp.mediator.gameState == pp.gsEndGame)
        goto("Exit");

    sto.callStoryFunc(this.stoEveChangeSocietyJobs, 1);

Exit:
    return;
};


stoEndYear = function () {
    cc.log("=== stoEndYear called");

    //'*** 12月に人物死亡チェック

    var pidx = 0;

For:
    var person = pp.world.persons[pidx];

    if (person.state != pp.pcActive)
        goto("Continue");

    if (person.deathYear > pp.world.year)
        goto("Continue");

    sto.callStoryFunc(this.stoEvePersonDied, person.id);

    //死亡したのはプレイヤーか？
    if (person.isManual)
        goto("AllPlayerDied");

NoPlayerDied:
    if (person.societyId == pp.idInvalid)
        goto("DiedPlayerIsNotMember");

    var society = pp.world.societies[person.societyId];
    var ret = this.secedeSociety(person.id);
    var pUp = ret[0];
    var sUp = tm.imax(ret[1], -society.authority);
    //'組織権威低下
    sto.wuiShowParamChange(__("権威"), society.authority, society.authority + sUp, society.name);
    society.authority += sUp;

DiedPlayerIsNotMember:
    goto("Continue");

AllPlayerDied:
    pp.mediator.gameOverReason = pp.goDead;
    pp.mediator.gameState = pp.gsEndGame;
    pp.mediator.pidEnding = person.id;
    goto("Exit");

Continue:
        pidx++;
    if (pidx < pp.world.persons.length)
        goto("For");
ExitFor:

Exit:
    return;
};


stoPersonsTurns = function () {

For:
    if (pp.world.commandedPersonNum >= pp.world.persons.length) {
        goto("Exit");
    }

    var personId = pp.world.shuffledPersonIds[pp.world.commandedPersonNum];

    if (pp.world.persons[personId].state != pp.pcActive)
        goto("Next");

    pp.mediator.personId = personId;

    pp.mediator.toShowMessageTemporary = false;

    sto.wuiSetFocusOnPlace(pp.mediator.person.placeId);

    sto.callStoryFunc(this.stoPersonTurn);

    pp.mediator.isFirstPersonOfMonth = false;

    if (pp.mediator.gameState == pp.gsTitle || pp.mediator.gameState == pp.gsEndGame) {
        goto("Exit");
    }

Next:
    pp.world.commandedPersonNum++;
    goto("For");

Exit:
    pp.mediator.personId = pp.idInvalid;
    return;
};


stoEndGame = function (isSimple) {

    pp.mediator.stopBgm();

    // Push Scene
    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3, true);

    //*** 振り返り
    sto.callStoryFunc(this.stoEveEnding, pp.mediator.pidEnding);

    //*** スタッフロール
    sto.callStoryFuncIf(!isSimple, this.stoEveStaffRoll);

    //*** Thank you
    sto.callStoryFunc(this.stoShowThankYou, pp.mediator.pidEnding);

    sto.wuiSetScene(pp.Scn, null, cc.TransitionFade, 1, true);

    if (isSimple)
        goto("GoToTitle");

    pp.mediator.toShowMessageTemporary = true;

    var ret = sto.wuiSelectOkCancel(__(str.s771)); //"ゲームを終了してタイトルに戻ります。");

    pp.mediator.toShowMessageTemporary = false;

    if (ret != pp.selCancel)
        goto("GoToTitle");

BackToGame:
    // 元画面 (Map) へ Pop
    sto.wuiPopScene(cc.TransitionFade, 3, true);
    goto("Exit");

GoToTitle:
    pp.mediator.gameState = pp.gsTitle;

    // 元画面 (Map) を表示しないように Pop
    pp.mediator.scnGame.visible = false;
    sto.wuiPopScene(null, null, true);
    goto("Exit");

Exit:
    return;
};
