
stoTutCheckCond = function (cond, checkOnly) {

    if (!cond) goto("Failed");

    sto.callStoryFuncIf(!checkOnly, this.stoTutCheckCleanUp);
    return true;

Failed:
    sto.callStoryFunc(this.stoTutCheckFailed);
    return false;
};

stoTutCheckSelection = function (selObj, checkOnly) {

    var expectedObj = pp.world.tutorialNextSelection;

    var expectedArg0 = null;
    var expectedArg1 = null;
    var expectedSel;

    var userArg0 = null;
    var userArg1 = null;
    var userSel;

    if (cc.isArray(selObj)) {
        userSel = selObj[0];
        userArg0 = selObj[1];
        userArg1 = selObj[2];
    }
    else {
        userSel = selObj;
    }

    if (cc.isArray(expectedObj)) {
        expectedSel = expectedObj[0];
        expectedArg0 = expectedObj[1];
        expectedArg1 = expectedObj[2];
    }
    else {
        expectedSel = expectedObj;
    }

    cc.log(
        "selObj=" + selObj + ", userSel=" + userSel + ", userArg0=" + userArg0 + ", userArg1=" + userArg1 + ", " +
        "_expectedObj=" + expectedObj + ", eSel=" + expectedSel + ", eArg0=" + expectedArg0 + ", eArg1=" + expectedArg1 + ", " +
        "checkOnly=" + checkOnly);

    if (userSel != expectedSel && expectedSel != pp.cmCancel) goto("Failed");
    if (expectedArg0 != null && expectedArg0 != userArg0) goto("Failed");
    if (expectedArg1 != null && expectedArg1 != userArg1) goto("Failed");

    sto.callStoryFuncIf(!checkOnly, this.stoTutCheckCleanUp);
    return true;

Failed:
    sto.callStoryFunc(this.stoTutCheckFailed);
    return false;
};

stoTutCheckFailed = function () {
    //cc.log("[Failed]");
    sto.wuiShowTutorial(pp.world.tutorialLastMessage, true);
    pp.mediator.showBalloons();
};

stoTutCheckCleanUp = function () {
    //cc.log("[CleanUp]");
    pp.mediator.cleanUpBalloons();
    pp.world.tutorialNextSelection = pp.cmCancel;
};


//----------------------------------------------------------------------


stoTutSelectOnOff = function () {

    var sel = sto.wuiSelectOptionsWithCancel(
        [__("はい"), __("いいえ")],
        __(str.s829), //"チュートリアルを開始しますか？",
        null,
        null,
        pp.POP_FRM_FLAT_CANCEL_BUTTON
    );

    pp.world.tutorialStage =
        sel == pp.selCancel ? pp.tuInvlalid :
        sel == 0 ? pp.tuStart :
            pp.tuOff;

    pp.mediator.uiUpdate();
};


stoTutSelectPlayer = function () {

    if (pp.world.tutorialStage != pp.tuStart) return;

    sto.wuiShowTutorial(
        __(str.s830) + CRCR +
        __(str.s831) + CR +
        __(str.s832),
        //"プリンキピア・ペルフェクトゥスのチュートリアルへようこそ！" + CRCR +
        //"まずはプレイヤーを１２人の科学者の中から選択します。" + CR +
        //"チュートリアルではアイザック・ニュートンを選んでみましょう。",
        null,
        null,
        __(str.s833) //"チュートリアル開始"
    );

    sto.wuiShowTutorial(
        __(str.s834)
        //"アイザック・ニュートン を選択してください。"
    );

    pp.world.tutorialNextSelection = pp.piNewton;
};


stoTutGameDidStart = function () {

    if (pp.world.tutorialStage != pp.tuStart) return;

    sleep(1);

    pp.world.persons[pp.piNewton].themePs[0].themeId = pp.idInvalid;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s835) + CRCR +
        __(str.s836) + CR +
        __(str.s837));
    /*
        "ゲームが開始されました。" + CRCR +
        "本ゲームはターン制で、毎月ランダムな順番で各科学者のターンが回ってきます。" + CR +
        "プレイヤーのターンが回ってくるまで、しばらく待ちましょう。");
        */
};


stoTutPages1 = function () {

    if (pp.world.tutorialStage != pp.tuPages1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sleep(1);

    sto.wuiShowTutorial(
        __(str.s838) + CRCR +
        __(str.s839));
    /*
        "プレイヤーのターンになりました。" + CRCR +
        "最初のコマンドを実行する前に４つの画面モードについて説明します。");
        */

    pp.mediator.uiShowBalloon(
        __(str.s840), //"画面切り替えウインドウ",
        cc.p(tm.m(375, 370), tm.m(120, 768-30))
    );

    sto.wuiShowTutorial(
        __(str.s841) + CRCR +
        __(str.s842));
    /*
        "画面モードには『地図』『研究室』『テーマ一覧』『システム』の４つがあります。" + CRCR +
        "右上の『画面切り替えウインドウ』から切り替えが可能です。");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465), tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s843) + CRCR +
        __(str.s844), false, cc.p(0, 100));
    /*
        "現在選ばれているのは『地図』画面です。" + CRCR +
        "ここでは他の科学者との交流や、学習などが実行できます。", false, cc.p(0, 100));
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465)+150*1, tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s845) + CRCR +
        __(str.s846), true, cc.p(0, 100));
    /*
        "他の画面も見てみましょう。" + CRCR +
        "ボタンを押して画面を『研究室』に切り替えてください。", true, cc.p(0, 100));
        */

    pp.world.tutorialNextSelection = pp.cmpResearch;
};


stoTutPages2 = function () {

    if (pp.world.tutorialStage != pp.tuPages2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s847) + CRCR +
        __(str.s848));
    /*
        "『研究室』画面に移動しました。" + CRCR +
        "ここでは研究テーマを選択し、推理や実験（分野によっては観測、観察、計算）を実行することができます。");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465)+150*2, tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s849), //"ボタンを押して画面を『テーマ一覧』に切り替えてみましょう。",
        true);

    pp.world.tutorialNextSelection = pp.cmpThemeMap;
};

stoTutPages3 = function () {

    if (pp.world.tutorialStage != pp.tuPages3 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s850) + CRCR +
        __(str.s851));

        /*
        "『テーマ一覧』画面に移動しました。" + CR + CR +
        "ここでは、現在選択可能なテーマや、他の科学者の状況を確認することができます。");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465)+150*3, tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s852), true); //"次は『システム』に切り替えてみましょう。", true);

    pp.world.tutorialNextSelection = pp.cmpSystem;
};

stoTutPages4 = function () {

    if (pp.world.tutorialStage != pp.tuPages4 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s853) + CRCR +
        __(str.s854));
    /*
        "『システム』画面に移動しました。" + CR + CR +
        "ここでは、ゲームのセーブ／ロードや、図鑑の確認などができます。");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465)+150*1, tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s855) + CRCR +
        __(str.s856), true);

        /*
        "画面の説明は以上です。" + CR + CR +
        "それでは『研究室』に移動して研究を開始しましょう。", true);
        */

    pp.world.tutorialNextSelection = pp.cmpResearch;
};


stoTutSelectTheme1 = function () {

    if (pp.world.tutorialStage != pp.tuSelectTheme1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s857) + CRCR +
        __(str.s858));

    /*
        "『研究室』画面にもどってきました。" + CR + CR +
        "それでは、研究活動を開始しましょう！");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(112, 930), tm.m(340, 320)));

    sto.wuiShowTutorial(
        __(str.s859), true);

    //    "まずは『テーマ選択』を押して、研究テーマを選んでみましょう。", true);

    pp.world.tutorialNextSelection = pp.cmrSelect;
};


stoTutSelectTheme2 = function () {

    if (pp.world.tutorialStage != pp.tuSelectTheme2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s860) + CRCR +
        __(str.s861));

        /*
        "テーマ選択画面です。" + CR + CR +
        "ここから研究テーマを選択します。");
        */

    if (tm.m()) goto("Mobile");

    pp.mediator.uiShowBalloon("", cc.p(512-340, 630));
    pp.mediator.uiShowBalloon("", cc.p(512,     630));
    pp.mediator.uiShowBalloon("", cc.p(512+340, 630));
    pp.mediator.uiShowBalloon("", cc.p(512-340, 245));
    pp.mediator.uiShowBalloon("", cc.p(512,     245));
    pp.mediator.uiShowBalloon("", cc.p(512+340, 245));

Mobile:

    sto.wuiShowTutorial(
        __(str.s862) +
        __(str.s863) + CRCR +
        __(str.s864));

        /*
        "６つの分野『天文学』『力学』『熱力学』『生物学』『光学』『数学』それぞれに、" +
        "いくつかのテーマがあります。" + CR + CR +
        "各分野の知識が増えていくと、選択可能なテーマが増えていきます。");
        */

    //@@@
    pp.mediator.uiShowBalloon(
        __(str.s865),
        //"最終テーマ",
        cc.p(tm.m(cc.winSize.width/2, 512), tm.m(cc.winSize.height-200, 334)),
        pp.ALIGN_BOTTOM_LEFT);

    sto.wuiShowTutorial(
        __(str.s866),
        //"また、ある条件を満たすと中心にある『最終テーマ』が選べるようになります",
        false, cc.p(0, 100));

    sto.wuiShowTutorial(
        __(str.s867) + CRCR +
        __(str.s868));

    /*
        "それではプレイヤーが得意な分野で、なおかつ他の科学者とあまり競合しないようなテーマを選んでみましょう。" +
        CR + CR +
        "アイザック・ニュートン が得意なのは『光学』などです。");
        */

    pp.mediator.uiShowBalloon("", cc.p(tm.m(230, 550), tm.m(400, 210)), pp.ALIGN_BOTTOM_LEFT);

    sto.wuiShowTutorial(
        __(str.s869), true);

    //    "テーマ『光の性質』を選んでください。", true);

    pp.world.tutorialNextSelection = 18; //18: 光の性質
};


stoTutSelectEquip1 = function () {

    if (pp.world.tutorialStage != pp.tuSelectEquip1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.mediator.person.themePs[0].data = 18;
    pp.mediator.person.themePs[0].deduce = 15;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s870) + CRCR +
        __(str.s871),
        //"テーマを選びました。" + CR + CR +
        //"実験を行う前に、使用する実験器具を選択しましょう。",
        false, cc.p(0, 100));

    sto.wuiShowTutorial(
        __(str.s872) + CRCR +
        __(str.s873),
        //"実験器具は１つのテーマにつき２つまで選択することができます。" + CR + CR +
        //"ただし、対象の器具の分野と、テーマの分野が一致していることが条件です。",
        false, cc.p(0, 100));

    pp.mediator.uiShowBalloon("", cc.p(tm.m(660, 745), tm.m(660, 290)), pp.ALIGN_BOTTOM_LEFT);

    sto.wuiShowTutorial(
        __(str.s874),
        //"ここから実験に使用する器具を選択しましょう。",
        true, cc.p(0, tm.m(380, 100)));

    pp.world.tutorialNextSelection = [ pp.cmrItem, 0, 0 ];
};


stoTutSelectEquip2 = function () {

    if (pp.world.tutorialStage != pp.tuSelectEquip2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s875) + CRCR +
        __(str.s876),
        //"所有する光学系のアイテムが選択できます。" + CR + CR +
        //"ここではプリズムを選んでみましょう。",
        false, cc.p(0, 100));

    pp.world.tutorialNextSelection = pp.iiPrism;
};


stoTutExperiment1 = function () {

    if (pp.world.tutorialStage != pp.tuExperiment1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    /*
    pp.mediator.uiShowBalloon("", cc.p(930-55, 320+15));
    pp.mediator.uiShowBalloon("", cc.p(930-55, 250+15));
    */

    sto.wuiShowTutorial(
        __(str.s877) + CR +
        __(str.s878),
        //"このテーマに関する研究を行う準備ができました。" + CR +
        //"研究は『実験』または『推理』コマンドで実施することができます。",
        false, cc.p(0, 100));

    pp.mediator.uiShowBalloon("", cc.p(tm.m(110, 920), tm.m(350, 320)));

    sto.wuiShowTutorial(
        __(str.s879),
        //"ここから『実験』を実行してみましょう。",
        true, cc.p(0, 100));

    pp.world.tutorialNextSelection = [ pp.cmrData, 0 ];
};


stoTutExperiment2 = function () {

    if (pp.world.tutorialStage != pp.tuExperiment2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.mediator.uiShowBalloon("", cc.p(tm.m(375, 512-200), tm.m(580, 384+60)), tm.m(pp.ALIGN_BOTTOM_LEFT, null));

    sto.wuiShowTutorial(
        __(str.s880) + CRCR +
        __(str.s881),
        //"テーマ『光の性質』の実験値が上昇しました！" + CR + CR +
        //"『実験』値と『推理』値がある一定値を超えると『発見イベント』が発生します。",
        false, cc.p(0, tm.m(250, -200)));

};


stoTutDiscovery = function () {

    if (pp.world.tutorialStage != pp.tuDiscovery - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s882) + CRCR +
        __(str.s883),
        //"プレイヤーが新しい理論を発見しました！" + CR + CR +
        //"次ターン以降では、この理論を検証していきましょう。",
        false, cc.p(0, tm.m(0, -200)));
};


stoTutTheory1 = function () {

    if (pp.world.tutorialStage != pp.tuTheory1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s884));
        //"プレイヤーのターンになりました。");

    pp.mediator.uiShowBalloon(
        __(str.s885),
        //"発見ボタン",
        cc.p(tm.m(70, 300 - 58*3), tm.m(200, 100)), pp.ALIGN_TOP_RIGHT);

    sto.wuiShowTutorial(
        __(str.s886) + CRCR +
        __(str.s887) +
        __(str.s888),
        //"先月の研究でプレイヤーが『理論』を発見したので、発見ボタンが１つ有効になっています。" + CR + CR +
        //"発見には『理論』『存在』『発明』『図』の４種類がありますが、実行可能なコマンドは" +
        //"全てこの発見ボタンから呼び出すことができます。",
        true
    );

    sto.wuiShowTutorial(
        __(str.s889), true);
        //"発見ボタンから『理論検証』を実行してみましょう。", true);

    pp.world.tutorialNextSelection = pp.cmrDiscovery;
};


stoTutTheory2 = function () {

    if (pp.world.tutorialStage != pp.tuTheory2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.world.tutorialLastMessage =
        __(str.s890);
        //"『理論検証』を実行してみましょう。";

    pp.world.tutorialNextSelection = pp.cmdTheory;
};


stoTutTheory3 = function () {

    if (pp.world.tutorialStage != pp.tuTheory3 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.mediator.uiShowBalloon("", cc.p(tm.m(375, 512-200), tm.m(540, 384+60)), tm.m(pp.ALIGN_BOTTOM_LEFT, null));

    sto.wuiShowTutorial(
        __(str.s891) + CRCR +
        __(str.s892),
        //"理論の完成度が上昇しました！" + CR + CR +
        //"理論検証は繰り返すことで、更に理論の完成度を上げる事ができる可能性があります。",
        false, cc.p(0, tm.m(250, -200)));
};


stoTutWriteReport1 = function () {

    if (pp.world.tutorialStage != pp.tuWriteReport1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s893));
        //"プレイヤーのターンになりました。");

    pp.mediator.uiShowBalloon(
        __(str.s894),
        //"発見ボタン",
        cc.p(tm.m(70, 300 - 58*3), tm.m(200, 100)), pp.ALIGN_TOP_RIGHT);

    sto.wuiShowTutorial(
        __(str.s895) + CRCR +
        __(str.s896),
        //"先月は『理論検証』を行い、理論はそこそこの完成度を持つようになりました。" + CR + CR +
        //"さらに理論の完成度を高める事も可能ですが、ここでは『論文作成』を行ってみましょう。" ,
        true
    );

    sto.wuiShowTutorial(
        __(str.s897), true);
        //"発見ボタンから『論文作成』を実行してみましょう。", true);

    pp.world.tutorialNextSelection = pp.cmrDiscovery;
};


stoTutWriteReport2 = function () {

    if (pp.world.tutorialStage != pp.tuWriteReport2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.world.tutorialLastMessage =
        __(str.s898);
        //"『論文作成』を実行してみましょう。";

    pp.world.tutorialNextSelection = pp.cmdWriteReport;
};


stoTutWriteReport3 = function () {

    if (pp.world.tutorialStage != pp.tuWriteReport3 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s899) + CRCR +
        __(str.s900),
        //"おめでとうございます！初めての論文が完成しました！" + CR + CR +
        //"次のターンで論文を提出してみましょう。",
        false, cc.p(0, tm.m(0, -200)));
};


stoTutSubmitReport1 = function () {

    if (pp.world.tutorialStage != pp.tuSubmitReport1 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s901));
        //"プレイヤーのターンになりました。");

    pp.mediator.uiShowBalloon(
        __(str.s902),
        //"発見ボタン",
        cc.p(tm.m(70, 300 - 58*3), tm.m(200, 100)), pp.ALIGN_TOP_RIGHT);

    sto.wuiShowTutorial(
        __(str.s903) + CRCR +
        __(str.s904),
        //"先月、論文が１つ完成しました。" + CR + CR +
        //"ここで論文を科学アカデミーに提出してみましょう。" ,
        true
    );

    sto.wuiShowTutorial(
        __(str.s905), true);
        //"発見ボタンから『論文提出』を実行してみましょう。", true);

    pp.world.tutorialNextSelection = pp.cmrDiscovery;
};


stoTutSubmitReport2 = function () {

    if (pp.world.tutorialStage != pp.tuSubmitReport2 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.world.tutorialLastMessage =
        __(str.s906);
        //"『論文提出』を実行してみましょう。";

    pp.world.tutorialNextSelection = pp.cmdSubmitReport;
};


stoTutSubmitReport3 = function () {

    if (!pp.mediator.person.isManual) return;

    if (pp.world.tutorialStage != pp.tuSubmitReport3 - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    sto.wuiShowTutorial(
        __(str.s907),
        //"おめでとうございます！初めての論文が受理されました！",
        false, cc.p(0, tm.m(0, 100)));
};


stoTutCheckThemeMap = function () {

    if (pp.world.tutorialStage != pp.tuThemeMap - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465)+150*2, tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s908),
        //"先月、論文が１つ受理されました。ここでテーマ一覧画面を確認してみましょう。",
        true);

    pp.world.tutorialNextSelection = pp.cmpThemeMap;
};


stoTutCheckMap = function () {

    if (pp.world.tutorialStage != pp.tuMap - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    pp.mediator.uiShowBalloon("", cc.p(tm.m(64, 410), tm.m(400, 210)), tm.m(pp.ALIGN_BOTTOM_RIGHT, null));

    sto.wuiShowTutorial(
        __(str.s909) + CRCR +
        __(str.s910) + CR +
        __(str.s911),
        //"テーマ『光の性質』の権威（最も詳しい科学者）がプレイヤーになり、アイコンが表示されています！" + CRCR +
        //"また自分の論文が受理されたので、緑のゲージが表示されています。" + CR +
        //"この調子で論文を発表していけば緑のゲージは更に増えるはずです。",
        false,
        cc.p(0, 100)
    );

    pp.mediator.uiShowBalloon("", cc.p(tm.m(138, 465), tm.m(80, 768-50)));

    sto.wuiShowTutorial(
        __(str.s912),
        //"最後に、『地図』画面で『名声』値を確認してみましょう。",
        true
    );

    pp.world.tutorialNextSelection = pp.cmpMap;
};


stoTutLast = function () {

    if (pp.world.tutorialStage != pp.tuLast - 1) return;
    pp.world.tutorialStage += 1;
    pp.mediator.uiUpdate();

    if (!tm.m()) goto("NoMobile1");

    sto.wuiShowPerson(pp.piNewton, null, null, null, null, null, true);

NoMobile1:
    pp.mediator.uiShowBalloon("", cc.p(tm.m(450, 820), tm.m(1100, 640)));

    sto.wuiShowTutorial(
        __(str.s913) + CRCR +
        __(str.s914) +
        __(str.s915),
        //"論文を公開したことで名声値が上がっています！" + CRCR +
        //"名声値はこのゲームで最も重要なパラメーターで、" +
        //"科学アカデミーへの入会や、役員就任には高い名声値が欠かせません。",
        false,
        cc.p(0, -100)
    );

    if (!tm.m()) goto("NoMobile2");
    pp.mediator.uiClearOverlappedPopups();

NoMobile2:
    sto.wuiShowTutorial(
        __(str.s916) + CRCR +
        __(str.s917) + CR +
        __(str.s918)
        //"以上の手順で、論文を発表していくのが本ゲームの基本です。 " + CRCR +
        //"当面の目標は、科学アカデミーに入会することです。" + CR +
        //"名声値を200程度まであげて『入会希望』を実行することで、おそらく入会が認められるでしょう。"
    );

    sto.wuiShowTutorial(
        __(str.s919) + CRCR +
        __(str.s920) +
        __(str.s921) + CRCR +
        __(str.s922),

        //"チュートリアルは以上です。" + CRCR +
        //"『地図』画面で実行可能なコマンドなどは紹介しきれていませんが、" +
        //"是非いろいろ試してみてください。" + CRCR +
        //"最後までお付き合いいただきありがとうございました！",
        null,
        null,
        __(str.s923)
        //"チュートリアル完了"
    );

    pp.world.tutorialStage = pp.tuOff;
    pp.mediator.uiUpdate();
};
