
pp.FrmDate = pp.FrmHidable.extend({

    month: 0,
    year: 0,
    fname: "",
    lname: "",

    lblNameF: null,
    lblNameL: null,
    lblDate: null,

    ctor: function () {

        this._super(res.Img_FrmDate, pp.ALIGN_TOP_LEFT, tm.m(pp.FH_HIDE_TO_TOP, pp.FH_HIDE_TO_LEFT));

        this.setContentSize(tm.m(cc.winSize.width, 300), tm.m(100, 148));

        this.month = 1667;
        this.year = 4;
        this.fname = "アイザック";
        this.lname = "ニュートン";

        this._name = "FrmDate";

        // Create Content
        {
            this.lblDate = new tm.LabelTTF("0", pp.font, tm.m(38, 28), pp.colStroke1, pp.colText1, 1);
            this.lblDate.attr({
                anchorX: tm.m(0, 0.5),
                anchorY: tm.m(0.5, 1),
                x: tm.m(40, this.width/2),
                y: tm.m(this.height/2, this.height - 32 + tm.p(0,0,8)),
            });
            this.addChild(this.lblDate, 1);

            this.lblNameF = new tm.LabelTTF("0" , pp.font, tm.m(30, 22), cc.color.BLACK);
            this.lblNameF.attr({
                anchorX: tm.m(1, 0.5),
                anchorY: tm.m(0.5, 1),
                x: tm.m(this.width - 40, this.width/2),
                y: tm.m(this.height/2, this.lblDate.y - this.lblDate.height - 10 + tm.p(10,0,10))
            });
            this.lblNameF.setFontFillColor(cc.color(220,220,160));
            this.addChild(this.lblNameF, 1);

            this.lblNameL = new tm.LabelTTF("0" , pp.font, tm.m(30, 22), cc.color.BLACK);
            this.lblNameL.attr({
                x: this.width/2,
                y: this.lblNameF.y - this.lblNameF.height - 2 + tm.p(5,0,6),
                anchorY: 1
            });
            this.lblNameL.setFontFillColor(cc.color(220,220,160));
            this.addChild(this.lblNameL, 1);
        }

        this.menuS.attr({
            ignoreAnchor: false,
            anchorX: tm.m(0.5, 1),
            anchorY: tm.m(0, 1),
            x: tm.m(this.width/2, this.width - 8),
            y: tm.m(-8, this.height - 8)
        });

        if (tm.isMobile()) {
            this.menuS.visible = false;
        }
    },

    setYear: function (year) {
        this.year = year;
        this.lblDate.string = pp.mediator.getDateString();
    },

    setMonth: function (month) {
        this.month = month;
        this.lblDate.string = pp.mediator.getDateString();
    },

    setPersonId: function (personId) {
        if (pp.isIdValid(personId)) {
            var person = pp.world.persons[personId];
            if (tm.isMobile()) {
                this.lblNameF.string = person.firstName + __("・", " ") + person.lastName;
                this.lblNameL.string = "";
            }
            else {
                this.lblNameF.string = person.firstName;
                this.lblNameL.string = person.lastName;
            }
        }
        else {
            if (tm.isMobile()) {
                this.lblNameF.string = "－－－－" + __("・", " ") + "－－－－";
                this.lblNameL.string = "";
            }
            else {
                this.lblNameF.string = "－－－－";
                this.lblNameL.string = "－－－－";
            }
        }
    },

    updateLabels: function (world) {

        world = world || pp.world;

        this.setYear(world.year);
        this.setMonth(world.month);

        this.setPersonId(pp.mediator.personId);
    }

});
