
pp.FrmDateS = pp.Frm.extend({

    lblSociety: null,
    lblDate: null,

    ctor: function () {

        this._super(res.Img_FrmDate);
        this.setContentSize(tm.m(cc.winSize.width-2, 360), 120); //@@@

        // Set Default Position
        this.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: tm.m(1, 0),
            x: tm.m(1, 90),
            y: tm.m(cc.winSize.height - pp.LYR_STATUS_BAR_HEIGHT, cc.winSize.height - this.height - 10)
        });

        // Create Content
        {
            this.lblDate = new tm.LabelTTF("", pp.font, tm.m(28, 20), pp.colStroke1, pp.colText1, 1);
            this.lblDate.attr({
                anchorX: tm.m(0, 0.5),
                anchorY: tm.m(0.5, 1),
                x: tm.m(40, this.width/2),
                y: tm.m(this.height/2, this.height - 32 + tm.p(0,0,4)),
                textAlign: cc.TEXT_ALIGNMENT_CENTER
            });
            //this.lblDate.setFontFillColor(pp.colText1);
            //this.lblDate.enableStroke(pp.colStroke1, 2);
            this.addChild(this.lblDate, 1);

            this.lblSociety = new tm.LabelTTF("" , pp.font, tm.m(__(30, 28), __(22, 20)), cc.color.BLACK, cc.color(220,220,160), 1);
            this.lblSociety.attr({
                anchorX: 0.5,
                anchorY: tm.m(0.5, 0),
                x: this.width/2,
                y: tm.m(this.height/2, 32 - tm.p(0,0,4)),
                textAlign: cc.TEXT_ALIGNMENT_CENTER
            });
            //this.lblSociety.setFontFillColor(cc.color(220,220,160));
            //this.lblSociety.enableStroke(cc.color.BLACK, 2);
            this.addChild(this.lblSociety, 1);
        }
    },

    setYear: function (year) {
        this.year = year;
        this.lblDate.string = pp.prDate(this.year, this.month);
    },

    setMonth: function (month) {
        this.month = month;
        this.lblDate.string = pp.prDate(this.year, this.month);
    },

    setSocietyId: function (societyId) {
        if (pp.isIdValid(societyId)) {
            var society = pp.world.societies[societyId];
            this.lblSociety.string = society.name;
        }
        else {
            this.lblSociety.string = "－－－－";
        }
    },

    updateLabels: function (societyId, world) {
        world = world || pp.world;

        this.setYear(world.year);
        this.setMonth(world.month);

        this.setSocietyId(societyId);
    }

});
