
pp.FrmPager = pp.Frm.extend({

    menu: null,
    prevIsDemo: false,

    ctor: function () {

        this._super(res.Img_FrmCommand);

        this._name = "FrmPager";

        this.menu = null;
        this.prevIsDemo = null;

        this.uiUpdate();
    },

    uiUpdate: function () {

        if (this.prevIsDemo == pp.mediator.isDemo)
            return;

        if (this.menu) {
            this.menu.removeFromParent();
        }

        var menu;
        if (pp.mediator.isDemo && pp.mediator.gameState != pp.gsSelectPlayer) {
            this.setContentSize(tm.m(cc.winSize.width-2, 220), tm.m(120, 64));

            menu = new pp.MenuRect(
                [ __("システム") ],
                this.didClickInDemo,
                this,
                false,
                null, //cc.color(148,148,48),
                null,
                null,
                1.5
            );
        }
        else {
            this.setContentSize(tm.m(cc.winSize.width-2, 664), tm.m(120, 64));

            menu = new pp.MenuRect(
                [ __("地図"), __("研究室"), __("テーマ一覧"), __("システム") ],
                this.didClick,
                this,
                true,
                cc.color(148,148,48),
                null,
                null,
                tm.m(0.9, 1.5)
            );

            menu.setSelectedIndex(pp.PG_MAP);
        }
        menu.attr({
            anchorX: 0.5,
            anchorY: 0.5,
            x: this.width/2,
            y: this.height/2
        });
        this.addChild(menu);

        this.menu = menu;

        this.prevIsDemo = pp.mediator.isDemo;
    },

    didClick: function (item) {
        pp.mediator.playSound(res.Snd_Click);

        switch(item.tag) {
            case 0: pp.mediator.suiDidGetUserInput(pp.cmpMap); break;
            case 1: pp.mediator.suiDidGetUserInput(pp.cmpResearch); break;
            case 2: pp.mediator.suiDidGetUserInput(pp.cmpThemeMap); break;
            case 3: pp.mediator.suiDidGetUserInput(pp.cmpSystem); break;
        }
    },

    didClickInDemo: function () {
        pp.mediator.playSound(res.Snd_Click);
        pp.mediator.toShowMenuInDemo = true;
        pp.mediator.uiSetEnabledPager(false);
    }

});

