
pp.LyrBar = cc.LayerColor.extend({

    lyrFores: null,

    ctor: function (foreColors, backColor, width, height, values) {

        this._super(backColor, width, height);

        var foreColors = cc.isArray(foreColors) ? foreColors : [ foreColors ];
        var values = cc.isArray(values) ? values : [ values ];

        this.lyrFores = [];
        for (var i = 0; i < foreColors.length; i++) {

            var lyrFore = new cc.LayerColor(foreColors[i], width, height);
            lyrFore.setContentSize(width, height);
            lyrFore.attr({
                ignoreAnchor: false,
                anchorX: 0,
                anchorY: 0
            });
            this.lyrFores.push(lyrFore);
            this.addChild(lyrFore);

            this.setValue(i, values[i] || 0);
        }
    },

    setContentSize: function(size, height){
        this._super(size, height);
        var lyrFores = this.lyrFores;
        for (var i = 0; i < lyrFores.length; i++) {
            this.lyrFores[i].setContentSize(size, height);
        }
    },

    setValue: function (i, val) {
        this.lyrFores[i].scaleX = val;
    }
});

