
pp.LyrPerson = cc.Layer.extend({

    personId: 0,

    lblSociety: null,
    lblTitle: null,
    lblPlace: null,
    lblKnighthood: null,

    lblFame: null,
    lblMoney: null,
    lblAge: null,
    lblStatus: null,

    lblFName: null,
    lblLName: null,

    lblStFame: null,
    lblStMoney: null,
    lblStAge: null,

    sprFace: null,

    lyrPersonSubs: null,
    lyrPersonSubTheme: null,
    lyrPersonSubParamG: null,
    lyrPersonSubParamF: null,
    lyrPersonSubInfo: null,

    menu: null,
    menuR: null,

    enabled: true,

    ctor: function () {

        this._super();//cc.color.RED);

        this.enabled = true;
        this.personId = pp.ID_INVALID;

        this.width = tm.m(600, 437);

        var lyrPersonUpper;
        {
            lyrPersonUpper = new tm.Scale9SpriteTiled(res.Img_LyrDetailImage);
            lyrPersonUpper.setContentSize(tm.m(640, 437), tm.m(350, 220));
            lyrPersonUpper.attr({
                anchorX: 0.5,
                anchorY: 1,
                x: this.width/2,
            });
            this.addChild(lyrPersonUpper);
        }

        //*** Panel Root
        {
            // Face
            {
                // Back
                var sprBack = new cc.LayerColor(cc.color.WHITE, tm.m(192, 96), tm.m(256, 128));
                sprBack.attr({
                    ignoreAnchor: false,
                    anchorX: 1,
                    anchorY: 1,
                    x: lyrPersonUpper.width - 15,
                    y: lyrPersonUpper.height - 15,
                });
                lyrPersonUpper.addChild(sprBack);

                var spr = new cc.Sprite(res.Img_FaceEmpty);
                spr.attr({
                    anchorX: 0,
                    anchorY: 0,
                    scale: tm.m(2, 1)
                });
                spr.getTexture().setAliasTexParameters();

                sprBack.addChild(spr);
                this.sprFace = spr;

                // Name
                var labelF = this.lblFName = new cc.LabelTTF("－－－－", pp.font, tm.m(24, 17));
                labelF.attr({
                    anchorX: 0.5,
                    anchorY: 1,
                    x: lyrPersonUpper.width - 15 - sprBack.width/2,
                    y: sprBack.y - sprBack.height - 5
                });
                labelF.setFontFillColor(cc.color.BLACK);
                lyrPersonUpper.addChild(labelF);

                var labelL = this.lblLName = new cc.LabelTTF("－－－－", pp.font, tm.m(24, 17));
                labelL.attr({
                    anchorX: 0.5,
                    anchorY: 1,
                    x: labelF.x,
                    y: labelF.y - labelF.height - 2
                });
                labelL.setFontFillColor(cc.color.BLACK);
                lyrPersonUpper.addChild(labelL);
            }

            // Static Labels
            var lyr00, lyr10;
            var lyr01, lyr11;
            var lyr02, lyr12;
            var lyr03, lyr13;
            {
                var size0 = cc.size(tm.m(290, 228), tm.m(48, 32));
                lyr00 = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(pp.ATLAS_SOCIETY_S, cc.color(128,0,0)), size0, cc.TEXT_ALIGNMENT_LEFT);
                lyr00.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: 15,
                    y: lyrPersonUpper.height - 15
                });
                lyrPersonUpper.addChild(lyr00);
                lyr01 = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(pp.ATLAS_TITLE_S, cc.color(128,0,0)), size0, cc.TEXT_ALIGNMENT_LEFT);
                lyr01.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: 15,
                    y: lyrPersonUpper.height - 15 - (size0.height-1)*1
                });
                lyrPersonUpper.addChild(lyr01);
                lyr02 = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(pp.ATLAS_HOME_S, cc.color(128,0,0)), size0, cc.TEXT_ALIGNMENT_LEFT);
                lyr02.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: 15,
                    y: lyrPersonUpper.height - 15 - (size0.height-1)*2
                });
                lyrPersonUpper.addChild(lyr02);
                lyr03 = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(pp.ATLAS_KNIGHTHOOD_S, cc.color(128,0,0)), size0, cc.TEXT_ALIGNMENT_LEFT);
                lyr03.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: 15,
                    y: lyrPersonUpper.height - 15 - (size0.height-1)*3
                });
                lyrPersonUpper.addChild(lyr03);


                var size1 = cc.size(tm.m(110, 73), tm.m(48, 32));
                lyr10 = new pp.LyrBoxedLabel(__("名声"), size1, cc.TEXT_ALIGNMENT_LEFT, cc.color(128,0,0));
                lyr10.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: lyr00.x + lyr00.width - 1,
                    y: lyr00.y
                });
                lyrPersonUpper.addChild(lyr10);

                lyr11 = new pp.LyrBoxedLabel(__("資金"), size1, cc.TEXT_ALIGNMENT_LEFT, cc.color(128,0,0));
                lyr11.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: lyr01.x + lyr01.width - 1,
                    y: lyr01.y
                });
                lyrPersonUpper.addChild(lyr11);

                lyr12 = new pp.LyrBoxedLabel(__("年齢"), size1, cc.TEXT_ALIGNMENT_LEFT, cc.color(128,0,0));
                lyr12.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: lyr02.x + lyr02.width - 1,
                    y: lyr02.y
                });
                lyrPersonUpper.addChild(lyr12);

                lyr13 = new pp.LyrBoxedLabel("", size1, cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
                lyr13.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 1,
                    x: lyr03.x + lyr03.width - 1,
                    y: lyr03.y
                });
                lyrPersonUpper.addChild(lyr13);
            }

            // Variables (Right)
            {
                var label = new cc.LabelTTF("---", pp.font, tm.m(__(24, 18), __(tm.p(16,14,14), tm.p(14,12,12))));
                label.attr({ x: lyr10.width - 4, y: lyr10.height/2, anchorX: 1 });
                label.setFontFillColor(cc.color.BLACK);
                lyr10.addChild(label);
                this.lblFame = label;

                var label = new cc.LabelTTF("---", pp.font, tm.m(__(24, 18), __(tm.p(16,14,14), tm.p(14,12,12))));
                label.attr({ x: lyr11.width - 4, y: lyr11.height/2, anchorX: 1 });
                label.setFontFillColor(cc.color.BLACK);
                lyr11.addChild(label);
                this.lblMoney = label;

                var label = new cc.LabelTTF("---", pp.font, tm.m(__(24, 18), __(tm.p(16,14,14), tm.p(14,12,12))));
                label.attr({ x: lyr12.width - 4, y: lyr12.height/2, anchorX: 1 });
                label.setFontFillColor(cc.color.BLACK);
                lyr12.addChild(label);
                this.lblAge = label;

                var label = new tm.LabelTTF("---", pp.font, tm.m(__(24, 18), __(tm.p(16,14,14), tm.p(14,12,12))));
                label.attr({ x: lyr13.width/2, y: lyr13.height/2, anchorX: 0.5 });
                label.setFontFillColor(cc.color.WHITE);
                label.setFontStroke(cc.color.WHITE);
                lyr13.addChild(label);
                this.lblStatus = label;
            }

            // Variables (Left)
            {
                var label = new cc.LabelTTF("－－－－", pp.font, tm.m(__(24, 18), __(15, tm.p(12,11,11))));
                label.attr({ x: 32 + 4, y: lyr00.height/2, anchorX: 0 });
                label.setFontFillColor(cc.color.BLACK);
                lyr00.addChild(label);
                this.lblSociety = label;

                var label = new cc.LabelTTF("－－－－", pp.font, tm.m(__(24, 18), __(15, tm.p(12,11,11))));
                label.attr({ x: 32 + 4, y: lyr01.height/2, anchorX: 0 });
                label.setFontFillColor(cc.color.BLACK);
                lyr01.addChild(label, 2);
                this.lblTitle = label;

                var label = new cc.LabelTTF("－－－－", pp.font, tm.m(__(24, 18), __(15, tm.p(12,11,11))));
                label.attr({ x: 32 + 4, y: lyr02.height/2, anchorX: 0 });
                label.setFontFillColor(cc.color.BLACK);
                lyr02.addChild(label, 2);
                this.lblPlace = label;

                var label = new cc.LabelTTF("－－－－", pp.font, tm.m(__(24, 18), __(15, tm.p(12,11,11))));
                label.attr({ x: 32 + 4, y: lyr03.height/2, anchorX: 0 });
                label.setFontFillColor(cc.color.BLACK);
                lyr03.addChild(label, 2);
                this.lblKnighthood = label;

            }
        }

        // Menu on Frame
        {
            var menu = this.menu = new pp.Menu(
                tm.m(
                    [ res.ImgM_IconItems, res.ImgM_IconDiscoveries, res.ImgM_IconReports ],
                    [ res.Img_IconItems, res.Img_IconDiscoveries, res.Img_IconReports ]
                ),
                function (item) {
                    pp.mediator.playSound(res.Snd_Click);

                    switch (item.tag) {
                        case 0:
                            this.popItemList();
                            break;

                        case 1:
                            pp.mediator.discType = pp.ID_INVALID;
                            this.popDiscoveryList();
                            break;

                        case 2:
                            this.popReportList();
                            break;
                    }
                },
                this,
                cc.color(148,48,48)
            );
            menu.attr({
                ignoreAnchor: false,
                anchorX: 0,
                anchorY: 0,
                x: 12,
                y: 12
            });
            lyrPersonUpper.addChild(menu);
        }

        // Tabbed Panel
        {
            // Tab Buttons
            var tmenu;
            {
                tmenu = this.menuR = new pp.MenuRect(
                    [ __("テーマ"), __("一般能力"), __("分野能力"), __("人物情報") ],
                    function (item) {
                        this.setVisiblePage(item.tag);
                        //cc.log("CLICKED item.tag=" + item.tag);
                        pp.mediator.playSound(res.Snd_Click);
                    },
                    this,
                    true,
                    cc.color(148, 148, 48),
                    false,
                    0,
                    tm.m(0.915, 1.071)  // xMag
                );
            }


            // Frame
            var lyrFrame;
            {
                lyrFrame = new tm.Scale9SpriteTiled(res.Img_FrmSimple256x256);
                lyrFrame.setContentSize(tm.m(640, 432), tm.m(465, 310));
                lyrFrame.attr({
                    ignoreAnchor: false,
                    anchorX: 0.5,
                    anchorY: 0,
                    x: this.width/2,
                    y: tm.m(tmenu.height, 0)
                });
                this.addChild(lyrFrame, 1);

                // Tabbed Panels
                var lyr = this.lyrPersonSubTheme = new pp.LyrPersonSubTheme();
                lyr.attr({ ignoreAnchor: false, x: lyrFrame.width / 2, y: lyrFrame.height /2 });
                lyrFrame.addChild(lyr);

                var lyr = this.lyrPersonSubParamG = new pp.LyrPersonSubParamG();
                lyr.attr({ ignoreAnchor: false, x: lyrFrame.width / 2, y: lyrFrame.height /2 });
                lyrFrame.addChild(lyr);

                var lyr = this.lyrPersonSubParamF = new pp.LyrPersonSubParamF();
                lyr.attr({ ignoreAnchor: false, x: lyrFrame.width / 2, y: lyrFrame.height /2 });
                lyrFrame.addChild(lyr);

                var lyr = this.lyrPersonSubInfo = new pp.LyrPersonSubInfo();
                lyr.attr({ ignoreAnchor: false, x: lyrFrame.width / 2, y: lyrFrame.height /2 });
                lyrFrame.addChild(lyr);

                this.lyrPersonSubs = [
                    this.lyrPersonSubTheme,
                    this.lyrPersonSubParamG,
                    this.lyrPersonSubParamF,
                    this.lyrPersonSubInfo
                ];
                this.setVisiblePage(0);
            }

            {
                tmenu.attr({
                    ignoreAnchor: false,
                    anchorX: 0,
                    anchorY: 0,
                    x: lyrFrame.x - lyrFrame.width * lyrFrame.anchorX,
                    y: tm.m(0, lyrFrame.y + lyrFrame.height)
                });
                this.addChild(tmenu, 2);
            }


        }

        this.height = lyrPersonUpper.height + lyrFrame.height + tm.m(96, 48);
        lyrPersonUpper.y = this.height;
        //this.height = 578;
        //310+220=530 + 48
    },

    setVisiblePage: function (idx) {

        this.menuR.setSelectedIndex(idx);

        for (var i = 0; i < this.lyrPersonSubs.length; i++) {
            this.lyrPersonSubs[i].visible = idx == i;
        }
    },

    setPersonId: function (pid) {

        var world = pp.world;
        var person = world.persons[pid];

        this.personId = pid;

        this.lblSociety.string = person.getSocietyName();
        this.lblTitle.string = person.getJobName();
        this.lblPlace.string = world.places[person.placeId].name;
        this.lblKnighthood.string = person.getKnighthoodName();

        this.lblFame.string = person.fame;
        this.lblMoney.string = person.money;
        this.lblAge.string = person.getAge();
        var strAndCol = person.getStatusStringAndColor();
        this.lblStatus.setFontFillColor(strAndCol[1]);
        this.lblStatus.setFontStroke(strAndCol[2]);
        this.lblStatus.string = strAndCol[0];

        this.lblFName.string = person.firstName;
        this.lblLName.string = person.lastName;
        if (this.lblFName.string.length > 6) {
            this.lblFName.scaleX = 0.9;
        }
        else {
            this.lblFName.scaleX = 1;
        }
        if (this.lblLName.string.length > 6) {
            this.lblLName.scaleX = 0.9;
        }
        else {
            this.lblLName.scaleX = 1;
        }

        this.sprFace.setTexture(person.getImageFileName());

        this.lyrPersonSubs.forEach(function (lyr) {
            lyr.setPersonId(pid);
        });
    },

    popItemList: function () {
        pp.mediator.scn.addChild(new pp.PopListSelectPr(
            pp.ltItem,
            [pp.ftPerson, this.personId],
            function (sel) {
                if (sel != pp.selCancel) {
                    pp.mediator.scn.addChild(new pp.PopDetailItem([sel, this.personId]), 102);
                }
            },
            this,
            true
        ), 101);
    },

    popReportList: function () {
        pp.mediator.scn.addChild(new pp.PopListSelectPr(
            pp.ltReport,
            [pp.ftPerson, this.personId],
            function (sel) {
                if (sel != pp.selCancel) {
                    pp.mediator.scn.addChild(new pp.PopDetailReport(sel), 102);
                }
            },
            this,
            true
        ), 101);
    },

    popDiscoveryList: function () {
        pp.mediator.scn.addChild(new pp.PopListSelectPr(
            pp.ltDiscovery,
            [pp.ftPerson, this.personId],
            function (sel) {
                if (sel != pp.selCancel) {
                    pp.mediator.scn.addChild(new pp.PopDetailDiscovery([sel, this.personId]), 102);
                }
            },
            this,
            true
        ), 101);
    },

    setEnabled: function (enabled) {
        this.menu.setEnabled(enabled);
        this.menuR.setEnabled(enabled);
    }

});
