pp.LyrFieldP = cc.Layer.extend({

    lblAptitude: null,
    lblKnowledge: null,
    lblExperience: null,

    ctor: function (fieldId) {

        this._super();//cc.color.GREEN);

        var HEADER_HEIGHT = tm.m(66, 34);
        var ROW_HEIGHT = tm.m(42, 28);

        this.setContentSize(tm.m(180, 100), HEADER_HEIGHT + ROW_HEIGHT * 3 - 2);

        var field = pp.world.fields[fieldId];

        var lyr = new cc.LayerColor(cc.color.BLACK, tm.m(64, 32) + 2, tm.m(64, 32) + 2);
        lyr.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: this.height
        });
        this.addChild(lyr);
        var spr = pp.createSpriteFromAtlas(pp.ATLAS_ASTRO + fieldId);//, cc.color(128,0,0));
        spr.attr({
            anchorX: 0,
            anchorY: 0,
            x: 1,
            y: 1,
            scale: tm.m(2, 1)
        });
        spr.getTexture().setAliasTexParameters();
        lyr.addChild(spr);

        var lyrCaption = new pp.LyrBoxedLabel(
            fieldId == pp.fdMathematics ? field.name2 : field.name, cc.size(this.width-spr.width*spr.scaleX-spr.x, HEADER_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrCaption.attr({
            ignoreAnchor: false,
            anchorX: 1,
            anchorY: 1,
            x: this.width,
            y: this.height
        });
        this.addChild(lyrCaption);

        var lyrAptiS = new pp.LyrBoxedLabel(__("適性"), cc.size(tm.m(66, 40), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrAptiS.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: lyrCaption.y - lyrCaption.height + 1
        });
        this.addChild(lyrAptiS);

        var lyrApti = new pp.LyrBoxedLabel("--", cc.size(tm.m(115, 61), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(0,0,0));
        lyrApti.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: lyrAptiS.x + lyrAptiS.width-1,
            y: lyrAptiS.y
        });
        this.addChild(lyrApti);
        this.lblAptitude = lyrApti.label;


        var lyrKnowS = new pp.LyrBoxedLabel(__("知識"), cc.size(tm.m(66, 40), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrKnowS.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: lyrApti.y - lyrApti.height + 1
        });
        this.addChild(lyrKnowS);

        var lyrKnow = new pp.LyrBoxedLabel("--", cc.size(tm.m(115, 61), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(0,0,0));
        lyrKnow.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: lyrKnowS.x + lyrKnowS.width-1,
            y: lyrKnowS.y
        });
        this.addChild(lyrKnow);
        this.lblKnowledge = lyrKnow.label;

        var lyrTechS = new pp.LyrBoxedLabel(__("熟練"), cc.size(tm.m(66, 40), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrTechS.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: lyrKnow.y - lyrKnow.height + 1
        });
        this.addChild(lyrTechS);

        var lyrTech = new pp.LyrBoxedLabel("0", cc.size(tm.m(115, 61), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(0,0,0));
        lyrTech.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: lyrTechS.x + lyrTechS.width-1,
            y: lyrTechS.y
        });
        this.addChild(lyrTech);
        this.lblExperience = lyrTech.label;

    }


});

pp.LyrPersonSubParamF = pp.LyrPersonSub.extend({

    lblAptitudes: null,
    lblKnowledges: null,
    lblExperiences: null,

    ctor: function (person) {

        this._super(res.Img_LyrPersonSubSimple);

        this.lblAptitudes = [];
        this.lblKnowledges = [];
        this.lblExperiences = [];

        var marginY = 20;
        var marginX = 20;

        for (var iy = 0; iy < 2; iy++)
        {
            for (var ix = 0; ix < 3; ix++) {

                var lyr = new pp.LyrFieldP(iy*3+ix);
                lyr.attr({
                    x: marginX + (this.width - lyr.width - marginX*2) * ix / 2,
                    y: marginY + (this.height - lyr.height - marginY*2) * (1-iy) / 1
                });
                this.addChild(lyr);

                this.lblAptitudes.push(lyr.lblAptitude);
                this.lblKnowledges.push(lyr.lblKnowledge);
                this.lblExperiences.push(lyr.lblExperience);
            }
        }

        if (person) {
            this.setPersonId(person.id);
        }
    },

    setPersonId: function (pid) {
        var person = pp.world.persons[pid];
        var occupation = pp.world.occupations[person.occupationId];

        for (var i = 0; i < pp.prFieldNum; i++) {
            //this.lblAptitudes[i].string = person.fieldPs[i].aptitude;
            this.lblKnowledges[i].string = person.fieldPs[i].knowledge;
            this.lblAptitudes[i].string = person.fieldPs[i].getAptitudeStr();
            this.lblExperiences[i].string = person.fieldPs[i].experience;
            //this.lblAptitudes[i].string = "☆☆☆★★";
            //this.lblAptitudes[i].scaleX = 2/3;
            //this.lblKnowledges[i].string = "1";
        }
    }

});
