pp.LyrSubG = cc.Layer.extend({

    lblAptitude: null,
    lblExperience: null,

    ctor: function (name) {

        this._super();//cc.color.GREEN);

        var HEADER_HEIGHT = tm.m(64, 32);
        var ROW_HEIGHT = tm.m(42, 28);

        this.setContentSize(tm.m(180, 100), HEADER_HEIGHT + ROW_HEIGHT * 2 - 1);

        var lyrCaption = new pp.LyrBoxedLabel(name, cc.size(this.width, HEADER_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrCaption.attr({
            ignoreAnchor: false,
            anchorX: 1,
            anchorY: 1,
            x: this.width,
            y: this.height
        });
        this.addChild(lyrCaption);

        var lyrAptiS = new pp.LyrBoxedLabel(__("適性"), cc.size(tm.m(66, 40), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrAptiS.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: lyrCaption.y - lyrCaption.height + 1
        });
        this.addChild(lyrAptiS);

        var lyrApti = new pp.LyrBoxedLabel("--", cc.size(tm.m(115, 61), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(0,0,0));
        lyrApti.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: lyrAptiS.x + lyrAptiS.width-1,
            y: lyrAptiS.y
        });
        this.addChild(lyrApti);
        this.lblAptitude = lyrApti.label;

        var lyrTechS = new pp.LyrBoxedLabel(__("熟練"), cc.size(tm.m(66, 40), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(128,0,0));
        lyrTechS.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: 0,
            y: lyrApti.y - lyrApti.height + 1
        });
        this.addChild(lyrTechS);

        var lyrTech = new pp.LyrBoxedLabel("0", cc.size(tm.m(115, 61), ROW_HEIGHT), cc.TEXT_ALIGNMENT_CENTER, cc.color(0,0,0));
        lyrTech.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1,
            x: lyrTechS.x + lyrTechS.width-1,
            y: lyrTechS.y
        });
        this.addChild(lyrTech);
        this.lblExperience = lyrTech.label;
    }

});


pp.LyrPersonSubParamG = pp.LyrPersonSub.extend({

    lblOccupation: null,
    lblIncome: null,
    boxFriendliness: null,
    lblFriendlinessS: null,

    lblPlace: null,
    //lblState: null,

    lblComprehend: null,
    lblCompose: null,

    lblDextarity: null,
    lblEngineering: null,

    lblEngApt: null,
    lblEngExp: null,

    lblDrawApt: null,
    lblDrawExp: null,

    ctor: function (person) {

        this._super(res.Img_LyrPersonSub);


        var lblPlaceS = new cc.LabelTTF(__("所在"), pp.font, tm.m(__(24, 18), __(16, 12)));
        lblPlaceS.attr({
            anchorY: 0.5,
            anchorX: 0,
            x: 20,
            y: (this.height - lblPlaceS.height) * 0.9
        });
        lblPlaceS.setFontFillColor(cc.color(128,0,0));
        this.addChild(lblPlaceS);

        var boxPlace = new pp.LyrBoxedLabel("---", cc.size(tm.m(240, 170), tm.m(42, 28)), cc.TEXT_ALIGNMENT_LEFT);
        boxPlace.attr({
            ignoreAnchor: false,
            anchorY: 0.5,
            anchorX: 0,
            x: lblPlaceS.x + lblPlaceS.width + 10,
            y: lblPlaceS.y
        });
        this.lblPlace = boxPlace.label;
        this.addChild(boxPlace);

        /*
        var boxState = new pp.LyrBoxedLabel("---", cc.size(60, boxPlace.height), cc.TEXT_ALIGNMENT_CENTER);
        boxState.attr({
            ignoreAnchor: false,
            anchorY: 0.5,
            anchorX: 1,
            x: this.width - 30,
            y: lblPlaceS.y
        });
        this.addChild(boxState);
        this.lblState = boxState.label;
        */

        /*
        var lblStateS = new cc.LabelTTF("－－", pp.font, 16);
        lblStateS.attr({
            anchorY: 0.5,
            anchorX: 1,
            x: this.width - 30,
            y: boxPlace.y
        });
        lblStateS.setFontFillColor(cc.color(128,0,0));
        this.addChild(lblStateS);
        */


        var lblOccupationS = new cc.LabelTTF(__("職業"), pp.font, tm.m(__(24, 18), __(16, 12)));
        lblOccupationS.attr({
            anchorY: 0.5,
            anchorX: 0,
            x: 20,
            y: (this.height - lblOccupationS.height) * 0.75
        });
        lblOccupationS.setFontFillColor(cc.color(128,0,0));
        this.addChild(lblOccupationS);

        var boxOccupation = new pp.LyrBoxedLabel("---", cc.size(tm.m(240, 170), tm.m(42, 28)), cc.TEXT_ALIGNMENT_LEFT);
        boxOccupation.attr({
            ignoreAnchor: false,
            anchorY: 0.5,
            anchorX: 0,
            x: lblOccupationS.x + lblOccupationS.width + 10,
            y: lblOccupationS.y
        });
        this.lblOccupation = boxOccupation.label;
        this.addChild(boxOccupation);

        var boxIncome = new pp.LyrBoxedLabel("---", cc.size(tm.m(60, 40), boxOccupation.height), cc.TEXT_ALIGNMENT_RIGHT);
        boxIncome.attr({
            ignoreAnchor: false,
            anchorY: 0.5,
            anchorX: 1,
            x: this.width - 30,
            y: lblOccupationS.y
        });
        this.addChild(boxIncome);
        this.lblIncome = boxIncome.label;

        var lblIncomeS = new cc.LabelTTF(__("収入"), pp.font, tm.m(__(24, 16),__(16, 12)));
        lblIncomeS.attr({
            anchorY: 0.5,
            anchorX: 1,
            x: boxIncome.x - boxIncome.width - 10,
            y: boxOccupation.y
        });
        lblIncomeS.setFontFillColor(cc.color(128,0,0));
        this.addChild(lblIncomeS);


        var boxFriend = new pp.LyrBoxedLabel("---", cc.size(tm.m(90, 60), boxOccupation.height), cc.TEXT_ALIGNMENT_RIGHT);
        boxFriend.attr({
            ignoreAnchor: false,
            anchorY: 0,
            anchorX: 1,
            x: this.width - 30,
            y: 30
        });
        this.addChild(boxFriend);
        this.boxFriendliness = boxFriend;

        var lblFriendS = new cc.LabelTTF("友好度", pp.font, tm.m(21, 14));
        lblFriendS.attr({
            anchorY: 0.5,
            anchorX: 1,
            x: boxFriend.x - boxFriend.width - 10,
            y: boxFriend.y + boxFriend.height/2
        });
        lblFriendS.setFontFillColor(cc.color(128,0,0));
        this.addChild(lblFriendS);
        this.lblFriendlinessS = lblFriendS;

        var lyrEng = new pp.LyrSubG(pp.world.fields[pp.fdEngineering].name);
        lyrEng.attr({
            ingnoreAnchor: false,
            anchorY: 0,
            anchorX: 0,
            y: 80,
            x: (this.width - lyrEng.width) * 0.2
        });
        this.addChild(lyrEng);
        this.lblEngApt = lyrEng.lblAptitude;
        this.lblEngExp = lyrEng.lblExperience;

        var lyrDraw = new pp.LyrSubG(pp.world.fields[pp.fdDrawing].name);
        lyrDraw.attr({
            ingnoreAnchor: false,
            anchorY: 0,
            anchorX: 0,
            y: 80,
            x: (this.width - lyrDraw.width) * 0.8
        });
        this.addChild(lyrDraw);
        this.lblDrawApt = lyrDraw.lblAptitude;
        this.lblDrawExp = lyrDraw.lblExperience;

        if (person) {
            this.setPersonId(person.id);
        }
    },

    setPersonId: function (pid) {
        var person = pp.world.persons[pid];
        var occupation = pp.world.occupations[person.occupationId];
        var place = pp.world.places[person.placeId];

        this.lblOccupation.string = occupation.name;
        this.lblIncome.string = occupation.income;

        if (pp.mediator.gameState == pp.gsTurn && pp.mediator.personId != pid) {
            var player = pp.mediator.person;
            this.lblFriendlinessS.visible = true;
            this.boxFriendliness.visible = true;

            this.lblFriendlinessS.string = __(player.fullName + "との友好度", "Amity with " + player.fullName, "跟" + player.fullName + "的友好度");
            this.boxFriendliness.label.string = person.friendlinesses[player.id];
        }
        else {
            this.lblFriendlinessS.visible = false;
            this.boxFriendliness.visible = false;
        }

        this.lblPlace.string = place.name;
        //this.lblState.string = "---";

        this.lblEngExp.string = person.fieldPs[pp.fdEngineering].experience;
        this.lblEngApt.string = pp.getAptitudeStr(person.fieldPs[pp.fdEngineering].aptitude);
        this.lblDrawExp.string = person.fieldPs[pp.fdDrawing].experience;
        this.lblDrawApt.string = pp.getAptitudeStr(person.fieldPs[pp.fdDrawing].aptitude);
    }

});
