
pp.LyrThemeP = cc.LayerColor.extend({

    idx: 0,

    lblCaption: null,

    lblExperiment: null,
    lblDeduce: null,
    lblDiscovery: null,
    lblName: null,

    ctor: function (idx) {

        this._super(cc.color(0,255,0,0));

        this.setContentSize(tm.m(560, 380), tm.m(105, 70));

        this.idx = idx;

        // Static labels
        var boxData, boxDeduce, boxDisc;
        {

            boxDisc = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(
                pp.ATLAS_DISCOVERY_S, cc.color(128,0,0)), cc.size(tm.m(138, 93), tm.m(48, 32)), cc.TEXT_ALIGNMENT_LEFT);
            boxDisc.attr({
                ignoreAnchor: false,
                anchorX: 1,
                anchorY: 1,
                x: this.width,
                y: this.height
            });
            this.addChild(boxDisc);

            boxDeduce = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(
                pp.ATLAS_DEDUCE_S, cc.color(128,0,0)), cc.size(tm.m(108, 73), tm.m(48, 32)), cc.TEXT_ALIGNMENT_LEFT);
            boxDeduce.attr({
                ignoreAnchor: false,
                anchorX: 1,
                anchorY: 1,
                x: boxDisc.x - boxDisc.width+1,
                y: boxDisc.y
            });
            this.addChild(boxDeduce);

            boxData = new pp.LyrBoxedLabel(pp.createSpriteFromAtlas(
                pp.ATLAS_DATA_S, cc.color(128,0,0)), cc.size(tm.m(108, 73), tm.m(48, 32)), cc.TEXT_ALIGNMENT_LEFT);
            boxData.attr({
                ignoreAnchor: false,
                anchorX: 1,
                anchorY: 1,
                x: boxDeduce.x - boxDeduce.width+1,
                y: boxDeduce.y
            });
            this.addChild(boxData);


            var label = this.lblCaption = new cc.LabelTTF("研究テーマ", pp.font, tm.m(27, 17));
            label.attr({
                anchorX: 0,
                anchorY: 0.5,
                x: 0,
                y: boxData.y - boxData.height * boxData.anchorY/2
            });
            label.setFontFillColor(cc.color(128,0,0));
            this.addChild(label);
        }

        {
            var label = this.lblExperiment = new cc.LabelTTF("---", pp.font, tm.m(27, 17));
            label.attr({x: boxData.width - 4, y: boxData.height/2, anchorX: 1 });
            label.setFontFillColor(cc.color.BLACK);
            boxData.addChild(label);
        }

        {
            var label = this.lblDeduce = new cc.LabelTTF("---", pp.font, tm.m(27, 17));
            label.attr({x: boxDeduce.width - 4, y: boxDeduce.height/2, anchorX: 1 });
            label.setFontFillColor(cc.color.BLACK);
            boxDeduce.addChild(label);
        }

        {
            var label = this.lblDiscovery = new cc.LabelTTF("--/--", pp.font, tm.m(27, 17));
            label.attr({x: boxDisc.width - 4, y: boxDisc.height/2, anchorX: 1 });
            label.setFontFillColor(cc.color.BLACK);
            boxDisc.addChild(label);
        }

        {
            var boxName = new pp.LyrBoxedLabel("----------", cc.size(this.width, tm.m(48, 32)), cc.TEXT_ALIGNMENT_LEFT, cc.color.BLACK);
            this.lblName = boxName.label;
            boxName.attr({x: 0, y: 0, anchorX: 0, anchorY: 0 });
            this.addChild(boxName);
        }
    },

    setPerson: function (person) {

        var themeP = person.themePs[this.idx];

        if (themeP.themeId == pp.ID_INVALID) {
            this.lblExperiment.string = "---";
            this.lblDeduce.string = "---";
            this.lblDiscovery.string = "--/--";
            this.lblName.string = "----------";
        }
        else {
            var theme = pp.world.themes[themeP.themeId];
            this.lblExperiment.string = themeP.data;
            this.lblDeduce.string = themeP.deduce;
            this.lblDiscovery.string = person.getDiscoveryCountWithThemePIdx(this.idx) + " / " + theme.discoveryCount;
            this.lblName.string = theme.name;
        }
    }

});

pp.LyrPersonSubTheme = pp.LyrPersonSub.extend({

    subThemes: [ null, null, null ],

    ctor: function (person) {

        var marginY = 20;

        this._super(res.Img_LyrPersonSubSimple);

        this.subThemes = [
            new pp.LyrThemeP(0),
            new pp.LyrThemeP(1),
            new pp.LyrThemeP(2)
        ];

        for (var i = 0; i < this.subThemes.length; i++) {

            var subTheme = this.subThemes[i];
            subTheme.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 0,
                x: this.width/2,
                y: marginY + (this.height - subTheme.height - marginY*2) * (this.subThemes.length-1-i) / (this.subThemes.length-1)
            });
            subTheme.lblCaption.string = __("研究テーマ") + (tmd.language == pp.LN_JAPANESE ? tm.toWideCharNumbers(i+1) : " " + (i+1));
            this.addChild(subTheme);

            if (i != 0) {
                var spr = new tm.Scale9SpriteTiled(res.Img_ShpSeparator126x9);
                spr.setContentSize(this.width - 36, 9);
                spr.attr({
                    x: this.width/2,
                    y: subTheme.y + subTheme.height + tm.m(24, 12),
                    color: cc.color(96,64,64),
                    opacity: 128
                });
                this.addChild(spr);
            }
        }

        if (person) {
            this.setPersonId(person.id);
        }
    },

    setPersonId: function (pid) {
        var world = pp.world;
        var person = world.persons[pid];

        this.subThemes[0].setPerson(person);
        this.subThemes[1].setPerson(person);
        this.subThemes[2].setPerson(person);
    }

});
