
pp.LyrReportTabbed = cc.Layer.extend({

    tmenu: null,

    lyrReportSubs: null,
    lyrReportSubLetter: null,
    lyrReportSubParam: null,
    lyrReportSubFigure: null,

    ctor: function (reportId) {

        this._super();

        var report = pp.world.reports[reportId];
        var disc = pp.world.discoveries[report.discoveryId];

        this.width = tm.m(620, 392+20)+4;
        this.height = tm.m(470, 297+20)+2;

        // Tabbed Panel
        {
            var hasFigure = disc.type == pp.ttFigure || disc.type == pp.ttItem;

            // Tab Buttons
            {
                var options = hasFigure ? [ __("本文"), __("情報"), __("図") ] : [ __("本文"), __("情報") ];

                var tmenu = this.tmenu = new pp.MenuRect(
                    options,
                    function (item) {
                        this.setVisiblePage(item.tag);
                        //cc.log("CLICKED item.tag=" + item.tag);
                        pp.mediator.playSound(res.Snd_Click);
                    },
                    this,
                    true,
                    cc.color(148,148,48),
                    false,
                    0
                );
                tmenu.attr({
                    x: 2,
                    y: this.height
                });
                this.addChild(tmenu, 2);
            }

            // Frame
            {
                var frame = new tm.Scale9SpriteTiled(res.Img_FrmSimple256x256);
                frame.setContentSize(this.width-4, this.height-2);
                frame.attr({
                    ignoreAnchor: true,
                    x: 3,
                    y: 2
                });
                this.addChild(frame, 1);

                // Tabbed Panels
                var lyr = this.lyrReportSubLetter =
                    new pp.LyrLetter(
                        report.getTitle(),
                        report.getBody(),
                        report.getComposedDateStr(),
                        report.personId
                    );
                lyr.attr({
                    x: 10,
                    y: 10
                });
                frame.addChild(lyr, 2);

                var keyValues = {};
                keyValues[__("作　　者")] = report.getPerson().getFullName();
                keyValues[__("種　　別")] = disc.getTypeName();
                keyValues[__("題　　名")] = report.getTitle();
                keyValues[__("完 成 度")] = report.getCredibilityStr();
                keyValues[__("受理日付")] = report.getAcceptDateStr();
                keyValues[__("受理組織")] = report.getSocietyName();
                keyValues[__("支 持 率")] = report.getBackingStr();

                var lyr = this.lyrReportSubParam = new pp.LyrKeyValues(
                    keyValues
                    /*
                    {
                        "作　　者" : report.getPerson().getFullName(),
                        "種　　別" : disc.getTypeName(),
                        "題　　名" : report.getTitle(),
                        "完 成 度" : report.getCredibilityStr(),
                        "受理日付" : report.getAcceptDateStr(),
                        "受理組織" : report.getSocietyName(),
                        "支 持 率" : report.getBackingStr()
                    }
                    */
                );
                lyr.attr({
                    ignoreAnchor: false,
                    x: frame.width/2,
                    y: frame.height/2
                });
                frame.addChild(lyr, 2);

                if (hasFigure) {
                    var path;
                    var blendFunc = null;
                    if (disc.type == pp.ttItem) {
                        var item = pp.world.items[disc.itemId];
                        path = item.picture;
                    }
                    else {
                        path = disc.getFigurePath(report.credibility < 70);
                        blendFunc = new cc.BlendFunc(cc.ZERO, cc.SRC_COLOR);
                    }
                    var lyr = new pp.LyrDetailImage(path, blendFunc, tm.m(1.5, 1));
                    lyr.attr({
                        ignoreAnchor: false,
                        x: frame.width/2,
                        y: frame.height/2
                    });
                    frame.addChild(lyr, 2);
                    this.lyrReportSubFigure = lyr;
                }

                this.lyrReportSubs = [
                    this.lyrReportSubLetter,
                    this.lyrReportSubParam
                ];

                if (hasFigure) {
                    this.lyrReportSubs.push(
                        this.lyrReportSubFigure
                    );
                };

                this.setSelectedIndex(hasFigure ? 2 : 0);
            }

            this.height += this.tmenu.height;
        }
    },

    setSelectedIndex: function (idx) {
        this.setVisiblePage(idx);
        this.tmenu.setSelectedIndex(idx);
    },

    setVisiblePage: function (idx) {

        this.tmenu.setSelectedIndex(idx);

        for (var i = 0; i < this.lyrReportSubs.length; i++) {
            this.lyrReportSubs[i].visible = idx == i;
        }
    }

});
