
pp.LyrThankYou = cc.Layer.extend({

    ctor: function (personId) {

        this._super();

        var spr = new cc.Sprite(res.Img_LyrThankYou);

        spr.attr({
            anchorX: 0,
            anchorY: 0,
            scale: tm.m(1.5, 1)
        });
        this.addChild(spr, 1);

        this.setContentSize(spr.width * spr.scaleX, spr.height * spr.scaleY);

        var strKeys = "";
        var strValues = "";
        var person = pp.world.persons[personId];
        var societyName = "---";
        var jobName = "---";
        var knighthoodName = "---";

        if (person.societyId != pp.idInvalid) {
            var society = pp.world.societies[person.societyId];
            societyName = society.name;
            switch(person.jobIdx) {
                case 0: jobName = society.jobName0; break;
                case 1: jobName = society.jobName1; break;
                case 2: jobName = society.jobName2; break;
            }
        }

        knighthoodName = person.getKnighthoodName("---");

        strKeys += __("科学者名") + ": \n";
        strKeys += __("日付") + ": \n";
        strKeys += __("所属組織") + ": \n";
        strKeys += __("役職") + ": \n";
        strKeys += __("職業") + ": \n";
        strKeys += __("勲爵") + ": \n";
        strKeys += __("名声") + ": \n";

        strValues += "" + person.name + "\n";
        strValues += "" + pp.mediator.getDateString() + "\n";
        strValues += "" + societyName + "\n";
        strValues += "" + jobName + "\n";
        strValues += "" + pp.world.occupations[person.occupationId].name + "\n";
        strValues += "" + knighthoodName + "\n";
        strValues += "" + person.fame + "\n";

        var lblKeys = new cc.LabelTTF(strKeys, pp.font, tm.m(28, tm.p(20,20,__(16, 12))));
        lblKeys.attr({
            anchorX: 1,
            x: this.width * 0.4, //@@@
            y: tm.m(380, 250),
            textAlign: cc.TEXT_ALIGNMENT_RIGHT
        });
        lblKeys.setFontFillColor(cc.color.BLACK);
        //lbl.enableStroke(cc.color.BLACK, 2);

        var lblValues = new cc.LabelTTF(strValues, pp.font, tm.m(28, tm.p(20,20,__(16, 12))));
        lblValues.attr({
            anchorX: 0,
            x: lblKeys.x,
            y: lblKeys.y,
            textAlign: cc.TEXT_ALIGNMENT_LEFT
        });
        lblValues.setFontFillColor(cc.color.BLACK);
        //lbl.enableStroke(cc.color.BLACK, 2);

        this.addChild(lblKeys, 2);
        this.addChild(lblValues, 2);
    }

});
