
pp.LyrTheme = cc.Layer.extend({

    mnuDiscs: null,
    themeId: 0,

    ctor: function (themeId) {

        this._super();

        this.mnuDiscs = null;
        this.themeId = themeId;

        this.setContentSize(tm.m(600, 800), tm.m(900, 380));

        var theme = pp.world.themes[themeId];
        var field = pp.world.fields[theme.fieldId];

        var person = theme.getAuthorityPerson();

        var persons = theme.getWorkingPersons();

        var mnuPersons = new cc.Menu();
        mnuPersons.attr({
            ignoreAnchor: false
        });
        this.addChild(mnuPersons);

        {
            var lbl = new tm.LabelTTF("【" + __("分野") + "】" + field.name, pp.font, tm.m(27, 18), cc.color.BLACK, cc.color.YELLOW);
            lbl.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(this.width/2, 0),
                y: this.height + tm.p(0,0,4)
            });
            lbl.setFontFillColor(cc.color.YELLOW);
            this.addChild(lbl);
        }

        {
            var iconIdx = theme.fieldId;
            if (theme.fieldId == pp.fdImportant) iconIdx = 7;

            var sprField = pp.createSpriteFromAtlas(pp.ATLAS_ASTRO + iconIdx);
            sprField.attr({
                ignoreAnchor: false,
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(this.width/2, 10),
                y: this.height - tm.m(40, 20),
                scale: tm.m(2, 1)
            });
            this.addChild(sprField);
        }

        // Authority Person
        {
            var name = person ? person.fullName : "－－－－";
            var lbl = new tm.LabelTTF("【" + __("テーマ権威") + "】" + name, pp.font, tm.m(27, 18), cc.color.BLACK, cc.color.YELLOW);
            lbl.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(this.width/2, 0),
                y: this.height - tm.m(140, 100) + tm.p(0,0,4)
            });
            lbl.setFontFillColor(cc.color.YELLOW);
            this.addChild(lbl);
        }

        var sprFace;
        if (person)
        {
            var sprFace = new cc.Sprite(person.imageFileName);
            sprFace.attr({ });
            var sprFace2 = new cc.Sprite(person.imageFileName);
            sprFace2.attr({ x: 2*2, y: -2*2 });
            var itmFace = new cc.MenuItemSprite(sprFace, sprFace2, function (obj) {
                pp.mediator.playSound(res.Snd_Click);

                pp.mediator.scn.addChild(new pp.PopPerson(obj.tag), 100);
            }, this);
            itmFace.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                scale: 1/2,
                x: tm.m(this.width/2, 10),
                y: this.height - tm.m(170, 120),
                tag: person.id
            });
            mnuPersons.addChild(itmFace);
        }

        // Working persons
        {
            var lbl = new tm.LabelTTF("【" + __("取り組んでいる科学者", "Scientists Interested", "科学者") + "】" + persons.length + __(" 人", ""), pp.font, tm.m(27, 18), cc.color.BLACK, cc.color.YELLOW);
            lbl.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(this.width/2, 0),
                y: this.height - tm.m(260, 200) + tm.p(0,0,4)
            });
            lbl.setFontFillColor(cc.color.YELLOW);
            this.addChild(lbl);
        }

        {
            for (var i = 0; i < persons.length; i++) {
                var aPerson = persons[i];

                var sprFace = new cc.Sprite(aPerson.imageFileName);
                sprFace.attr({ });
                var sprFace2 = new cc.Sprite(aPerson.imageFileName);
                sprFace2.attr({ x: 2*3, y: -2*3 });
                var itmFace = new cc.MenuItemSprite(sprFace, sprFace2, function (obj) {
                    pp.mediator.playSound(res.Snd_Click);

                    pp.mediator.scn.addChild(new pp.PopPerson(obj.tag), 100);
                }, this);
                itmFace.attr({
                    anchorX: tm.m(0.5, 0),
                    anchorY: 1,
                    scale: 1/3,
                    x: tm.m(this.width/2 + 32 * i - (persons.length-1)*16, 10 + 32 * i),
                    y: this.height - tm.m(290, 220),
                    tag: aPerson.id
                });
                mnuPersons.addChild(itmFace);
            }
        }

        var discNums = this.updateDiscMenu();
        var discNum = discNums[1];
        var restDiscNum = discNums[0];

        // Discoveries
        {
            var lbl = new tm.LabelTTF("【" + __("関連発見", "Related Discoveries", "有关发现") + "】" + discNum + " (" + __("残り", "Remaining", "剩下") + ": " + restDiscNum + ")", pp.font, tm.m(27, 18), cc.color.BLACK, cc.color.YELLOW);
            lbl.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 0,
                x: tm.m(this.width/2, 0),
                y: tm.m(90, 74)
            });
            lbl.setFontFillColor(cc.color.YELLOW);
            this.addChild(lbl);
        }

        // Description
        var lyrDesc;
        {
            var lyrDesc = new pp.LyrDescription(theme.description, cc.size(tm.m(500, 320+50), tm.m(400, 300)));
            lyrDesc.attr({
                ignoreAnchor: false,
                anchorX: tm.m(0.5, 1),
                anchorY: 1,
                x: tm.m(this.width / 2, this.width),
                y: tm.m(this.height - 350, this.height - 0)
            });
            this.addChild(lyrDesc);
        }
    },


    updateDiscMenu: function () {

        var discNum;
        var restDiscNum = 0;

        if (this.mnuDiscs) {
            this.mnuDiscs.removeFromParent();
            this.mnuDiscs = null;
        }

        var spsDiscs = [];
        var enableds = [];
        var ids = [];

        {
            var theme = pp.world.themes[this.themeId];
            //var field = pp.world.fields[theme.fieldId];

            var discs = theme.getDiscoveries();

            discNum = discs.length;

            for (var i = 0; i < discs.length; i++) {
                var disc = discs[i];
                var sp;
                var enabled;

                var reportId = disc.getReleasedReportId();

                if (reportId == pp.idInvalid) {
                    // before noticing
                    sp = [];

                    switch (disc.type) {
                        case pp.ttTheory:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_THEORY));
                            break;
                        case pp.ttItem:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_ITEM));
                            break;
                        case pp.ttFigure:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_FIGURE));
                            break;
                        case pp.ttThing:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_THING));
                            break;
                        case pp.ttBook:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_BOOK));
                            break;
                    }

                    enabled = false;
                    //sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_QUESTION));

                    restDiscNum++;
                }
                else {
                    sp = [];
                    enabled = true;

                    switch (disc.type) {
                        case pp.ttTheory:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_THEORY));
                            break;
                        case pp.ttItem:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_ITEM));
                            break;
                        case pp.ttFigure:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_FIGURE));
                            break;
                        case pp.ttThing:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_THING));
                            break;
                        case pp.ttBook:
                            sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_BOOK));
                            break;
                    }

                    //var report = pp.world.reports[reportId];
                    //sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*1, 32*1, 32, 32)));
                    sp.push(pp.createSpriteFrameFromAtlas(pp.ATLAS_REPORT_RELEASED));
                }

                spsDiscs.push(sp);
                ids.push(disc.id);
                enableds.push(enabled);
            }
        }

        //    ctor: function (icons, callback, target, tint, isVertical, span, scale, iconScale) {

        var mnuDiscs = new pp.Menu(
            spsDiscs,
            function (obj) {
                pp.mediator.playSound(res.Snd_Click);

                var discId = ids[obj.tag];
                var disc = pp.world.discoveries[discId];
                var reportId = disc.getReleasedReportId();

                pp.mediator.scn.addChild(new pp.PopDetailReport(reportId), 100);
            },
            this,
        null,
        null,
        0,
        tm.m(1.2, 1));
        mnuDiscs.attr({
            anchorX: 0,
            anchorY: 0,
            x: tm.m(-5, 10),
            y: 0
        });
        for (var i = 0; i < enableds.length; i++) {
            mnuDiscs.enableItem(i, enableds[i]);
        };
        this.addChild(mnuDiscs);
        this.mnuDiscs = mnuDiscs;

        return [ restDiscNum, discNum ];
    }

});
