
pp.LyrThemeSelection = tm.Scale9SpriteTiled.extend({

    authorityId: 0,

    ctor: function (personId, themeId, callback, target, unlocked, xBtnMag) {

        xBtnMag = xBtnMag || 2;

        var person = pp.world.persons[personId];
        var selected = false;
        for (var i = 0; i < person.themePs.length; i++) {
            if (themeId == person.themePs[i].themeId) {
                selected = true;
                break;
            }
        }

        this.unlocked = false;

        this._super(res.Img_ListHeader);

        this.setContentSize(tm.m(152, 92) + tm.m(175, 100) * xBtnMag, tm.m(88, 50));
        this.attr({
            ignoreAnchor: true
        });

        var theme = pp.world.themes[themeId];

        var iconIdx = theme.fieldId;
        if (theme.fieldId == pp.fdImportant) iconIdx = 7;

        var sprTheme = pp.createSpriteFromAtlas(pp.ATLAS_ASTRO + iconIdx);
        sprTheme.attr({
            anchorX: 0.5,
            anchorY: 0.5,
            x: tm.m(78, 54) + sprTheme.width/tm.m(1, 2),
            y: this.height/2,
            scale: tm.m(2, 1)
        });
        this.addChild(sprTheme);

        var auPerson = theme.getAuthorityPerson();
        if (auPerson) {
            var scl = tm.m(0.5, 0.3);
            var sprFace = new cc.Sprite(auPerson.imageFileName);
            sprFace.attr({ });
            var sprFace2 = new cc.Sprite(auPerson.imageFileName);
            sprFace2.attr({ x: 2/scl, y: -2/scl });
            var itmFace = new cc.MenuItemSprite(sprFace, sprFace2, function (obj) {
                pp.mediator.playSound(res.Snd_Click);

                pp.mediator.scn.addChild(new pp.PopPerson(obj.tag), 100);
            }, this);
            itmFace.attr({
                scale: scl,
                x: tm.m(27, 22)+sprFace.width/tm.m(2,3)/2,
                y: this.height/2,
                tag: auPerson.id
            });
            var menu = new cc.Menu();
            menu.addChild(itmFace);
            menu.attr({
                ignoreAnchor: false
            });
            this.addChild(menu);
        }
        this.authorityId = auPerson ? auPerson.id : pp.idInvalid;

        var str = theme.name;
        if (!unlocked) {
            if (theme.fieldId == pp.fdImportant) {
                str = "？？？？";
            }
            else {
                str = "(" + __("必要知識") + ": " + theme.knowledge + ")";
            }
        }
        var menu = new pp.MenuRect(
            [ str ],
            function (obj) {
                callback.call(target, themeId);
            },
            target,
            null,
            null,
            null,
            null,
            xBtnMag, //xMag
            theme.getCompleteRatio(person.id), // barVal
            false, // isFlat
            __(16, 14) // fontSize
        );
        menu.attr({
            ignoreAnchor: false,
            anchorX: 1,
            anchorY: 0.5,
            x: this.width-4,
            y: this.height/2
        });
        if (!unlocked) {
            menu.disableItem(0);
        }
        this.addChild(menu);

        // Pointer on left
        {
            var sprEmpty = new cc.Scale9Sprite(res.Img_Pointer16x32_4, cc.rect(16*0,0,16,32));
            sprEmpty.setContentSize(16, tm.m(64, 32));
            sprEmpty.attr({
                anchorX: 0,
                anchorY: 0.5,
                x: tm.m(10, 6),
                y: this.height/2
            });
            this.addChild(sprEmpty);
            if (selected) {
                var spr = new cc.Scale9Sprite(res.Img_Pointer16x32_4, cc.rect(16*2,0,16,32));
                spr.setContentSize(16, tm.m(64, 32));
                spr.attr({
                    anchorX: 0,
                    anchorY: 0
                });
                sprEmpty.addChild(spr);
                spr.runAction(
                    tm.repeatForever(
                        cc.fadeTo(0.01, 255),
                        cc.delayTime(0.59),
                        cc.fadeTo(0.01, 1),
                        cc.delayTime(0.19)
                    )
                );
            }
        }
    }

});

//----------------------------------------------------------------------

pp.FrmField = pp.Frm.extend({

    lyrThemeCaption: null,
    frmPager: null,

    fieldId: 0,

    callback: null,
    target: null,

    authorityCount: 0,

    ctor: function (personId, fieldId, callback, target, forceUnlock) {

        this._super(res.Img_FrmSimple256x256);

        this.ignoreAnchor = false;

        this.fieldId = fieldId;
        this.callback = callback;
        this.target = target;

        this.authorityCount = 0;

        var person = pp.world.persons[personId];

        var fieldName;
        var field;

        if (fieldId == pp.idInvalid) {
            fieldName = pp.world.fields[pp.fdImportant].name;
            field = pp.world.fields[pp.fdImportant];
            //this.setContentSize(800+44*3, 100);
            this.setContentSize(tm.m(730, 600), tm.m(130, 100));
        }
        else {
            fieldName = pp.world.fields[fieldId].name;
            field = pp.world.fields[fieldId];
            this.setContentSize(tm.m(600, 316), tm.m(440, 254));
        }

        // Caption
        if (fieldId != pp.idInvalid)
        {
            var lbl = new tm.LabelTTF(fieldName, pp.font, tm.m(30, 20), cc.color.BLACK, cc.color.YELLOW, 1);
            lbl.attr({
                anchorX: 0.5,
                anchorY: 1,
                x: this.width/2,
                y: this.height - tm.m(16, 12) + tm.p(0,0,2)
            });
            this.addChild(lbl);
        }

        // Themes
        {
            var themes = field.getThemes();
            themes.sort(function (t1, t2) {
                return t1.knowledge - t2.knowledge;
            });

            if (fieldId == pp.idInvalid) {

                for (var i = 0; i < 1; i++) {

                    var theme = themes[i];

                    var lyrThemeSel = new pp.LyrThemeSelection(personId, theme.id, callback, target, forceUnlock, 3.1);
                    lyrThemeSel.attr({
                        ignoreAnchor: false,
                        x: this.width * (0.18 + 0.32 * (i+1)),
                        y: this.height / 2
                    });
                    this.addChild(lyrThemeSel);

                    if (lyrThemeSel.authorityId == personId)
                        this.authorityCount++;
                }
            }
            else {

                for (var i = 0; i < 4 && i < themes.length; i++) {

                    var theme = themes[i];

                    var lyrThemeSel = new pp.LyrThemeSelection(personId, theme.id, callback, target, forceUnlock || theme.isUnlocked(person.id));
                    lyrThemeSel.attr({
                        ignoreAnchor: false,
                        x: this.width / 2,
                        y: this.height - tm.m(100, 60) - (lyrThemeSel.height + 2) * i
                    });
                    this.addChild(lyrThemeSel);

                    if (lyrThemeSel.authorityId == personId)
                        this.authorityCount++;
                }
            }
        }
    }

});

//----------------------------------------------------------------------

pp.LyrThemeMap = cc.Layer.extend({

    ctor: function (personId, callback, target) {

        this._super();

        var authorityCount = 0;
        var isAuthorities = new Array(6);

        if (tm.m()) {
            this.setContentSize(cc.winSize.width / 0.6, cc.winSize.height / 0.6 - 335 - pp.LYR_STATUS_BAR_HEIGHT);

            //var lyr = new cc.LayerColor(cc.color(255,0,0,128), this.width, this.height);
            //this.addChild(lyr);
        }

        // Field Frames
        {
            var NX = tm.m(2, 3);
            var NY = tm.m(3, 2);
            for (var iy = 0; iy < NY; iy++) {
                for (var ix = 0; ix < NX; ix++) {

                    var fieldId = ix + iy * NX;
                    var frmField = new pp.FrmField(personId, fieldId, callback, target, pp.mediator.isCheckingText);
                    frmField.attr({
                        ignoreAnchor: false,
                        anchorX: 0.5,
                        anchorY: 0.5,
                        x: this.width * tm.m(0.25 + 0.5 * ix , 0.17 + 0.33 * ix),
                        y: this.height * tm.m(0.2 + 0.275 * (NY - 1 - iy), 0.25 + 0.5 * (NY - 1 - iy)) + tm.m(0, -32)
                    });
                    this.addChild(frmField);

                    authorityCount += frmField.authorityCount;
                    isAuthorities[fieldId] = frmField.authorityCount > 0;
                }
            }
        }

        // Final Theme
        {
            var isUnlocked =
                (authorityCount >= 5 && isAuthorities[pp.fdAstronomy] && isAuthorities[pp.fdMechanics] && isAuthorities[pp.fdMathematics])
                || authorityCount >= 8
                || pp.mediator.isCheckingText;

            var frmField = new pp.FrmField(personId, pp.idInvalid, callback, target, isUnlocked);
            frmField.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 0.5,
                x: this.width / 2,
                y: tm.m(1763 - pp.LYR_STATUS_BAR_HEIGHT/0.7142, this.height / 2 - 32)
            });
            this.addChild(frmField);
        }
    }

});
