
pp.Menu = cc.Node.extend({

    items: null,
    menu: null,

    createMenuItem: function (tint, icon, callback, target, scale, iconScale) {

        var createSpriteForMenuItem = function (tint, icon, iconOpacity, scale, iconScale) {

            //magnitude = magnitude || 1;

            var widthToUse;
            var heightToUse;
            var spr = new cc.Scale9Sprite(res.Img_BtnEmpty);
            widthToUse = spr.width * scale;
            heightToUse = spr.height * scale;
            spr.setContentSize(widthToUse, heightToUse);

            spr.setColor(tint);
            spr.setCascadeColorEnabled(false);//@@@

            //@@@
            /*
            spr.runAction(
                cc.repeatForever(cc.sequence(
                    cc.fadeTo(0.2, 64),
                    cc.delayTime(0.1),
                    cc.fadeTo(0.2, 255),
                    cc.delayTime(0.4)
                ))
            );
            */

            {
                var sprBaseBright = new cc.Scale9Sprite(res.Img_BtnBaseBright);
                sprBaseBright.ignoreAnchor = true;
                sprBaseBright.setContentSize(widthToUse, heightToUse);
                spr.addChild(sprBaseBright, 1);
            }

            if (icon) {
                var icons;
                if (cc.isArray(icon) == false) {
                    icons = [icon];
                }
                else {
                    icons = icon;
                }
                for (var i = 0; i < icons.length; i++) {
                    var icon = icons[i];
                    var sprIcon = new cc.Sprite(icon);
                    sprIcon.attr({
                        x: spr.width/2,
                        y: spr.height/2,
                        scale: iconScale
                    });
                    //sprIcon.getTexture().setAliasTexParameters();
                    //sprIcon.ignoreAnchor = true;

                    sprIcon.opacity = iconOpacity ? iconOpacity : 255;
                    spr.addChild(sprIcon, 2);
                }
            }

            {
                var sprBright = new cc.Scale9Sprite(res.Img_BtnBright);
                sprBright.ignoreAnchor = true;
                sprBright.setContentSize(widthToUse, heightToUse);
                spr.addChild(sprBright, 3);
            }

            return spr;
        };

        var sprUp = createSpriteForMenuItem(tint, icon, 255, scale, iconScale);
        var sprDown = createSpriteForMenuItem(tint, icon, 255, scale, iconScale);
        sprDown.attr({ x: 2, y: -2 });
        var sprDim = createSpriteForMenuItem(cc.color(127,127,127), icon, 127, scale, iconScale);

        return new cc.MenuItemSprite(
            sprUp,
            sprDown,
            sprDim,
            callback,
            target
        );
    },

    ctor: function (icons, callback, target, tint, isVertical, span, scale, iconScale) {

        span = span || 0;
        scale = scale || tm.m(1.5, 1);
        iconScale = iconScale || tm.m(1, 1);

        var margin = (64 + span) * scale;

        this._super();

        tint = tint || cc.color(48,48,148);

        var width;
        var height;

        // Buttons
        {
            // Button Frames
            {
                for (var i = 0; i < icons.length; i++) {
                    var spr = new cc.Scale9Sprite(res.Img_BtnFrame);
                    spr.attr({
                        x: 0 + (isVertical ? 0 : i * margin),
                        y: 0 + (isVertical ? i * margin : 0),
                        ignoreAnchor: true
                    });
                    spr.setContentSize(spr.width*scale, spr.height*scale);
                    this.addChild(spr, 3);

                    var spr = new cc.Scale9Sprite(res.Img_BtnBase);
                    spr.attr({
                        x: 0 + (isVertical ? 0 : i * margin),
                        y: 0 + (isVertical ? i * margin : 0),
                        ignoreAnchor: true
                    });
                    spr.setContentSize(spr.width*scale, spr.height*scale);
                    this.addChild(spr, 1);

                    if (i == 0) {
                        width = spr.width;
                        height = spr.height;
                    }
                }
            }

            // Menu with Buttons
            {
                var menu = this.menu = new cc.Menu();
                menu.attr({ x: 0, y: 0 });
                this.addChild(menu, 2);

                this.items = [];

                for (var i = 0; i < icons.length; i++) {
                    var item = this.createMenuItem(tint, icons[i], callback, target, scale, iconScale);
                    item.attr({
                        x: 0 + (isVertical ? 0 : i * margin),
                        y: 0 + (isVertical ? i * margin : 0),
                        ignoreAnchor: true
                    });
                    //item.enabled = (icons[i] != null);
                    item.tag = i;
                    menu.addChild(item);

                    this.items.push(item);
                }
            }

        }

        this.width = isVertical ? width : (width + span) * icons.length - span;
        this.height = isVertical ? (height + span) * icons.length - span : height;

    },

    enableItem: function (i, val) {
        if (i < -1 || i >= this.items.length) return;
        val = val == null ? true : val;
        this.items[i].setEnabled(val);
    },

    disableItem: function (i) {
        this.enableItem(i, false);
    },

    setEnabled: function (enabled) {
        this.menu.setEnabled(enabled);
    }

});
