
pp.MenuSmall = cc.Node.extend({

    menu: null,
    items: [],

    createMenuItem: function (string, callback, target, rotation) {

        var createSpriteForMenuItem = function (string, rotation) {

            var spr = new cc.Scale9Sprite(res.Img_BtnEmptyS);
            spr.setContentSize(spr.width * tm.m(1.5, 1), spr.height * tm.m(1.5, 1));

            var rotation = rotation || 0;

            var label = new tm.LabelTTF(string, pp.font, tm.m(21, 14), cc.color.BLACK, cc.color.WHITE, 2);
            label.attr({x: spr.width/2, y: spr.height/2, anchorY: 0.5, anchorX: 0.5, textAlign: cc.TEXT_ALIGNMENT_CENTER});
            label.rotation = rotation;
            spr.addChild(label, 2);

            return spr;
        };

        var sprUp = createSpriteForMenuItem(string, rotation);
        var sprDown = createSpriteForMenuItem(string, rotation);
        sprDown.attr({x: 2, y: -2});

        return new cc.MenuItemSprite(
            sprUp,
            sprDown,
            callback,
            target
        );
    },

    ctor: function (strings, callback, target, rotations, isVertical) {

        var margin = 56;

        this._super();

        // Buttons
        {
            var width;
            var height;

            // Button Frames
            {
                for (var i = 0; i < strings.length; i++) {
                    var spr = new cc.Scale9Sprite(res.Img_BtnFrameS);
                    spr.attr({
                        x: isVertical ? 0 : i * margin,
                        y: isVertical ? (strings.length - 1 - i) * margin : 0,
                        ignoreAnchor: true
                    });
                    this.addChild(spr, 3);

                    spr.setContentSize(spr.width * tm.m(1.5, 1), spr.height * tm.m(1.5, 1));

                    width = spr.width;
                    height = spr.height;
                }
            }

            // Menu with Buttons
            {
                var menu = this.menu = new cc.Menu();
                menu.attr({ x: 0, y: 0 });
                this.addChild(menu, 2);

                this.items = [];

                for (var i = 0; i < strings.length; i++) {
                    var item = this.createMenuItem(strings[i], callback, target, cc.isArray(rotations) ? rotations[i] : null);
                    item.attr({
                        x: isVertical ? 0 : i * margin,
                        y: isVertical ? (strings.length - 1 - i) * margin : 0,
                        ignoreAnchor: true
                    });

                    item.tag = i;
                    menu.addChild(item);
                    this.items.push(item);
                }
            }
        }

        this.width = isVertical ? width : width * strings.length;
        this.height = isVertical ? height * strings.length : height;
    },

    setEnabled: function (enabled) {
        this.menu.setEnabled(enabled);
    }

});
