
pp.POP_LISTM_MARGIN_X = 80;
pp.POP_LISTM_ROW_HEIGHT = 80;
pp.POP_LISTM_MAX_SCR_VIEW_HEIGHT = 800;

pp.PopListSelect = pp.PopListSelect || pp.Pop.extend({

    headerStrings: null,
    colWidths: null,
    textAligns: null,

    selectedIdx: 0,
    selectedTime: 0,
    sprOptionsss: null,
    sprHeaderss: null,
    sprImages: null,
    sortingCol: 0,
    sortingPageIdx: 0,
    isSortDescend: true,
    sprTriangle: null,
    stringsss: null,
    idxImage: 0,
    pageImage: 0,

    scrViews: null,
    lyrPages: null,
    lyrBackground: null,
    selectedPage: 0,

    nodListening: null,
    myTouchPos: null,

    mnuPage: null,

    buildPage: function (pageIdx, headerStrings, colWidths, textAligns, aStringss) {

        var sprOptionss = [];
        var sprHeaders = [];
        var stringss = [];
        var images = [];
        var hasImage = this.pageImage == pageIdx;

        this.selectedIdx = pp.idxInvalid;
        this.isSortDescend = true;

        var lyrPage = new cc.LayerColor(cc.color(32,32,32));

        //var scrContent = new cc.LayerColor(cc.color.RED);
        var scrContent = new tm.Scale9SpriteTiled(res.Img_LyrDetailImage);

        //cc.log("buildPage called. pageIdx=" + pageIdx);

        var scrView = new pp.ScrollView();

        scrView.direction = cc.SCROLLVIEW_DIRECTION_VERTICAL;

        var scrContentWidth = cc.winSize.width - pp.POP_LISTM_MARGIN_X * 2;

        var hasScrollBar = pp.POP_LISTM_ROW_HEIGHT * aStringss.length > pp.POP_LISTM_MAX_SCR_VIEW_HEIGHT;

        scrContent.setContentSize(scrContentWidth, pp.POP_LISTM_ROW_HEIGHT * aStringss.length);

        scrView.setContainer(scrContent);
        scrView.setViewSize(cc.size(scrContent.width, tm.min(scrContent.height, pp.POP_LISTM_MAX_SCR_VIEW_HEIGHT)));
        lyrPage.attr({
            width: scrContentWidth + (hasScrollBar ? pp.SCR_BAR_WIDTH : 0),
            height: scrView.getViewSize().height
        });

        if (hasScrollBar) {
            var scrBarRail = new pp.ScrorllBar(scrView);
            scrBarRail.attr({
                x: lyrPage.width,
                y: lyrPage.height// - pp.POP_LISTM_ROW_HEIGHT
            });
            lyrPage.addChild(scrBarRail);
        }

        var y0 = scrContent.height;// + pp.POP_LISTM_ROW_HEIGHT;
        for (var iy = 0; iy < aStringss.length; iy++) {
            var strings = aStringss[iy];

            sprOptionss.push([]);
            stringss.push([]);

            for (var ix = 0; ix < strings.length; ix++) {
                var string = "" + strings[ix];
                stringss[iy].push(string);
            }

            var ix = 0;
            {
                var string = "" + strings[0];
                var string2 = "";

                for (var i = 1; i < strings.length; i++) {
                    var headerStr = headerStrings[i];

                    if (headerStr != "image") {
                        if (i != 1) string2 += " / ";
                        string2 += headerStr + ": " + strings[i];
                    }
                }

                var lbl = new tm.LabelTTF(string, pp.font, __(27, 21));
                var lbl2 = new tm.LabelTTF(string2, pp.font, __(18, 14));

                sprOptionss[iy].push(lbl);
                sprOptionss[iy].push(lbl2);
                stringss[iy].push(string2);

                var spr2 = new cc.Scale9Sprite(res.Img_ListCell);
                spr2.ignoreAnchor = true;
                spr2.setContentSize(scrContentWidth, pp.POP_LISTM_ROW_HEIGHT);

                var spr = new cc.LayerColor(cc.color.RED);
                spr.addChild(spr2);

                spr.attr({
                    ignoreAnchor: false,
                    x: 0,
                    y: y0,
                    anchorX: 0,
                    anchorY: 1,
                    opacity: 1
                });
                spr.setContentSize(scrContentWidth, pp.POP_LISTM_ROW_HEIGHT);
                spr.setCascadeColorEnabled(false);

                lbl.attr({
                    anchorX: 0,
                    anchorY: 1,
                    x: hasImage ? 92 : 12,
                    y: spr.height - 12
                });
                lbl.setFontFillColor(cc.color(32,32,32));
                spr.addChild(lbl);

                lbl2.attr({
                    anchorX: 0,
                    anchorY: 0,
                    x: hasImage ? 92 : 12,
                    y: 12
                });
                lbl2.setFontFillColor(cc.color(32,32,32));
                spr.addChild(lbl2);

                scrContent.addChild(spr);
                sprOptionss[iy].push(spr);
            }

            y0 -= pp.POP_LISTM_ROW_HEIGHT;

            stringss[iy].push(iy); // for focusedRealIdx
        }

        lyrPage.addChild(scrView);
        scrView.setContentOffset(scrView.minContainerOffset());

        this.sprHeaderss.push(sprHeaders);
        this.sprOptionsss.push(sprOptionss);
        this.stringsss.push(stringss);
        this.scrViews.push(scrView);

        return lyrPage;
    },

    updateImages: function () {

        if (this.pageImage == pp.idxInvalid)
            return;

        var iPage = this.pageImage;
        var iImage = this.idxImage;

        var stringss = this.stringsss[iPage];
        var sprOptionss = this.sprOptionsss[iPage];

        if (cc.isArray(this.sprImages)) {
            for (var i = 0; i < this.sprImages.length; i++) {
                this.sprImages[i].removeFromParent();
            }
        }
        this.sprImages = [];

        for (var iy = 0; iy < stringss.length; iy++) {
            var strImage = stringss[iy][iImage];

            var spr = sprOptionss[iy][0].getParent();
            var sprTmp = new cc.Sprite(strImage);
            var sprImage = new cc.Sprite(sprTmp.getTexture(), cc.rect(0,(sprTmp.height-sprTmp.width)/2,sprTmp.width,sprTmp.width));
            sprImage.attr({
                scale: 64 / sprImage.width,
                anchorX: 0,
                anchorY: 0.5,
                x: 12,
                y: spr.height/2
            });
            spr.addChild(sprImage);
            this.sprImages.push(sprImage);
        }
    },

    ctor: function (headerStrings, colWidths, textAligns, stringss, caption, callback, target, backOpacity, allowOverlap) {

        this._name = "PopListSelect";

        this.sprOptionsss = [];
        this.stringsss = [];
        this.sprHeaderss = [];
        this.lyrPages = [];
        this.scrViews = [];
        this.sortingColIdx = pp.idxInvalid;
        this.sortingPageIdx = pp.idxInvalid;
        this.sprImages = [];

        this.idxImage = pp.idxInvalid;
        this.pageImage = pp.idxInvalid;

        if (!cc.isArray(headerStrings[0])) {

            headerStrings = [headerStrings, ["A"]];
            colWidths = [colWidths];
            textAligns = [textAligns];
            stringss = [stringss];
        }

        for (var ip = 0; ip < headerStrings.length; ip++) {
            for (var ix = 0; ix < headerStrings[ip].length; ix++) {
                if (headerStrings[ip][ix] == "image") {
                    this.idxImage = ix;
                    this.pageImage = ip;
                    ip = headerStrings.length;
                    break;
                }
            }
        }

        var maxWidth = 0;
        var maxHeight = 0;
        var lyrBackground = new cc.Layer();
        for (var iPage = 0; iPage < 1 /*colWidths.length*/; iPage++) {

            var lyrPage = this.buildPage(iPage, headerStrings[iPage], colWidths[iPage], textAligns[iPage], stringss[iPage]);

            maxWidth = tm.max(maxWidth, lyrPage.width);
            maxHeight = tm.max(maxHeight, lyrPage.height);

            lyrBackground.addChild(lyrPage);

            this.lyrPages.push(lyrPage);
        }
        lyrBackground.setContentSize(maxWidth, maxHeight);
        this.lyrBackground = lyrBackground;

        this.updateImages();

        //@@@pp.Pop_needSwallow = false;

        this._super(lyrBackground,
            caption,
            pp.POP_FRM_CANCEL_BUTTON,
            function (sel) {
                callback.call(target, sel);
            },
            this,
            backOpacity,
            pp.POP_CAPTION_INSIDE,
            allowOverlap
        );

        pp.Pop_needSwallow = true;

        if (this.lyrPages.length > 1) {
            //    ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude, barVal, isFlat)

            var mnu = new pp.MenuRect(
                headerStrings[headerStrings.length-1],
                function (item) {
                    pp.mediator.playSound(res.Snd_Click);
                    this.setVisiblePage(item.tag);
                },
                this,
                true,
                cc.color(148,148,48),
                false,
                0,
                0.5
            );
            mnu.attr({
                anchorX: 1,
                anchorY: 1,
                x: this.frame0.width - 30,
                y: this.frame0.height - 20
            });
            this.mnuPage = mnu;
            this.setSelectedIndex(0);
            this.frame0.addChild(mnu);
        }

        this.setSelected(pp.idxInvalid);

        this.nodListening = new cc.Node();
        this.addChild(this.nodListening, 10);

        this._name = "PopListSelect";
    },

    setSelectedIndex: function (idx) {
        this.setVisiblePage(idx);
        //this.mnuPage.setSelectedIndex(idx);
    },

    setVisiblePage: function (idx) {

        if (this.lyrPages.length == 1) return;

        if (idx == this.getVisiblePage()) return;

        this.scrViews[idx].setContentOffset(
            this.scrViews[this.getVisiblePage()].getContentOffset()
        );

        this.mnuPage.setSelectedIndex(idx);
        for (var i = 0; i < this.lyrPages.length; i++) {
            this.lyrPages[i].visible = idx == i;
        }
    },

    getVisiblePage: function () {

        if (this.lyrPages.length == 1) return 0;

        return this.mnuPage.getSelectedIndex();
    },

    onEnter: function () {

        // Add Click Event Handler
        if (this.nodListening)
        {

            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: false,
                    onTouchBegan: this.onMyTouchBegan,
                    onTouchMoved: function (touch, event) { },
                    onTouchEnded: this.onMyTouchEnded,
                    onTouchCancelled: function (touch, event) { }
                }),
                this.nodListening
            );


            // Swallow here (After Scroll View). Beware that priorities are based on nodes
            /*
             cc.eventManager.addListener(
             cc.EventListener.create({
             event: cc.EventListener.TOUCH_ONE_BY_ONE,
             swallowTouches: true,
             onTouchBegan: function (touch, event) {
             cc.log("SWL!");
             return true; },
             onTouchMoved: function (touch, event) { },
             onTouchEnded: function (touch, event) { },
             onTouchCancelled: function (touch, event) { }
             }),
             this
             );
             */
        }

        this._super();
    },

    setSelectedByUi: function (idx) {

        var a = this.stringsss[this.getVisiblePage()][idx];

        this.didGetSelection(a[a.length-1]);

        //pp.mediator.playSound(res.Snd_Click);

        this.setSelected(idx);
    },

    setSelected: function (idx) {

        if (idx == this.selectedIdx) {
            return;
        }

        var nPages = this.sprOptionsss.length;

        for (var iPage = 0; iPage < nPages; iPage++) {

            var sprOptionss = this.sprOptionsss[iPage];

            var selectedOptions = sprOptionss[idx];
            selectedOptions.forEach(function (spr) {
                if (spr.setFontFillColor) {
                    spr.setFontFillColor(cc.color.WHITE);
                    //spr._setUpdateTextureDirty(); // for Canvas render mode
                }
                else if (spr instanceof cc.Layer) {
                    spr.opacity = 128;
                }
            });

            this.scrViews[this.getVisiblePage()].scrollToShowNode(selectedOptions[selectedOptions.length-1]);

            if (this.selectedIdx != pp.IDX_INVALID) {

                var unselectedOptions = sprOptionss[this.selectedIdx];
                unselectedOptions.forEach(function (spr) {
                    if (spr.setFontFillColor) {
                        spr.setFontFillColor(cc.color.BLACK);
                        //spr._setUpdateTextureDirty(); // for Canvas render mode
                    }
                    else if (spr instanceof cc.Layer) {
                        spr.opacity = 1;
                    }
                });
            }
        }

        this.selectedIdx = idx;
    },

    didGetSelection: function (sel) {
        if (sel == pp.POP_WAS_CANCEL) {
            pp.mediator.playSound(res.Snd_Cancel);
        }
        else {
            pp.mediator.playSound(res.Snd_Click);
        }
        this._super(sel);
    },

    onMyTouchBegan: function (touch, event) {

        var node = event.getCurrentTarget().getParent();
        var touchPos = tm.getTouchPos(touch);

        var layer = node.lyrBackground;
        if (tm.isInside(touchPos, layer)) {

            node.myTouchPos = touchPos;
            return true;
        }

        return false;
    },

    onMyTouchEnded: function (touch, event) {

        var node = event.getCurrentTarget().getParent();
        var touchPos = tm.getTouchPos(touch);
        var pageIdx = node.getVisiblePage();

        //cc.log("PopListSelect: Touched.touchPos=(" + touchPos.x + ", " + touchPos.y + ")");

        var dist = Math.abs(touchPos.x -node.myTouchPos.x) + Math.abs(touchPos.y-node.myTouchPos.y);
        if (dist > 3) {
            // Ignore dragging
            return false;
        }

        var sprHeaders = node.sprHeaderss[pageIdx];

        for (var i = 0; i < sprHeaders.length; i++) {
            var sprHeader = sprHeaders[i];

            if (tm.isInside(touchPos, sprHeader)) {

                //*** Header was clicked

                var isSortDescend = true;
                if (node.sortingColIdx == i && node.sortingPageIdx == pageIdx) {
                    isSortDescend = node.isSortDescend == false;
                }

                pp.mediator.playSound(res.Snd_Click);

                node.sortByCol(pageIdx, i, isSortDescend);

                //cc.log("HEADER" + i + " clicked! isSortDescend=" + isSortDescend);
                return true;
            }
        }

        var scrView = node.scrViews[pageIdx];
        if (tm.isInside(touchPos, scrView)) {
            var y = scrView.height - (touchPos.y - scrView.convertToWorldSpace().y);
            var scrY = scrView.getContentSize().height - scrView.height + scrView.getContentOffset().y;
            var iy = tm.int((y + scrY) / pp.POP_LISTM_ROW_HEIGHT);

            node.setSelectedByUi(iy);
            //cc.log("ROW: clicked! y=" + y + ", iy =" + iy); //@@@
            return true;
        }

        return false;
    },

    sortByCol: function (visiblePageIdx, colIdx, isSortDescend) {

        var nPages = this.stringsss.length;
        var nRows = this.stringsss[0].length;

        //--- Save focused row
        var focusedRealIdx = pp.idxInvalid;

        if (this.selectedIdx != pp.idxInvalid) {
            var strings = this.stringsss[0][this.selectedIdx];
            focusedRealIdx = strings[strings.length - 1];
        }

        //--- Update triangle
        /*
        if (this.sprTriangle == null) {
            this.sprTriangle = new cc.Sprite(res.Img_ListTriangleDown);
            this.sprTriangle.attr({
                anchorX: 1,
                anchorY: 0.5,
                y: pp.POP_LISTM_ROW_HEIGHT / 2
            });
        }
        else {
            this.sprTriangle.removeFromParent(false);
        }
        this.sprTriangle.scaleY = isSortDescend ? 1 : -1;
        this.sprHeaderss[visiblePageIdx][colIdx].addChild(this.sprTriangle);
        this.sprTriangle.x = this.sprHeaderss[visiblePageIdx][colIdx].width - 4;
        */

        this.sortingColIdx = colIdx;
        this.sortingPageIdx = visiblePageIdx;
        this.isSortDescend = isSortDescend;

        //--- Sort

        // Push other tables to the visible page
        for (var iPage = 0; iPage < nPages; iPage++) {
            if (iPage == visiblePageIdx) continue;

            for (var iy = 0; iy < nRows; iy++) {
                var toPushTo = this.stringsss[visiblePageIdx][iy];
                var toPush = this.stringsss[iPage][iy];
                this.stringsss[visiblePageIdx][iy].push(this.stringsss[iPage][iy]);
            }
        }

        //--- Sort
        this.stringsss[visiblePageIdx].sort(function (stringsA, stringsB) {
            var a = stringsA[colIdx];
            var b = stringsB[colIdx];
            var ret = 0;

            if (a == "Ｓ") {
                ret = b == "Ｓ" ? 0 : -1;
            }
            else if (b == "Ｓ") {
                ret = 1;
            }
            else if (tm.isNumber(a)) {
                ret = a - b;
            }
            else {
                if (a > b) ret = 1; else if (a < b) ret = -1; else ret = 0;
            }

            if (!isSortDescend)
                ret = -ret;

            //cc.log("a=" + a + ", b=" + b + ", isSortDescend=" + isSortDescend + ", ret=" + ret);
            return ret;
        });

        // Pop appended table
        for (var iPage = nPages-1; iPage >= 0; iPage--) {
            if (iPage == visiblePageIdx) continue;

            for (var iy = 0; iy < nRows; iy++) {
                var popped = this.stringsss[visiblePageIdx][iy].pop();
                this.stringsss[iPage][iy] = popped;
            }
        }

        //--- Update labels
        for (var iPage = 0; iPage < nPages; iPage++) {
            for (var iy = 0; iy < nRows; iy++) {
                var sprOptions = this.sprOptionsss[iPage][iy];

                sprOptions[0].string = this.stringsss[iPage][iy][0];
                sprOptions[1].string = this.stringsss[iPage][iy][this.stringsss[iPage][iy].length-2];
            }
        }

        //--- Restore focused row
        if (focusedRealIdx != pp.idxInvalid) {
            for (var iy = 0; iy < nRows; iy++) {
                var strings = this.stringsss[0][iy];
                if (focusedRealIdx == strings[strings.length - 1]) {
                    this.setSelected(iy);
                    break;
                }
            }
        }

        this.updateImages();
    }

});

