
pp.PopListSelectPr = pp.PopListSelect.extend({

    ctor: function (listItemType, filterTypeAndIds, callback, target, allowOverlap) {

        var options = [];
        var ids = [];
        var fieldNames = [];
        var fieldWidths = [];
        var fieldAligns = [];
        var caption = "";
        var objName = "";

        var colSort = pp.idxInvalid;

        var person;
        if (cc.isArray(filterTypeAndIds) && filterTypeAndIds[0] == pp.ftPerson) {
            person = pp.world.persons[filterTypeAndIds[1]];
        }

        switch (listItemType) {

            case pp.ltItem:
            {
                var personId = pp.idInvalid;
                var fieldId = pp.idInvalid;

                while (filterTypeAndIds && filterTypeAndIds.length > 0) {
                    var type = filterTypeAndIds.shift();
                    var id = filterTypeAndIds.shift();
                    if (type == pp.fiPerson) {
                        personId = id;
                    }
                    else if (type == pp.fiField) {
                        fieldId = id;
                    }
                }

                // Hearders
                objName = __("アイテム");
                caption = __("アイテム");
                fieldNames = [ __("名称"), __("効果"), __("価格"), "image" ];
                fieldWidths = [ 240, 100, 80 ];
                fieldAligns = [ pp.LEFT, pp.LEFT, pp.RIGHT ];
                colSort = 2;

                // Options
                pp.world.items.forEach(function (item) {
                    if (personId != pp.idInvalid && pp.world.persons[personId].itemNums[item.id] == 0) return;
                    if (fieldId != pp.idInvalid && item.fieldId != fieldId) return;
                    if (personId == pp.idInvalid && item.isActive == false) return;

                    var field = pp.world.fields[item.fieldId];
                    var effect = field.name2 + "+" + item.gain;
                    options.push([item.name, effect, item.price, item.picture]);
                    ids.push(item.id);

                    //cc.log("item.id=" + item.id + ", name=" + item.name + ", picture=" + item.picture);
                });
                break;
            }


            case pp.ltReport:
            {
                var personId = pp.idInvalid;
                var published = null;
                var discType = pp.idInvalid;

                while (filterTypeAndIds && filterTypeAndIds.length > 0) {
                    var type = filterTypeAndIds.shift();
                    var id = filterTypeAndIds.shift();
                    if (type == pp.frPerson) {
                        personId = id;
                    }
                    else if (type == pp.frPublished) {
                        published = id;
                    }
                    else if (type == pp.frDiscType) {
                        discType = id;
                    }
                }

                // Hearders
                objName = __("論文");
                caption = __("論文");

                if (personId != pp.idInvalid) {
                    fieldNames = [ __("内容"), __("種別"), __("テーマ"), __("完成", "Comp"), __("状態") ];
                    fieldWidths = [ 300, 80, 170, 60, 80 ];
                    fieldAligns = [ pp.LEFT, pp.CENTER, pp.LEFT, pp.RIGHT, pp.CENTER ];
                }
                else {
                    fieldNames = [ __("内容"), __("種別"), __("作者"), __("テーマ"), __("完成", "Comp"), __("状態") ];
                    fieldWidths = [ 300, 80, 160, 170, 60, 80 ];
                    fieldAligns = [ pp.LEFT, pp.CENTER, pp.LEFT, pp.LEFT, pp.RIGHT, pp.CENTER ];
                }

                // Options
                var reports = pp.world.reports;

                reports.forEach(function (report) {

                    var person = pp.world.persons[report.personId];
                    var statStr = report.societyId == pp.ID_INVALID ? __("未提出") : __("提出済");
                    var disc = pp.world.discoveries[report.discoveryId];
                    var type = __(pp.ttNames[disc.type]);
                    var theme = pp.world.themes[disc.themeId];

                    if (personId != pp.idInvalid && personId != report.personId) return;
                    if (published != null && (report.societyId != pp.idInvalid) != published) return;
                    if (discType != pp.idInvalid && disc.type != discType) return;

                    if (personId != pp.idInvalid) {
                        options.push([tmi.titleize(tm.truncate(disc.name, __(14, 40))), type, tm.truncate(theme.name, 20), report.getCredibilityStr(), statStr]);
                    }
                    else {
                        options.push([tmi.titleize(tm.truncate(disc.name, __(14, 40))), type, person.name, tm.truncate(theme.name, 20), report.getCredibilityStr(), statStr]);
                    }

                    ids.push(report.id);
                });
                break;
            }

            case pp.ltDiscovery:
            {
                // Headers
                objName = __("発見");
                caption = __("発見");
                fieldNames = [ __("内容"), __("種別"), __("テーマ"), __("完成", "Comp"), __("論文") ];
                fieldWidths = [ 300, 80, 170, 80, 80 ];
                fieldAligns = [ pp.LEFT, pp.CENTER, pp.LEFT, pp.RIGHT, pp.CENTER ];

                // Options
                if (cc.isArray(filterTypeAndIds) && filterTypeAndIds[0] == pp.fdPerson) {
                    var discs;
                    if (filterTypeAndIds[2] == pp.fdType) {
                        discs = person.getDiscoveriesWithType(filterTypeAndIds[3]);
                    }
                    else {
                        discs = person.getDiscoveries();
                    }

                    discs.forEach(function (disc) {

                        var type = __(pp.ttNames[disc.type]);
                        var theme = pp.world.themes[disc.themeId];
                        var reportId = person.getReportIdFromDiscId(disc.id);
                        var report = pp.world.reports[reportId];
                        var reportStatus = disc.getReportStatusName(person.id);
                        options.push([tmi.titleize(tm.truncate(disc.name, __(14, 40))), type, tm.truncate(theme.name, 20), person.getDiscCredibilityStrForList(disc.id), reportStatus])
                        ids.push(disc.id);
                    });
                }
                else {
                    cc.assert(false, "You cannot show the list of all discoveries!");
                }
                break;
            }

            case pp.ltSociety:
            {
                // Headers
                objName = __("組織");
                caption = __("組織");
                fieldNames = [ __("名称"), __("所在地"), __("権威") ];
                fieldWidths = [ 280, 140, 80 ];
                fieldAligns = [ pp.LEFT, pp.LEFT, pp.RIGHT ];

                // Options
                pp.world.societies.forEach(function (society) {
                    if (society.exist == false) return;

                    var place = pp.world.places[society.placeId];

                    options.push([society.name, place.name, society.authority]);
                    ids.push(society.id);
                });
                break;
            }

            case pp.ltPlace:
            {
                // Headers
                objName = __("都市");
                caption = __("都市");
                fieldNames = [ __("名称"), __("科学者"), __("組織"), __("大学"), __("天文台")];
                fieldWidths = [ 160, 100, 100, 100, 100 ];
                fieldAligns = [ pp.LEFT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT ];

                // Options
                pp.world.places.forEach(function (place) {
                    options.push([
                        place.name,
                        place.getPersons().length,
                        place.getSocieties().length,
                        place.getUniversities().length,
                        place.getObservatories().length
                    ]);
                    ids.push(place.id);
                });
                break;
            }

            case pp.ltOccupation:
            {
                // Headers
                objName = __("職業");
                caption = __("職業");
                fieldNames = [ __("名称"), __("所在地"), __("収入"), __("必要名声") ];
                fieldWidths = [ 240, 160, 80, 140 ];
                fieldAligns = [ pp.LEFT, pp.LEFT, pp.RIGHT, pp.RIGHT ];
                colSort = 3;

                cc.assert(filterTypeAndIds[0] == pp.ftPerson, "Invalid filterTypeAndIds");

                var personId = filterTypeAndIds[1];
                var person = pp.world.persons[personId];

                // Options
                pp.world.occupations.forEach(function (occupation) {
                    if (occupation.personId != pp.idInvalid && occupation.personId != personId)
                        return;
                    var placeName =
                        occupation.placeId == pp.ID_INVALID ? "---" : pp.world.places[occupation.placeId].name;

                    options.push([occupation.name, placeName, "" + occupation.income, "" + occupation.fame]);
                    ids.push(occupation.id);
                });
                break;
            }

            case pp.ltUniversity:
            {
                // Headers
                objName = __("大学");
                caption = __("大学");
                fieldNames = [ __("名称"), __("所在地"), __("学術") ];
                fieldWidths = [ 240, 160, 80 ];
                fieldAligns = [ pp.LEFT, pp.LEFT, pp.RIGHT ];

                // Options
                pp.world.universities.forEach(function (univ) {
                    var place = pp.world.places[univ.placeId];
                    options.push([univ.name, place.name, univ.science ]);
                    ids.push(univ.id);
                });
                break;
            }

            case pp.ltObservatory:
            {
                // Headers
                objName = __("天文台");
                caption = __("天文台");
                fieldNames = [ __("名称"), __("所在地"), __("設備") ];
                fieldWidths = [ 240, 160, 80 ];
                fieldAligns = [ pp.LEFT, pp.LEFT, pp.RIGHT ];

                // Options
                pp.world.observatories.forEach(function (obs) {
                    var place = pp.world.places[obs.placeId];
                    options.push([obs.name, place.name, obs.equipment ]);
                    ids.push(obs.id);
                });
                break;
            }

        }

        if (options.length > 0) {
            this._super(
                fieldNames,
                fieldWidths,
                fieldAligns,
                options,
                caption,
                function (sel) {
                    callback.call(target, sel == pp.selCancel ? pp.selCancel : ids[sel]);
                },
                this,
                0,
                allowOverlap
            );

            if (pp.isIdValid(colSort))
                this.sortByCol(0, colSort, true);
        }
        else {
            pp.PopMessage.prototype.ctor.call(this,
                __(
                    "選択可能な" + objName + "がありません。",
                    "There are no " + tmi.toLowerCase(tmi.pluralize(objName)) + " available for selection.",
                    "没有合适的" + objName + "可供选择。"
                ),
                "",
                function () {
                    callback.call(target, pp.selCancel);
                },
                this,
                1);
        }
    }

});

