
pp.PopParamChange = pp.Pop.extend({

    ctor: function (paramName, fromVal, toVal, paramOwnerName, allowOverlap, callback, target, backOpacity) {

        var content = new cc.Layer(); //Color(cc.color.RED);
        var paramDetailedName = paramOwnerName ? __(paramOwnerName + "の" + paramName, paramName + " of " + paramOwnerName, paramOwnerName + "的" + paramName) : paramName;
        backOpacity = backOpacity || 1;

        // Text
        var d = toVal - fromVal;
        var str = d > 0 ? __("が上昇しました！", " increased!", "上升了！") : d < 0 ? __("が減少しました！", " decreased!", "减少了！") : __("は変化しませんでした。", " did not change.", "没有变化。");
        var sign = d > 0 ? "+" : d < 0 ? "" : "±";
        var color = d > 0 ? cc.color.GREEN : d < 0 ? cc.color.RED : cc.color.YELLOW;
        var label = new tm.LabelTTF(paramDetailedName + str, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);
        label.setFontFillColor(cc.color.WHITE);

        if (label.width > pp.POP_LABEL_MAX_WIDTH)
            label.setDimensions(cc.size(pp.POP_LABEL_MAX_WIDTH, 0));

        var strParam1 = paramName + ":";
        var strParam2 = fromVal + " → " + toVal + " (" + sign + d + ")";

        var lblParam = new tm.LabelTTF(strParam1 + " " + strParam2, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);
        lblParam.setHorizontalAlignment(cc.TEXT_ALIGNMENT_CENTER);
        lblParam.setFontFillColor(color);

        if (lblParam.width > pp.POP_LABEL_MAX_WIDTH) {
            lblParam.string = strParam1 + CR + strParam2;
            lblParam.setDimensions(cc.size(pp.POP_LABEL_MAX_WIDTH, 0));
        }

        content.addChild(label);
        content.addChild(lblParam);

        content.height = label.height + lblParam.height + tm.m(10, 5);
        content.width = tm.max(label.width, lblParam.width);

        label.attr({
            x: content.width /2,
            y: content.height,
            anchorY: 1
        });
        lblParam.attr({
            x: content.width /2,
            anchorY: 0
        });

        this._super(content, __("パラメーター"), pp.POP_FRM_NO_BUTTONS, callback, target, backOpacity, null, allowOverlap);

        if (d < 0) {
            pp.mediator.playSound(res.Snd_Down, 0.3);
        }
        else {
            pp.mediator.playSound(res.Snd_Up, 0.3);
        }
    }

});
