
tm.Scale9SpriteTiled = cc.Node.extend({

    _scale9Sprite: null,
    _sprTiles: null,

    ctor: function (file, rectOrCapInsets, capInsets) {

        this._super();

        this._sprTiles = [];

        var s9spr = new cc.Scale9Sprite(file, rectOrCapInsets, capInsets);

        if (s9spr.capInsets.width == 0 && s9spr.capInsets.height == 0)
            s9spr.setCapInsets(cc.rect(Math.floor(s9spr.width / 3), Math.floor(s9spr.height / 3), Math.floor(s9spr.width / 3), Math.floor(s9spr.height / 3)));

        //this.addChild(s9spr);
        this._scale9Sprite = s9spr;
        //this._scale9Sprite.retain();

        s9spr.attr({
            ignoreAnchor: true
        });

        this.attr({
            anchorX: 0.5,
            anchorY: 0.5
        });

        //s9spr.visible = false;
        this.setCascadeColorEnabled(true);
        this.setCascadeOpacityEnabled(true);

        this.setContentSize(s9spr.width, s9spr.height);
    },

    onExit: function () {
        //this._scale9Sprite.release();
        this._super();
    },

    setContentSize: function (size, height) {
        this._super(size, height);
        this._scale9Sprite.setContentSize(size, height);

        this._updateSize();
    },

    setCapInsets: function (capInsets) {
        this._scale9Sprite.setCapInsets(capInsets);
        this._updateSize();
    },

    _updateSize: function () {

        var s9spr = this._scale9Sprite;

        do {
            var spr = this._sprTiles.pop(); if (!spr) break;
            spr.removeFromParent();
        } while (true);

        //s9spr.color = cc.color(255,128,128); //@@@ debug

        var sprSource = s9spr.getSprite();
        var texSource = sprSource.getTexture();

        var r1Size = this.getContentSize();

        // Source Geometry
        var r0Center =  cc.rect(s9spr.insetLeft, s9spr.insetBottom, sprSource.width - s9spr.insetLeft -s9spr.insetRight, sprSource.height - s9spr.insetTop - s9spr.insetBottom);
        var r0Left =    cc.rect(0, s9spr.insetBottom, s9spr.insetLeft, r0Center.height);
        var r0Right =   cc.rect(sprSource.width - s9spr.insetRight, s9spr.insetBottom, s9spr.insetRight, r0Center.height);
        var r0Top =     cc.rect(s9spr.insetLeft, sprSource.height - s9spr.insetTop, r0Center.width, s9spr.insetTop);
        var r0Bottom =  cc.rect(s9spr.insetLeft, 0, r0Center.width, s9spr.insetBottom);
        var r0TopLeft = cc.rect(0, sprSource.height - s9spr.insetTop, s9spr.insetLeft,  s9spr.insetTop);
        var r0BottomLeft = cc.rect(0, 0, s9spr.insetLeft, s9spr.insetBottom);
        var r0TopRight = cc.rect(sprSource.width - s9spr.insetRight, sprSource.height - s9spr.insetTop, s9spr.insetRight, s9spr.insetTop);
        var r0BottomRight = cc.rect(sprSource.width - s9spr.insetRight, 0, s9spr.insetRight, s9spr.insetBottom);

        // Source Geometry for Texture (up-side-down)
        var r0sCenter = cc.rect(r0Center.x, sprSource.height - r0Left.y - r0Left.height, r0Center.width, r0Center.height);
        var r0sLeft =   cc.rect(r0Left.x,   sprSource.height - r0Left.y - r0Left.height, r0Left.width, r0Left.height);
        var r0sRight =  cc.rect(r0Right.x,  sprSource.height - r0Right.y - r0Right.height, r0Right.width, r0Right.height);
        var r0sTop =    cc.rect(r0Top.x,    sprSource.height - r0Top.y - r0Top.height, r0Top.width, r0Top.height);
        var r0sBottom = cc.rect(r0Bottom.x, sprSource.height - r0Bottom.y - r0Bottom.height, r0Bottom.width, r0Bottom.height);
        var r0sTopLeft =   cc.rect(r0TopLeft.x,   sprSource.height - r0TopLeft.y - r0TopLeft.height, r0TopLeft.width, r0TopLeft.height);
        var r0sTopRight =  cc.rect(r0TopRight.x,  sprSource.height - r0TopRight.y - r0TopRight.height, r0TopRight.width, r0TopRight.height);
        var r0sBottomLeft =   cc.rect(r0BottomLeft.x,   sprSource.height - r0BottomLeft.y - r0BottomLeft.height, r0BottomLeft.width, r0BottomLeft.height);
        var r0sBottomRight =  cc.rect(r0BottomRight.x,  sprSource.height - r0BottomRight.y - r0BottomRight.height, r0BottomRight.width, r0BottomRight.height);

        // Destination Geometry
        var r1Center = cc.rect(r0Left.width, r0Bottom.height, r1Size.width - r0Left.width - r0Right.width, r1Size.height - r0Top.height - r0Bottom.height);
        var r1Top = cc.rect(r1Center.x, r1Size.height - r0Top.height, r1Center.width, r0Top.height);
        var r1Left = cc.rect(0, r1Center.y, r0Left.width, r1Center.height);
        var r1Right = cc.rect(r1Size.width - r0Right.width, r1Center.y, r0Right.width, r1Center.height);
        var r1Bottom = cc.rect(r1Center.x, 0, r1Center.width, r0Bottom.height);

        var r1TopLeft = cc.rect(0, r1Size.height - s9spr.insetTop, s9spr.insetLeft,  s9spr.insetTop);
        var r1BottomLeft = cc.rect(0, 0, s9spr.insetLeft, s9spr.insetBottom);
        var r1TopRight = cc.rect(r1Size.width - s9spr.insetRight, r1Size.height - s9spr.insetTop, s9spr.insetRight, s9spr.insetTop);
        var r1BottomRight = cc.rect(r1Size.width - s9spr.insetRight, 0, s9spr.insetRight, s9spr.insetBottom);

        var horizontalScale = r0Center.width > 0 ? r1Center.width / r0Center.width : 1;
        var verticalScale = r0Center.height > 0 ? r1Center.height / r0Center.height : 1;

        // TopLeft
        var spr = new cc.Sprite(texSource, r0sTopLeft);
        spr.attr({ anchorX: 0, anchorY: 0, x: r1TopLeft.x, y: r1TopLeft.y });
        this.addChild(spr, -1);
        this._sprTiles.push(spr);

        // BottomLeft
        var spr = new cc.Sprite(texSource, r0sBottomLeft);
        spr.attr({ anchorX: 0, anchorY: 0, x: r1BottomLeft.x, y: r1BottomLeft.y });
        this.addChild(spr, -1);
        this._sprTiles.push(spr);

        // TopRight
        var spr = new cc.Sprite(texSource, r0sTopRight);
        spr.attr({ anchorX: 0, anchorY: 0, x: r1TopRight.x, y: r1TopRight.y });
        this.addChild(spr, -1);
        this._sprTiles.push(spr);

        // BottomRight
        var spr = new cc.Sprite(texSource, r0sBottomRight);
        spr.attr({ anchorX: 0, anchorY: 0, x: r1BottomRight.x, y: r1BottomRight.y });
        this.addChild(spr, -1);
        this._sprTiles.push(spr);


        // Centre
        if (r1Center.height > 0 && r1Center.width > 0) {
            var sprcenter = new cc.Sprite(texSource, r0sCenter);
            sprcenter.attr({
                anchorX: 0,
                anchorY: 0,
                x: s9spr.insetLeft,
                y: s9spr.insetBottom,
                scaleX: horizontalScale,
                scaleY: verticalScale
            });
            this._addTilesInsteadOfScaled(sprcenter);
        }

        // Right
        if (r1Right.height > 0) {
            var sprright = new cc.Sprite(texSource, r0sRight);
            sprright.attr({
                anchorX: 0,
                anchorY: 0,
                x: r1Right.x,
                y: r1Right.y,
                scaleY: verticalScale
            });
            this._addTilesInsteadOfScaled(sprright);
        }

        // Left
        if (r1Left.height > 0) {
            var sprleft = new cc.Sprite(texSource, r0sLeft);
            sprleft.attr({
                anchorX: 0,
                anchorY: 0,
                x: r1Left.x,
                y: r1Left.y,
                scaleY: verticalScale
            });
            this._addTilesInsteadOfScaled(sprleft);
        }

        // Top
        if (r1Top.width > 0) {
            var sprtop = new cc.Sprite(texSource, r0sTop);
            sprtop.attr({
                anchorX: 0,
                anchorY: 0,
                x: r1Top.x,
                y: r1Top.y,
                scaleX: horizontalScale
            });
            this._addTilesInsteadOfScaled(sprtop);
        }

        // Bottom
        if (r1Bottom.height > 0) {
            var sprbottom = new cc.Sprite(texSource, r0sBottom);
            sprbottom.attr({
                anchorX: 0,
                anchorY: 0,
                x: r1Bottom.x,
                y: r1Bottom.y,
                scaleX: horizontalScale
            });
            this._addTilesInsteadOfScaled(sprbottom);
        }

        //this.addChild(this._center);
    },

    _addTilesInsteadOfScaled: function (sprite) {

        for (var ix = 0; ix < sprite.scaleX; ix++) {
            for (var iy = 0; iy < sprite.scaleY; iy++) {

                var rect = sprite.getTextureRect();
                if (ix + 1 > sprite.scaleX) {
                    rect.width = rect.width * (sprite.scaleX - ix);
                }
                if (iy + 1 > sprite.scaleY) {
                    rect.height = rect.height * (sprite.scaleY - iy);
                }

                var aTile = new cc.Sprite(sprite.texture, rect);
                aTile.attr({
                    x: sprite.x + sprite.width*(ix - sprite.anchorX * sprite.scaleX),
                    y: sprite.y + sprite.height*(iy - sprite.anchorY * sprite.scaleY),
                    ignoreAnchor: true
                });

                this.addChild(aTile, -1);

                this._sprTiles.push(aTile);
            }
        }
    }

});
