
tm.Scale9SpriteTiled = cc.Scale9Sprite.extend({

    _sprTiles: null,

    _updatePositions: function () {

        this._super();

        this._sprTiles = [];

        this.setCascadeOpacityEnabled(true);
        this._scale9Image.setCascadeOpacityEnabled(true);

        this._addChildInsteadOfScaling(this._top);
        this._addChildInsteadOfScaling(this._bottom);
        this._addChildInsteadOfScaling(this._left);
        this._addChildInsteadOfScaling(this._right);
        this._addChildInsteadOfScaling(this._centre);
    },

    setOpacity: function (opacity) {

        cc.Scale9Sprite.prototype.setOpacity.call(this, opacity);

        var parentOp = this.getOpacity();
        if (cc.isArray(this._sprTiles)) {
            this._sprTiles.forEach(function (aTile) {
                aTile.setOpacity((255 + parentOp) / 2); //@@@ ??
            });
        }
    },

    _addChildInsteadOfScaling: function (sprite) {

        for (var ix = 0; ix < sprite.scaleX; ix++) {
            for (var iy = 0; iy < sprite.scaleY; iy++) {

                var rect = sprite.getTextureRect();
                if (ix + 1 > sprite.scaleX) {
                    rect.width = rect.width * (sprite.scaleX - ix);
                }
                if (iy + 1 > sprite.scaleY) {
                    rect.height = rect.height * (sprite.scaleY - iy);
                }

                var aTile = new cc.Sprite(sprite.texture, rect);
                aTile.attr({
                    x: sprite.x + sprite.width*(ix - sprite.anchorX * sprite.scaleX),
                    y: sprite.y + sprite.height*(iy - sprite.anchorY * sprite.scaleY),
                    ignoreAnchor: true
                });

                this.addChild(aTile, -1);

                this._sprTiles.push(aTile);
            }
        }

        sprite.visible = false;
    }
});
