
pp.ScnAuto = pp.Scn.extend({

    ctor: function () {

        this._super();
    },

    onEnter: function () {
        // Set up event manager
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) { return true; },
                    onTouchMoved: function (touch, event) { return true; },
                    onTouchEnded: this.onTouchEnded,
                    onTouchCancelled: function (touch, event) { return true; }
                }),
                this
            );
        }

        if (pp.mediator.messageWaitInSec != 0 && (pp.mediator.waitingMode & pp.MW_TIMEOUT)) {
            this.schedule(this.onTimeOut, pp.mediator.messageWaitInSec, 100000);
        }
    },

    onTouchEnded: function (touch, event) {
        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        pp.mediator.suiDidGetUserInput();

        node.unschedule(this.onTimeOut);

        return true;
    },

    onTimeOut: function (elapsed) {

        if ((pp.mediator.waitingMode & pp.MW_TIMEOUT) == 0) {
            //cc.log("I need to wait now....");
            return;
        }
        //cc.log("NO NEED.");

        pp.mediator.suiDidTimeOut();

        this.unschedule(this.onTimeOut);
    }

});
