
pp.ScnOpening = pp.Scn.extend({

    status: 0,

    lyrStory: null,
    lblStory1: null,
    lblStory2: null,
    lblStory3: null,

    sprImage1: null,
    sprImage2: null,

    windowHeight: 0,

    ctor: function () {

        this._super();

        this._name = "ScnOpening";

        // Background
        {
            var sprBack = new cc.Sprite(res.Img_UnvBack);
            sprBack.attr({
                x: this.width / 2,
                y: this.height / 2
            });
            sprBack.scale = tm.m(1.2, 1);
            this.addChild(sprBack, 2);

            var sprStars = new cc.Sprite(res.Img_UnvStars);
            sprStars.attr({
                x: this.width /2,
                y: this.height /2
            });
            this.addChild(sprStars, 5);

            sprBack.runAction(
                cc.rotateBy(64000, 36000)
            );

            sprStars.runAction(
                cc.rotateBy(16000, 36000)
            );
        }

        // Clipping Node
        this.windowHeight = cc.winSize.height*0.45;
        var clipper = new cc.ClippingNode();
        var sprWindow = new cc.LayerColor(cc.color(0,0,0,255), cc.winSize.width, this.windowHeight);

        clipper.setStencil(sprWindow);
        clipper.setInverted(false);
        clipper.setAlphaThreshold(0);
        this.addChild(clipper, 4);


        // Story
        {
            var str1;
            var str2;
            var str3;

            if (tmd.language == pp.LN_JAPANESE)
            {
                if (tm.isMobile())
                {
                    str1 =
                        "1543年にコペルニクスが地動説を唱えて以来" + CR +
                        "120年余りが過ぎた。" + CR +
                        CR +
                        CR +
                        "多くの天文学者たちが膨大な観測データを元に" + CR +
                        "神の世界である天界の法則を見出そうと努力を" + CR +
                        "重ねていた。" + CR +
                        CR +
                        "その中の一人ヨハネス・ケプラーは太陽系の" + CR +
                        "惑星が太陽を焦点とする楕円軌道を描いている" + CR +
                        "ことを示唆した。" + CR +
                        CR +
                        "当時天界は完全かつ不変と考えられていたので、" + CR +
                        "惑星が円ではなく楕円という不完全な軌道を" + CR +
                        "描くと言うことは神学者を始め当時の人々を" + CR +
                        "動揺させずにはいなかった。";

                    str2 =
                        "同じころガリレオ・ガリレイは当時の最新技術" + CR +
                        "である「望遠鏡」を用いて月面を観測し、月にも" + CR +
                        "山々が存在し決して完全な球体ではないことに" + CR +
                        "気付いた。" + CR +
                        CR +
                        "天界と地上を別世界とする理論のより所が次々に" + CR +
                        "失われては行ったが最終的な真理と言うべき" + CR +
                        "『統一理論』の完成は困難を極めケプラー、" + CR +
                        "ガリレオは理論の完成を見ずに世を去る。";

                    str3 =
                        "ガリレオの死から25年後の1667年、ロンドン王立" + CR +
                        "協会のフック、パリ科学アカデミーのホイヘンスら" + CR +
                        "がガリレオの成し得なかった理論の構築に向けて" + CR +
                        "精力的な研究を続けていた。そんな中ケンブリッジ" + CR +
                        "大学に一人の天才学生がいると言う話が広まる。" + CR +
                        CR +
                        CR +
                        "彼の名はアイザック･ニュートンと言った。";
                }
                else
                {
                    str1 =
                        "1543年にコペルニクスが地動説を唱えて以来120年余りが過ぎた。" + CR +
                        CR +
                        CR +
                        "多くの天文学者たちが膨大な観測データを元に神の世界である" + CR +
                        "天界の法則を見出そうと努力を重ねていた。" + CR +
                        CR +
                        "その中の一人ヨハネス・ケプラーは太陽系の惑星が太陽を焦点" + CR +
                        "とする楕円軌道を描いていることを示唆した。" + CR +
                        CR +
                        "当時天界は完全かつ不変と考えられていたので、惑星が円では" + CR +
                        "なく楕円という不完全な軌道を描くと言うことは神学者を始め" + CR +
                        "当時の人々を動揺させずにはいなかった。";

                    str2 =
                        "同じころガリレオ・ガリレイは当時の最新技術である「望遠鏡」" + CR +
                        "を用いて月面を観測し、月にも山々が存在し決して完全な球体" + CR +
                        "ではないことに気付いた。" + CR +
                        CR +
                        "天界と地上を別世界とする理論のより所が次々に失われては行っ" + CR +
                        "たが最終的な真理と言うべき『統一理論』の完成は困難を極め" + CR +
                        "ケプラー、ガリレオは理論の完成を見ずに世を去る。";

                    str3 =
                        "ガリレオの死から25年後の1667年、ロンドン王立協会のフック、" + CR +
                        "パリ科学アカデミーのホイヘンスらがガリレオの成し得なかった" + CR +
                        "理論の構築に向けて精力的な研究を続けていた。そんな中、" + CR +
                        "ケンブリッジ大学に一人の天才学生がいると言う話が広まる。" + CR +
                        CR +
                        CR +
                        "彼の名はアイザック･ニュートンと言った。";
                }
            }
            else if (tmd.language == pp.LN_ENGLISH)
            {
                if (tm.isMobile())
                {
                    str1 =
                        "Just over 120 years have passed since Copernicus" + CR +
                        "advocated his Heliocentric Theory of the Universe" + CR +
                        "in 1543." + CR +
                        CR +
                        CR +
                        "Since then many astronomers have earnestly" + CR +
                        "attempted to unravel the laws that govern God's" + CR +
                        "domain, the Heavens, on the basis of a staggering" + CR +
                        "volume of observational data." + CR +
                        CR +
                        "Among them, Johannes Kepler suggested that the" + CR +
                        "planets of the Solar System took along ‘elliptical’" + CR +
                        "orbits around the focal point of the Sun." + CR +
                        CR +
                        "At this time the Heavens were thought pristine and" + CR +
                        "constant. Contemporary peoples, including" + CR +
                        "theologians, were shook to their core by the very" + CR +
                        "idea of planets taking along ‘imperfect’ elliptical" + CR +
                        "orbits rather than ‘perfect’ circular ones.";

                    str2 =
                        "Around the same time Galileo Galilei observed the" + CR +
                        "surface of the Moon with the aid of, what was then," + CR +
                        "a state of the art apparatus: the ‘telescope’. And" + CR +
                        "he realised that the Moon's surface, far from being" + CR +
                        "a perfect spheroid, was scarred with mountains." + CR +
                        CR +
                        "The theory that the Heavens and terrestrial surface" + CR +
                        "were fundamentally different steadily lost purchase." + CR +
                        "However, the completion of what could be deemed" + CR +
                        "the truth, a ‘unified theory’, was mired in" + CR +
                        "difficulty, such that neither Galileo nor Kepler" + CR +
                        "ever lived to see it.";

                    str3 =
                        "In 1667, 25 years after Galileo's death, research" + CR +
                        "into structuring Galileo's incomplete theory was" + CR +
                        "conducted with aplomb by Hooke of London's" + CR +
                        "Royal Society and Huygens et al. of the French" + CR +
                        "Academy of Sciences. It was at this time that" + CR +
                        "rumour of a gifted Cambridge University student" + CR +
                        "began to spread." + CR +
                        CR +
                        CR +
                        "His name was Isaac Newton.";
                }
                else
                {
                    str1 =
                        "Just over 120 years have passed since Copernicus advocated his Heliocentric Theory" + CR +
                        "of the Universe in 1543." + CR +
                        CR +
                        CR +
                        "Since then many astronomers have earnestly attempted to unravel the laws that govern" + CR +
                        "God's domain, the Heavens, on the basis of a staggering volume of observational data." + CR +
                        CR +
                        "Among them, Johannes Kepler suggested that the planets of the Solar System took along" + CR +
                        "‘elliptical’ orbits around the focal point of the Sun." + CR +
                        CR +
                        "At this time the Heavens were thought pristine and constant. Contemporary peoples, " + CR +
                        "including theologians, were shook to their core by the very idea of planets taking" + CR +
                        "along ‘imperfect’ elliptical orbits rather than ‘perfect’ circular ones.";

                    str2 =
                        "Around the same time Galileo Galilei observed the surface of the Moon with the aid of," + CR +
                        "what was then, a state of the art apparatus: the ‘telescope’. And he realised that " + CR +
                        "the Moon's surface, far from being a perfect spheroid, was scarred with mountains." + CR +
                        CR +
                        "The theory that the Heavens and terrestrial surface were fundamentally different" + CR +
                        "steadily lost purchase. However, the completion of what could be deemed the truth," + CR +
                        "a ‘unified theory’, was mired in difficulty, such that neither Galileo nor Kepler" + CR +
                        "ever lived to see it.";

                    str3 =
                        "In 1667, 25 years after Galileo's death, research into structuring Galileo's" + CR +
                        "incomplete theory was conducted with aplomb by Hooke of London's Royal Society and" + CR +
                        "Huygens et al. of the French Academy of Sciences. It was at this time that rumour of" + CR +
                        "a gifted Cambridge University student began to spread." + CR +
                        CR +
                        CR +
                        "His name was Isaac Newton.";
                }
            }
            else
            {
                if (tm.isMobile())
                {

                }
                else
                {
                    str1 =
                        "自从哥白尼在1543年提出日心说以来，120年已经过去了。" + CR +
                        CR +
                        CR +
                        "从那时起，许多天文学家就试图在大量观测数据的基础上，揭示" + CR +
                        "神之领域的法则。" + CR +
                        CR +
                        "其中，开普勒认为，太阳系的行星围绕以太阳为焦点的椭圆轨道" + CR +
                        "运行。" + CR +
                        CR +
                        "在这个时代，包括神学家在内的人们原认为，天上世界是亘古不" + CR +
                        "变的。行星围绕不完美的椭圆轨道运行、而非完美的圆形轨道运" + CR +
                        "行的说法，深深震慑了世人。";

                    str2 =
                        "几乎在同一时代，伽利略借助当时最新技术制作的望远镜观测月球" + CR +
                        "表面，发现月球也不是完美的球体。" + CR +
                        CR +
                        "天上世界有别于地上世界的说法，逐渐淡出视野。但完成揭示最终" + CR +
                        "真理的“统一理论”过程，却极为困难，伽利略和开普勒生前都没" + CR +
                        "能完成该理论。";

                    str3 =
                        "伽利略逝世25年后的1667年，伦敦皇家学会的虎克和法国科学院的" + CR +
                        "惠更斯等人，开始对伽利略的未尽事业进行不懈的探索。时有传言，" + CR +
                        "称剑桥大学有天才学生，" + CR +
                        CR +
                        CR +
                        "其人名为艾萨克 牛顿。";
                }
            }

            var fontSize = tm.m(__(30, 27), __(20, 18));

            var lbl1 = new cc.LabelTTF(str1, pp.font, fontSize);
            lbl1.attr({ anchorX: 0.5, anchorY: 1, x: cc.winSize.width / 2, y: 0 });
            if (lbl1.setLineHeight) lbl1.setLineHeight(fontSize + 5);

            var lbl2 = new cc.LabelTTF(str2, pp.font, fontSize);
            lbl2.attr({ anchorX: 0.5, anchorY: 1, x: cc.winSize.width / 2, y: lbl1.y - lbl1.height - fontSize*3 });
            if (lbl2.setLineHeight) lbl2.setLineHeight(fontSize + 5);

            var lbl3 = new cc.LabelTTF(str3, pp.font, fontSize);
            lbl3.attr({ anchorX: 0.5, anchorY: 1, x: cc.winSize.width / 2, y: lbl2.y - lbl2.height - fontSize*3 });
            if (lbl3.setLineHeight) lbl3.setLineHeight(fontSize + 5);

            var lyr = new cc.Layer();

            lyr.addChild(lbl1);
            lyr.addChild(lbl2);
            lyr.addChild(lbl3);

            clipper.addChild(lyr, 3);

            this.lyrStory = lyr;
            this.lblStory1 = lbl1;
            this.lblStory2 = lbl2;
            this.lblStory3 = lbl3;
        }

        // Sub Image
        {
            var sprFrm = new tm.Scale9SpriteTiled(tm.m(res.ImgM_FrmWithoutButton, res.Img_FrmWithoutButton));
            var sprImg = new cc.Sprite(res.Img_CutOpeningA);

            sprImg.scale = tm.m(2, 1);
            sprImg.getTexture().setAliasTexParameters();

            sprFrm.addChild(sprImg);
            sprFrm.setContentSize(sprImg.width * sprImg.scaleX + 80, sprImg.height * sprImg.scaleY + 60);
            sprFrm.attr({
                x: cc.winSize.width / 2,
                y: cc.winSize.height * 0.7
            });
            sprImg.attr({
                x: sprFrm.width/2,
                y: sprFrm.height/2
            });

            sprFrm.opacity = 1;
            this.addChild(sprFrm, 4);
            this.sprImage1 = sprFrm;
        }

        // Sub Image
        {
            var sprFrm = new tm.Scale9SpriteTiled(tm.m(res.ImgM_FrmWithoutButton, res.Img_FrmWithoutButton));
            var sprImg = new cc.Sprite(res.Img_CutOpeningB);

            sprImg.scale = tm.m(2, 1);
            sprImg.getTexture().setAliasTexParameters();

            sprFrm.addChild(sprImg);
            sprFrm.setContentSize(sprImg.width * sprImg.scaleX + 80, sprImg.height * sprImg.scaleY + 60);
            sprFrm.attr({
                x: cc.winSize.width / 2,
                y: cc.winSize.height * 0.7
            });
            sprImg.attr({
                x: sprFrm.width/2,
                y: sprFrm.height/2
            });

            sprFrm.opacity = 1;
            this.addChild(sprFrm, 4);
            this.sprImage2 = sprFrm;
        }

        pp.libCut.unlock(pp.getCutId(res.Img_CutOpeningA));
        pp.libCut.unlock(pp.getCutId(res.Img_CutOpeningB));
    },

    onEnter:function () {
        this._super();

        // Set up event manager
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) { return true; },
                    onTouchMoved: function (touch, event) { return true; },
                    onTouchEnded: this.onTouchEnded,
                    onTouchCancelled: function (touch, event) { return true; }
                }),
                this
            );
        }

    },

    showClickLabel: function () {

        this.status = 1;

        // Click to Start
        var label = new tm.LabelTTF(tm.m(">> Tap", ">> Click"), pp.font, tm.m(30, 20), cc.color.BLACK);
        label.attr({
            x: cc.winSize.width / 2,
            y: cc.winSize.height * 0.15
        });
        label.runAction(
            tm.repeatForever(
                cc.delayTime(0.2),
                cc.fadeTo(0.1, 0),
                cc.delayTime(0.1),
                cc.fadeTo(0.1, 255),
                cc.delayTime(0.1)
            )
        );
        this.addChild(label, 4);
    },

    onEnterTransitionDidFinish: function () {
        this._super();

        pp.mediator.setBgm(res.Mus_Title);

        this.lyrStory.runAction(
            cc.sequence(
                cc.delayTime(2),
                //cc.moveTo(40, this.lyrStory.x, 820),
                cc.moveTo(40, this.lyrStory.x, this.windowHeight - this.lblStory3.y),
                cc.callFunc(this.showClickLabel, this)
            )
        );

        this.sprImage1.runAction(
            cc.sequence(
                cc.delayTime(1),
                cc.fadeTo(1, 192),
                cc.delayTime(27),
                cc.fadeOut(1)
            )
        );

        this.sprImage2.runAction(
            cc.sequence(
                cc.delayTime(1 + 27 + 2),
                cc.fadeTo(1, 192)
            )
        );
    },

    onTouchEnded: function (touch, event) {
        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        //cc.log("CLICK!!");

        if (node.status == 0) {
            //cc.director.getActionManager().update(5);

            cc.director.getScheduler().setTimeScale(128);
            node.scheduleOnce(function () { cc.director.getScheduler().setTimeScale(1); }, 6.4);
        }
        else {
            cc.audioEngine.playEffect(res.Snd_OK);

            pp.mediator.suiDidGetUserInput();
        }
        return true;
    }

});


