
pp.ScnThemeMap = pp.Scn.extend({

    scrView: null,

    ctor: function () {

        this._super();

        this._name = "ScnThemeMap";

        // Caption
        var frmCaption;
        {
            frmCaption = new pp.FrmCaption(__("テーマ選択"), null, tm.m());
            frmCaption.attr({
                anchorX: 0,
                anchorY: 1,
                x: tm.m(1, 20),
                y: this.height - tm.m(pp.LYR_STATUS_BAR_HEIGHT, 20)
            });
            this.addChild(frmCaption, 2);
        }

        var scrView = this.scrView = new cc.ScrollView();
        var lyrThemeMap = new pp.LyrThemeMap(pp.mediator.personId, function (sel) {
            this.didGetUserInput(sel);
        }, this);

        scrView.setContainer(lyrThemeMap);
        scrView.setViewSize(cc.size(cc.winSize.width, cc.winSize.height - tm.m(frmCaption.height + pp.LYR_STATUS_BAR_HEIGHT + 120, 0)));
        scrView.setMinScale(tm.m(0.6, 1));
        scrView.setMaxScale(tm.m(1.0, 1));
        scrView.setZoomScale(0.6);
        scrView.setContentOffset(cc.p(0, 0));
        scrView.setClippingToBounds(false);
        scrView.setBounceable(tm.m());
        scrView.attr({
            x: 0,
            y: tm.m(120, 0)
        });

        this.addChild(scrView, 1);

        // Zoom Buttons
        if (tm.m()) {
            menuz = this.menu = new pp.MenuZoom(scrView);

            menuz.attr({
                anchorX: 0.5,
                x: 670,
                y: 160
            });
            this.addChild(menuz, 2);
        }

        // Cancel Button
        {
            var spr = new tm.Scale9SpriteTiled(res.Img_FrmCommand);
            spr.setContentSize(tm.m(this.width-2, 200), tm.m(120, 64));
            spr.attr({
                ignoreAnchor: false,
                anchorX: tm.m(0, 1),
                anchorY: tm.m(0, 1),
                x: tm.m(1, this.width - 20),
                y: tm.m(0, this.height - 20)
            });
            this.addChild(spr, 1);

            //    ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude, barVal) {
            var menu = new pp.MenuRect(
                [ __("キャンセル") ],
                function (obj) {
                    this.didGetUserInput(pp.cmCancel);
                },
                this);
            menu.attr({
                anchorY: 0.5,
                anchorX: 0.5,
                y: spr.height/2,
                x: spr.width/2
            });
            spr.addChild(menu);
        }

        // Background
        {
            var spr = new cc.Sprite(res.Img_TitUniverse);
            spr.attr({
                x: this.width,
                y: 0,
                scale: 1.2
            });
            this.addChild(spr);
            spr.runAction(
                cc.rotateBy(64000, 36000)
            );
        }

    },

    didGetUserInput: function (sel) {
        //cc.log("ScnThemeMap: sel=", sel);

        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(sel);
    }

});

pp.ScnPagedThemeMap = pp.ScnPaged.extend({

    scrView: null,

    ctor: function () {

        this._super(pp.PG_THEME_MAP);

        this._name = "ScnPagedThemeMap";

        // Caption
        var frmCaption;
        {
            var frmCaption = new pp.FrmCaption(__("テーマ一覧"), null, tm.m());
            frmCaption.attr({
                anchorX: 0,
                anchorY: 1,
                x: tm.m(1, 20),
                y: this.height - tm.m(pp.LYR_STATUS_BAR_HEIGHT, 20)
            });
            this.addChild(frmCaption, 2);
        }

        var scrView = this.scrView = new cc.ScrollView();
        var lyrThemeMap = new pp.LyrThemeMap(pp.mediator.personId, function (sel) {
            this.didGetUserInput(sel);
        }, this);

        scrView.setContainer(lyrThemeMap);
        scrView.setViewSize(cc.size(cc.winSize.width, cc.winSize.height - tm.m(frmCaption.height + pp.LYR_STATUS_BAR_HEIGHT + 120, 0)));
        scrView.setMinScale(tm.m(0.6, 1));
        scrView.setMaxScale(tm.m(1.0, 1));
        scrView.setZoomScale(0.6);
        scrView.setContentOffset(cc.p(0, 0));
        scrView.setClippingToBounds(false);
        scrView.setBounceable(tm.m());
        scrView.attr({
            x: 0,
            y: tm.m(120, 0)
        });

        this.addChild(scrView, 1);

        // Zoom Buttons
        if (tm.m()) {
            menuz = this.menu = new pp.MenuZoom(scrView);

            menuz.attr({
                anchorX: 0.5,
                x: 670,
                y: 160
            });
            this.addChild(menuz, 2);
        }

        // Background
        {
            var spr = new cc.Sprite(res.Img_TitUniverse);
            spr.attr({
                x: this.width,
                y: 0,
                scale: 1.2
            });
            this.addChild(spr);
            spr.runAction(
                cc.rotateBy(64000, 36000)
            );
        }

    },

    uiUpdate: function () {
        this._super();
        //this.frmThemeR.uiUpdate();
    },

    didGetUserInput: function (sel) {
        //cc.log("ScnThemeMap: sel=", sel);

        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(sel);
    }

});
