
pp.PIDX_JOB0 = tm.m(0, 2);
pp.PIDX_JOB1 = tm.m(1, 3);
pp.PIDX_JOB2 = tm.m(2, 1);
pp.PIDX_PERSON_D = tm.m(3, 0);
pp.PIDX_PERSON_E = tm.m(4, 4);
pp.PIDX_FACILI = tm.m(3, 0);

pp.ScnSociety = pp.Scn.extend({

    status: 0,

    societyId: 0,

    personIds: null,
    voiceIdx: 0,
    sprVoices: null,
    persons: null,

    reportId: 0,
    menu: null,

    ctor: function (societyId) {

        this._super();

        societyId = cc.isUndefined(societyId) ? 0 : societyId;

        this.societyId = societyId;
        var society = pp.world.societies[societyId];

        this.voiceIdx = -1;
        this.sprVoices = [];
        this.reportId = pp.idInvalid;

        // Background
        {
            sprWall = new cc.Sprite(res.Img_FullSociety);
            sprWall.attr({
                anchorX: tm.m(0.27, 0),
                anchorY: tm.m(0, 0),
                scale: tm.m(1.6, 1)
            });

            this.addChild(sprWall, 0);
        }

        // Boxes
        var marginX = tm.m(25, 30);
        var marginY = 10;

        var personsWithNoTitle = society.getPersonsWithNoTitle();
        var person3 = pp.world.persons[tm.m(pp.piJudgeC, pp.piJudgeB)];
        var person4 = pp.world.persons[tm.m(pp.piJudgeB, pp.piJudgeC)];
        if (tm.m()) {
            if (personsWithNoTitle.length >= 1 && pp.mediator.gameState == pp.gsTurn && !pp.mediator.isCheckingText) {
                // 論文審査 or 入会審査のときのみ
                person3 = personsWithNoTitle[0];
            }
        }
        else {
            if (personsWithNoTitle.length >= 1) {
                person3 = personsWithNoTitle[0];
            }
            if (personsWithNoTitle.length >= 2 && pp.mediator.gameState == pp.gsTurn && !pp.mediator.isCheckingText) {
                // 論文審査 or 入会審査のときのみ
                person4 = personsWithNoTitle[1];
            }
        }
        var persons = this.persons = tm.m(
            [
                society.job0Person,     // PersonA: 会長
                society.job1Person,     // PersonB
                society.job2Person,     // PersonC
                person3                 // PersonD
            ],
            [
                person4,                // PersonE
                society.job2Person,     // PersonC
                society.job0Person,     // PersonA: 会長
                society.job1Person,     // PersonB
                person3                 // PersonD
            ]);

        pp.mediator.personDId = tm.m(person3.id, person4.id);
        pp.mediator.personEId = tm.m(person4.id, person3.id);

        var titles =
            tm.m(
                [society.jobName0, society.jobName1, society.jobName2, __("会員")],
                [__("会員"), society.jobName2, society.jobName0, society.jobName1, __("会員")]
            );

        if (tm.m()) {
            var frame = new pp.Frm(res.Img_FrmDate);
            frame.setContentSize(this.width, 380);
            frame.attr({
                ignoreAnchor: false,
                anchorX: 0,
                anchorY: 0,
                x: 0,
                y: 1
            });
            this.addChild(frame, 2);
        }
        for (var i = tm.m(0, 0); i < tm.m(4, 5); i++) {
            // Frame
            var frame = tm.m(new cc.LayerColor(cc.color(0,0,0,0)), new pp.Frm(res.Img_FrmDate));
            frame.setContentSize(tm.m(160, 160), tm.m(380, 280));
            frame.attr({
                ignoreAnchor: false,
                anchorY: 0,
                x: this.width / 2 + (frame.width + marginX) * (i - tm.m(1.5, 2)),
                y: marginY
            });
            this.addChild(frame, 2);

            // Face
            var lyrFaceBack = new cc.LayerColor(cc.color.WHITE, tm.m(144, 96), tm.m(192, 128));
            var sprFace = new cc.Sprite(persons[i].imageFileName);
            sprFace.ignoreAnchor = true;
            sprFace.attr({
                anchorX: tm.m(0, 0.5),
                anchorY: tm.m(0, 0.5),
                scale: tm.m(1.5, 1)
            });
            lyrFaceBack.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 1,
                x: frame.width / 2,
                y: frame.height - 40
            });
            lyrFaceBack.addChild(sprFace);
            frame.addChild(lyrFaceBack);

            // Title
            var lblTitle = new tm.LabelTTF("【" + titles[i] + "】", pp.font, tm.m(27, 18), cc.color.BLACK);
            lblTitle.attr({
                x: lyrFaceBack.x,
                anchorY: 1,
                y: lyrFaceBack.y - lyrFaceBack.height - 10 + tm.p(0,0,2)
            });
            lblTitle.setFontFillColor(cc.color.YELLOW);
            //lblTitle.enableStroke(cc.color.BLACK, 2);
            frame.addChild(lblTitle);

            // Name
            var name = persons[i].isNpc() ? "" : persons[i].firstName + "\n" + persons[i].lastName;
            var lblName = new tm.LabelTTF(name, pp.font, tm.m(27, 18), cc.color.BLACK);
            lblName.attr({
                x: lblTitle.x,
                anchorY: 1,
                y: lblTitle.y - lblTitle.height - 6 + tm.p(0,0,6)
            });
            lblName.setHorizontalAlignment(cc.TEXT_ALIGNMENT_CENTER);
            lblName.setFontFillColor(cc.color.WHITE);
            //lblName.enableStroke(cc.color.BLACK, 2);
            frame.addChild(lblName);
        }

        // Date
        if (true) {
            var frmDate = new pp.FrmDateS();
            frmDate.updateLabels(societyId);
            this.addChild(frmDate, 3);
        }

        // Set up event manager
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) {
                        return true;
                    },
                    onTouchMoved: function (touch, event) {
                        return true;
                    },
                    onTouchEnded: this.onTouchEnded,
                    onTouchCancelled: function (touch, event) {
                        return true;
                    }
                }),
                this
            );
        }

    },

    createVoice: function (idx, voice) {

        if (voice.length < 12) {
            voice = (voice + "　　　　　　　　").substr(0, 12);
        }

        //var mes = tm.insertNewLines(voice, 30);
        var mes = voice;
        var sprVoice = new tm.Scale9SpriteTiled(
            res.Img_LyrBalloonUnder,
            cc.rect(140, 50, 382, 100));
        var lblVoice = new cc.LabelTTF(mes, pp.font, tm.m(__(27, 24), __(18, 16)));
        if (lblVoice.width > 500) {
            lblVoice.setDimensions(500,0);
        }
        sprVoice.setContentSize(lblVoice.width + tm.m(54, 40), lblVoice.height + tm.m(70, 56)); //50);
        lblVoice.attr({
            y: sprVoice.height - tm.m(22, 11),
            x: tm.m(22, 15),
            anchorX: 0,
            anchorY: 1,
            textAlign: cc.TEXT_ALIGNMENT_LEFT
        });
        lblVoice.setFontFillColor(cc.color.BLACK);

        sprVoice.addChild(lblVoice);
        sprVoice.attr({
            x: tm.m(10 + idx * 120, 10 + idx * 190),
            y: tm.m(400, 300),
            anchorX: 0,
            anchorY: 0
        });
        sprVoice.x += sprVoice.anchorX * sprVoice.width;
        //cc.log("lblVoice.width=" + lblVoice.width + ", anchorX=" + sprVoice.anchorX);
        if (idx > tm.m(1, 2)) {
            sprVoice.x = this.width - tm.m(-130 + (4-idx)*140, 10 + (4 - idx) * 190);
            sprVoice.scaleX = -1.0;
            lblVoice.scaleX = -1.0;
            lblVoice.anchorX = 1;
        }

        return sprVoice;
    },

    onTouchEnded: function (touch, event) {

        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        node.unschedule(node.onTimeOut);

        pp.mediator.suiDidGetUserInput();

        return true;
    },

    showVoice: function (personIdx, voice, allowOverlap, allowStay) {

        var newSprVoice = this.createVoice(personIdx, voice);
        var scaleX1 = newSprVoice.scaleX;
        var scaleY1 = newSprVoice.scaleY;
        newSprVoice.scaleY *= 0.1;
        newSprVoice.runAction(cc.scaleTo(0.2, scaleX1, scaleY1));

        if (!allowOverlap) {

            while (this.sprVoices.length > 0) {
                var sprVoice = this.sprVoices.shift();
                //sprVoice.removeFromParent();
                sprVoice.runAction(
                    cc.sequence(
                        cc.spawn(
                            cc.moveBy(0.2, 0, newSprVoice.height),
                            cc.fadeOut(0.2)
                        ),
                        cc.removeSelf()
                    )
                );
            }
        }

        if (!allowStay) {
            this.sprVoices.forEach(function (sprVoice) {
                //sprVoice.y += newSprVoice.height;
                sprVoice.runAction(cc.moveBy(0.2, 0, newSprVoice.height));
            });
        }

        this.addChild(newSprVoice, 3);
        this.sprVoices.push(newSprVoice);

        //---

        if (pp.mediator.messageWaitInSec != 0 && (pp.mediator.waitingMode & pp.MW_TIMEOUT)) {
            this.scheduleOnce(this.onTimeOut, pp.mediator.messageWaitInSec, "UI");
        }
    },

    setReportId: function (reportId) {
        this.reportId = reportId;
        this.updateMenu();
    },

    updateMenu: function () {

        // Info Button
        if (tm.m()) {

            if (this.reportId != pp.idInvalid) {

                var menu = this.menu = new pp.Menu(
                    [res.ImgM_IconReports],
                    function (item) {
                        pp.mediator.playSound(res.Snd_Click);

                        pp.Pop_from_pos = pp.mediator.lastClickPos;
                        pp.mediator.scn.addChild(new pp.PopReportTabbed(this.reportId), 102);
                    },
                    this,
                    cc.color(148, 48, 48)
                );

                menu.attr({
                    anchorX: 1,
                    anchorY: 1,
                    x: this.width - 20,
                    y: this.height - pp.LYR_STATUS_BAR_HEIGHT - 12
                });

                this.addChild(menu, 4);
            }
        }
    },

    personIdxFromId: function (personId) {
        for (var i = 0; i < this.persons.length; i++)
            if (this.persons[i].id == personId) return i;

        return pp.IDX_INVALID;
    },

    onTimeOut: function (elapsed) {

        /*
        if ((pp.mediator.waitingMode & pp.MW_TIMEOUT) == 0) {
            cc.log("I need to wait now....");
            return;
        }
        cc.log("NO NEED.");
        */

        pp.mediator.suiDidTimeOut();

        //this.unschedule(this.onTimeOut);
    },

    getLastVoice: function () {
        var sprVoices = this.sprVoices;
        return sprVoices[sprVoices.length-1];
    }

});


