
pp.CA_TITLE_FADE_IN_LOGO = 0;
pp.CA_TITLE_FADE_OUT_LOGO = 1;

pp.ScnTitle = pp.Scn.extend({

    sprLogo: null,
    sprLogo_jp: null,
    sprLogo_zh: null,
    lblVersion: null,

    ctor: function () {

        this._super();

        this._name = "ScnTitle";

        // Title Image
        {
            var spr = new cc.Sprite(tm.m(res.ImgM_TitPerson, res.Img_TitPerson));
            spr.ignoreAnchor = true;
            this.addChild(spr, 1);

            var spr = new cc.Sprite(tm.m(res.ImgM_TitLogo, res.Img_TitLogo));
            spr.ignoreAnchor = true;
            this.addChild(spr, 3);
            this.sprLogo = spr;
            spr.cascadeOpacity = true;
            spr.y = this.height; // hide

            {
                var spr = new cc.Sprite(tm.m(res.ImgM_TitLogo_jp, res.Img_TitLogo_jp));
                spr.ignoreAnchor = true;
                this.sprLogo.addChild(spr);
                this.sprLogo_jp = spr;
            }

            {
                var spr = new cc.Sprite(res.Img_TitLogo_zh);
                spr.ignoreAnchor = true;
                this.sprLogo.addChild(spr);
                this.sprLogo_zh = spr;
            }

            {
                var spr = new cc.Sprite(tm.m(res.ImgM_TitUniverse, res.Img_TitUniverse));
                spr.attr({
                    x: this.width,
                    y: 0,
                    rotation: 135
                });
                this.addChild(spr);
                spr.runAction(
                    cc.rotateBy(64000, 36000)
                );
            }
        }

        // Copyrights
        {
            var label = new tm.LabelTTF(
                tm.m(
                    "2017 © Shin Hirota All rights reserved.\n" +
                    "Music by Daisuke Shiiba."
                    ,
                    "1999, 2013, 2017 © Shin Hirota All rights reserved. " +
                    "Music by Daisuke Shiiba.\n" +
                    "Licensed to and published by Active Gaming Media, Inc."
                ),
                pp.font, 20, cc.color.BLACK);

            label.attr({
                anchorX: 0.5,
                anchorY: 0,
                x: cc.winSize.width / 2,
                y: 20
            });
            label.setHorizontalAlignment(cc.TEXT_ALIGNMENT_CENTER);
            this.addChild(label, 2);
        }

        // Some Description
        if (true)
        {
            var label = new tm.LabelTTF(
                tm.m(
                    "Version 1.0.1",
                    "Version 0.9-2017.11.06"),
                pp.font, 18, cc.color.BLACK);
            label.attr({
                x: cc.winSize.width * 0.85,
                y: tm.m(870, cc.winSize.height * 0.87)
            });
            this.addChild(label, 2);
            label.setFontFillColor(cc.color.WHITE);
            label.opacity = 0;
            this.lblVersion = label;
        }

    },

    onEnter:function () {
        this._super();
    },

    onEnterTransitionDidFinish: function () {
        this._super();
    },

    onCustomAction: function (actionId) {

        switch (actionId) {
            case pp.CA_TITLE_FADE_IN_LOGO:
            {
                this.sprLogo.attr({ x: 0, y: 100, scale: 2, opacity: 0 });
                this.sprLogo_jp.y = __(0, cc.winSize.height /* hide */, cc.winSize.height /* hide */);
                this.sprLogo_zh.y = __(cc.winSize.height /* hide */, cc.winSize.height /* hide */, 0);

                this.sprLogo.runAction(
                    cc.spawn(
                        cc.moveTo(0.5, cc.p(0, 0)),
                        cc.scaleTo(0.5, 1),
                        cc.fadeTo(0.5, 255)
                    )
                );

                if (this.lblVersion)
                    this.lblVersion.runAction(cc.fadeIn(1));

                break;
            }

            case pp.CA_TITLE_FADE_OUT_LOGO:
            {
                this.sprLogo.attr({ x: 0, y: 0, scale: 1, opacity: 255 });

                this.sprLogo.runAction(
                    cc.spawn(
                        cc.moveTo(0.5, cc.p(0, 100)),
                        cc.scaleTo(0.5, 2),
                        cc.fadeTo(0.5, 0)
                    )
                );

                if (this.lblVersion)
                    this.lblVersion.runAction(cc.fadeOut(0.5));

                break;
            }

        }
    }
});
