
pp.MAX_SCR_VIEW_HEIGHT = 380;
pp.SCR_BAR_WIDTH = 16;

pp.ScrorllBar = cc.Node.extend({

    scrView: null,
    mainScrView: null,
    scrBarBody: null,
    movedByMe: false,
    
    ctor: function (mainScrView) {
        
        this._super();

        var sprRail = new cc.Sprite(res.Img_ScrollBarRail);
        sprRail.attr({
            anchorX: 1,
            anchorY: 1
        });
        this.addChild(sprRail, 0);

        this.mainScrView = mainScrView;

        this.scrView = new cc.ScrollView();
        this.scrView.direction = cc.SCROLLVIEW_DIRECTION_VERTICAL;
        //this.scrView.bounceable = false;
        this.scrView.setViewSize(cc.size(pp.SCR_BAR_WIDTH, mainScrView.getViewSize().height));

        //var scrBarBody = this.scrBarBody = new cc.Sprite(res.Img_ScrollBar);
        var scrBarBody = this.scrBarBody = new cc.Scale9Sprite(res.Img_ScrollBar);

        this.scrView.attr({
            anchorX: 1,
            anchorY: 1,
            ignoreAnchor: false
        });

        scrBarBody.attr({
            anchorY: 0.5,
            anchorX: 0,
            x: 0
        });
        scrBarBody.setContentSize(pp.SCR_BAR_WIDTH, (mainScrView.getViewSize().height / mainScrView.getContainer().height) * this.scrView.getViewSize().height);

        var scrBarBodyBase = new cc.Layer(); //Color(cc.color.RED);
        scrBarBodyBase.width = pp.SCR_BAR_WIDTH;
        scrBarBodyBase.height = mainScrView.getViewSize().height * 2 - scrBarBody.height;
        scrBarBody.y = scrBarBodyBase.height/2;

        scrBarBodyBase.addChild(scrBarBody);
        this.scrView.setContainer(scrBarBodyBase);

        mainScrView.setDelegate(this);
        this.scrView.setDelegate(this);

        this.addChild(this.scrView, 1);
    },

    scrollViewDidScroll:function (scrView) {

        if (this.movedByMe) {
            this.movedByMe = false;
            return;
        }

        if (scrView == this.scrView) {
            // side scroll view moved
            var yrate = scrView.getContentOffset().y / (scrView.minContainerOffset().y - scrView.maxContainerOffset().y);
            //yrate = cc.clampf(yrate, 0, 1);
            this.movedByMe = true;
            this.mainScrView.setContentOffset(cc.p(0, (1 - yrate) * (this.mainScrView.minContainerOffset().y - this.mainScrView.maxContainerOffset().y)));
            //cc.log("yrate="+yrate);
        }
        else {
            // main scroll view moved
            var yrate = scrView.getContentOffset().y / (scrView.minContainerOffset().y - scrView.maxContainerOffset().y);
            //yrate = cc.clampf(yrate, 0, 1);
            this.movedByMe = true;
            this.scrView.setContentOffset(cc.p(0, (1 - yrate) * (this.scrView.minContainerOffset().y - this.scrView.maxContainerOffset().y)));
            //cc.log("yrate="+yrate);
        }
    }

});

pp.ScrollView = cc.ScrollView.extend({

    selectCallback: null,
    selectCallbackTarget: null,
    myTouchPos: 0,
    rowHeight: pp.ROW_HEIGHT,

    ctor: function (rowHeight) {
        this._super();

        this.rowHeight = rowHeight || pp.ROW_HEIGHT;

        // Add Scroll Event Handler
        cc.eventManager.addListener(
            cc.EventListener.create({
                event: cc.EventListener.MOUSE,
                onMouseMove: function (event) { return false; },
                onMouseUp: function (event) { return false; },
                onMouseDown: function (event) { return false; },
                onMouseScroll: function (event) {
                    var node = event.getCurrentTarget();
                    var dy = event.getScrollY();
                    //cc.log("dy=" + dy);
                    node.setBounceable(false);
                    node.setContentOffset(cc.pAdd(node.getContentOffset(), cc.p(0, -dy)));
                    node.setBounceable(true);
                    return true;
                }
            }),
            this
        );

        //cc.log(">> ScrollView: ctor called");

        // Add Click Event Handler
        cc.eventManager.addListener(
            cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: false,
                    onTouchBegan: this._onTouchBegan,
                    onTouchMoved: function (touch, event) { return; },
                    onTouchEnded: this._onTouchEnded,
                    onTouchCancelled: function (touch, event) { return; }
                }
            ),
            this);

        //cc.log("listener=" + this._touchListener);
    },

    onEnter: function () {
        //cc.log("ScrollView.onEnter() called...");
        this._super();
    },

    _onTouchBegan: function (touch, event) {
        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        //cc.log(">> ScrollView: _onTouchBegan touchPos=(" + touchPos.x + ", " + touchPos.y +")");
        //return false;

        node.myTouchPos = touchPos;
        return true;
    },

    _onTouchEnded: function (touch, event) {
        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        //cc.log(">> ScrollView: _onTouchEnded called pos=(" + touchPos.x + ", " + touchPos.y +") isInside=" + tm.isInside(touchPos, node));

        if (tm.isInside(touchPos, node) == false)
            return false;

        var dist = Math.abs(touchPos.x -node.myTouchPos.x) + Math.abs(touchPos.y-node.myTouchPos.y);
        if (dist < 3) {
            var y = node.getContentSize().height - (node.convertTouchToNodeSpace(touch).y - node.getContentOffset().y);
            var idxY = Math.floor(y / this.rowHeight);

            if (node.selectCallback) {
                node.selectCallback.call(node.selectCallbackTarget, idxY);
            }
        }
        return true;
    },

    scrollToShowNode: function (node) {
        var minVy = node.y + node.height - node.height * node.anchorY - this.height;
        var maxVy = node.y - node.height * node.anchorY;
        var minVx = node.x + node.width - node.width * node.anchorX- this.width;
        var maxVx = node.x - node.width * node.anchorX;
        var vy = -this.getContentOffset().y;
        var vx = -this.getContentOffset().x;

        var newVy = cc.clampf(vy, minVy, maxVy);
        var newVx = cc.clampf(vx, minVx, maxVx);

        //cc.log("contentOffset=(" + this.getContentOffset().x + ", " + this.getContentOffset().y + ") newVx="+newVx+", newVy="+newVy);

        this.setContentOffset(cc.p(-newVx, -newVy));
    }
});
